/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.PathChild;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.refactoring.GraphRefactoringException;
import org.simantics.graph.refactoring.MappingSpecification;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Root;
import org.simantics.graph.representation.TransferableGraph1;
import org.simantics.graph.representation.TransferableGraphUtils;
import org.simantics.graph.store.GraphStore;
import org.simantics.graph.store.IdentityStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphRefactoringUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphRefactoringUtils.class);

    public static boolean moveExternal(TransferableGraph1 tg, IdentityStore ids, Path from, PathChild to, TIntHashSet parentsAffected) throws GraphRefactoringException {
        int toParentId;
        int fromId = ids.pathToId(from);
        if (fromId < 0) {
            return false;
        }
        if (ids.isNewResource(fromId)) {
            throw new GraphRefactoringException("Cannot move internal resource " + String.valueOf(from) + ".");
        }
        int parentId = ids.removeIdentity(fromId);
        if (parentId >= 0) {
            parentsAffected.add(parentId);
        }
        if (ids.hasChild(toParentId = ids.createPathToId(to.parent), to.name)) {
            LOGGER.info("refactor statements from " + String.valueOf(from) + " to " + String.valueOf(to));
            int toId = ids.pathToId(to);
            int[] statements = tg.statements;
            int i = 0;
            while (i < tg.statements.length) {
                if (statements[i] == fromId) {
                    statements[i] = toId;
                }
                ++i;
            }
            return true;
        }
        ids.setIdentity(fromId, toParentId, to.name);
        return true;
    }

    public static void refactor(TransferableGraph1 tg, IdentityStore ids, MappingSpecification spec, TIntHashSet parentsAffected) throws GraphRefactoringException {
        for (MappingSpecification.MappingRule rule : spec.getRules()) {
            if (!(rule.to instanceof PathChild)) {
                throw new GraphRefactoringException("Invalid target URI " + String.valueOf(rule.to));
            }
            if (GraphRefactoringUtils.moveExternal(tg, ids, rule.from, (PathChild)rule.to, parentsAffected)) continue;
            LOGGER.warn("Didn't find " + String.valueOf(rule.from));
        }
    }

    public static boolean fixIncorrectRoot(Identity[] ids) {
        int i = 0;
        while (i < ids.length) {
            Identity id = ids[i];
            if (id.definition instanceof External) {
                External ext = (External)id.definition;
                if (ext.parent == -1 && (ext.name.equals("http:/") || ext.name.equals(""))) {
                    id.definition = new Root("", "");
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static void fixOntologyExport(TransferableGraph1 tg) {
        GraphRefactoringUtils.fixIncorrectRoot(tg.identities);
        GraphRefactoringUtils.fixOntologyRoot(tg, true);
    }

    private static Identity recursePath(TransferableGraph1 tg, String path) {
        Identity childIdentity;
        Identity extId = TransferableGraphUtils.findExternal(tg, path);
        if (extId != null) {
            return extId;
        }
        if ("http://".equals(path)) {
            return TransferableGraphUtils.findRootWithName(tg, "");
        }
        String[] parts = URIStringUtils.splitURI((String)path);
        Identity parentId = GraphRefactoringUtils.recursePath(tg, parts[0]);
        tg.identities = Arrays.copyOf(tg.identities, tg.identities.length + 1);
        tg.identities[tg.identities.length - 1] = childIdentity = new Identity(tg.resourceCount++, new External(parentId.resource, URIStringUtils.unescape((String)parts[1])));
        return childIdentity;
    }

    public static void fixOntologyRoot(TransferableGraph1 tg, boolean tryToFix) {
        Identity[] ids = tg.identities;
        int i = 0;
        while (i < ids.length) {
            Identity id = ids[i];
            if (id.definition instanceof Root) {
                TransferableGraph1 tgNew;
                int rootId;
                GraphStore store;
                Identity path;
                Root ext = (Root)id.definition;
                if (ext.name.startsWith("http://")) {
                    String[] parts = URIStringUtils.splitURI((String)ext.name);
                    path = GraphRefactoringUtils.recursePath(tg, parts[0]);
                    id.definition = new Internal(path.resource, URIStringUtils.unescape((String)parts[1]));
                    store = TransferableGraphConversion.convert(tg);
                    rootId = store.identities.createPathToId(UriUtils.uriToPathUnescaped(ext.name));
                    GraphRefactoringUtils.propagateNewMarks(store.identities, rootId);
                    tgNew = TransferableGraphConversion.convert(store);
                    tg.resourceCount = tgNew.resourceCount;
                    tg.identities = tgNew.identities;
                    tg.values = tgNew.values;
                    tg.statements = tgNew.statements;
                    return;
                }
                if (ext.type.startsWith("http://")) {
                    String first = "http://Projects/Development%20Project";
                    path = GraphRefactoringUtils.recursePath(tg, first);
                    id.definition = new Internal(path.resource, ext.name);
                    store = TransferableGraphConversion.convert(tg);
                    rootId = store.identities.createPathToId(UriUtils.uriToPathUnescaped(first + "/" + ext.name));
                    GraphRefactoringUtils.propagateNewMarks(store.identities, rootId);
                    tgNew = TransferableGraphConversion.convert(store);
                    tg.resourceCount = tgNew.resourceCount;
                    tg.identities = tgNew.identities;
                    tg.values = tgNew.values;
                    tg.statements = tgNew.statements;
                }
            }
            ++i;
        }
    }

    public static int relocateRelativeRoot(TransferableGraph1 tg, String uri) {
        Identity[] ids = tg.identities;
        int i = 0;
        while (i < ids.length) {
            Identity id = ids[i];
            if (id.definition instanceof Root) {
                Root ext = (Root)id.definition;
                if (ext.type.startsWith("http://")) {
                    int originalResourceCount = tg.resourceCount;
                    String[] parts = URIStringUtils.splitURI((String)uri);
                    Identity path = GraphRefactoringUtils.recursePath(tg, parts[0]);
                    id.definition = new Internal(path.resource, parts[1]);
                    GraphStore store = TransferableGraphConversion.convert(tg);
                    int rootId = store.identities.createPathToId(UriUtils.uriToPathUnescaped(uri));
                    GraphRefactoringUtils.propagateNewMarks(store.identities, rootId);
                    TransferableGraph1 tgNew = TransferableGraphConversion.convert(store);
                    int newResources = tgNew.resourceCount - originalResourceCount;
                    tg.resourceCount = tgNew.resourceCount;
                    tg.identities = tgNew.identities;
                    tg.values = tgNew.values;
                    tg.statements = tgNew.statements;
                    return newResources;
                }
            }
            ++i;
        }
        return 0;
    }

    private static void propagateNewMarks(IdentityStore identities, int resource) {
        if (identities.markNew(resource)) {
            int[] nArray = identities.getChildren(resource);
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int child = nArray[n2];
                GraphRefactoringUtils.propagateNewMarks(identities, child);
                ++n2;
            }
        }
    }

    public static void unfixIncorrectRoot(Identity[] ids) {
        int i = 0;
        while (i < ids.length) {
            Identity id = ids[i];
            if (id.definition instanceof Root) {
                Root root = (Root)id.definition;
                if (root.name.equals("") && root.type.equals("")) {
                    id.definition = new External(-1, "http:/");
                    return;
                }
            }
            ++i;
        }
    }
}

