/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.matching;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.ArrayList;
import org.simantics.graph.matching.GraphMatching;
import org.simantics.graph.matching.GraphMatchingStrategy;
import org.simantics.graph.representation.External;
import org.simantics.graph.representation.Identity;
import org.simantics.graph.representation.Internal;
import org.simantics.graph.representation.Optional;
import org.simantics.graph.representation.Root;

public enum IdentityMatchingStrategy implements GraphMatchingStrategy
{
    INSTANCE;


    public void mapUnmapped(int[] map, TIntIntHashMap inverses, Identity[] identities, int rangeCount) {
        Identity[] identityArray = identities;
        int n = identities.length;
        int n2 = 0;
        while (n2 < n) {
            Identity id = identityArray[n2];
            int r = id.resource;
            if (map[r] < 0) {
                map[r] = rangeCount++;
                if (inverses.containsKey(r)) {
                    map[inverses.get((int)r)] = rangeCount++;
                }
            }
            ++n2;
        }
    }

    @Override
    public void applyTo(GraphMatching matching) {
        new MatchingProcess(matching.aToB, matching.bToA, matching.aGraph.inverses, matching.bGraph.inverses, new IdentityTree(matching.aGraph.identities), new IdentityTree(matching.bGraph.identities)).execute();
        this.mapUnmapped(matching.aToB, matching.aGraph.inverses, matching.aGraph.identities, matching.bGraph.resourceCount);
        this.mapUnmapped(matching.bToA, matching.bGraph.inverses, matching.bGraph.identities, matching.aGraph.resourceCount);
        matching.recomputeSize();
    }

    static class IdentityTree {
        TIntObjectHashMap<ArrayList<NamedResource>> childMap = new TIntObjectHashMap();
        ArrayList<NamedResource> roots = new ArrayList();

        public IdentityTree(Identity[] indentities) {
            Identity[] identityArray = indentities;
            int n = indentities.length;
            int n2 = 0;
            while (n2 < n) {
                Identity id = identityArray[n2];
                if (id.definition instanceof External) {
                    def = (External)id.definition;
                    this.addChild(id.resource, def.parent, def.name);
                } else if (id.definition instanceof Internal) {
                    def = (Internal)id.definition;
                    this.addChild(id.resource, ((Internal)def).parent, ((Internal)def).name);
                } else if (id.definition instanceof Optional) {
                    def = (Optional)id.definition;
                    this.addChild(id.resource, ((Optional)def).parent, ((Optional)def).name);
                } else if (id.definition instanceof Root) {
                    this.addRoot(id.resource, ((Root)id.definition).name);
                }
                ++n2;
            }
        }

        private void addRoot(int root, String name) {
            this.roots.add(new NamedResource(name, root));
        }

        private void addChild(int child, int parent, String name) {
            ArrayList<NamedResource> children = (ArrayList<NamedResource>)this.childMap.get(parent);
            if (children == null) {
                children = new ArrayList<NamedResource>();
                this.childMap.put(parent, children);
            }
            children.add(new NamedResource(name, child));
        }
    }

    static class MatchingProcess {
        int[] aToB;
        int[] bToA;
        TIntIntHashMap aInv;
        TIntIntHashMap bInv;
        IdentityTree aTree;
        IdentityTree bTree;

        public MatchingProcess(int[] aToB, int[] bToA, TIntIntHashMap aInv, TIntIntHashMap bInv, IdentityTree aTree, IdentityTree bTree) {
            this.aToB = aToB;
            this.bToA = bToA;
            this.aInv = aInv;
            this.bInv = bInv;
            this.aTree = aTree;
            this.bTree = bTree;
        }

        public void execute() {
            this.match(this.aTree.roots, this.bTree.roots);
        }

        private void match(ArrayList<NamedResource> as, ArrayList<NamedResource> bs) {
            TObjectIntHashMap map = new TObjectIntHashMap();
            for (NamedResource b : bs) {
                map.put((Object)b.name, b.resource);
            }
            for (NamedResource a : as) {
                if (!map.contains((Object)a.name)) continue;
                this.match(a.resource, map.get((Object)a.name));
            }
        }

        private void match(int a, int b) {
            if (this.aToB[a] < 0 && this.bToA[b] < 0) {
                ArrayList as;
                this.aToB[a] = b;
                this.bToA[b] = a;
                if (this.aInv.contains(a) && this.bInv.contains(b)) {
                    this.match(this.aInv.get(a), this.bInv.get(b));
                }
                if ((as = (ArrayList)this.aTree.childMap.get(a)) == null) {
                    return;
                }
                ArrayList bs = (ArrayList)this.bTree.childMap.get(b);
                if (bs == null) {
                    return;
                }
                this.match(as, bs);
            }
        }
    }

    static class NamedResource {
        String name;
        int resource;

        public NamedResource(String name, int resource) {
            this.name = name;
            this.resource = resource;
        }
    }
}

