/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.template2d.ui.actions;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.template2d.ontology.Template2dResource;
import org.simantics.modeling.template2d.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.workbench.dialogs.ResourceListDialog;
import org.simantics.utils.datastructures.Pair;

public class AssignDrawingTemplate
implements ActionFactory,
ActionFactory2 {
    public Runnable create(Collection<?> targets) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Object target : targets) {
            if (!(target instanceof Resource)) {
                return null;
            }
            resources.add((Resource)target);
        }
        return targets.isEmpty() ? null : this.assign(resources);
    }

    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        return this.assign(Collections.singletonList((Resource)target));
    }

    private Runnable assign(final Collection<Resource> composites) {
        return new Runnable(){

            @Override
            public void run() {
                Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        AssignDrawingTemplate.this.assign(graph, composites);
                    }
                });
            }
        };
    }

    private void assign(ReadGraph graph, final Collection<Resource> composites) throws DatabaseException {
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Instances query = (Instances)graph.adapt(TEMPLATE2D.DrawingTemplate, Instances.class);
        Resource root = null;
        THashSet initialResources = new THashSet();
        for (Resource composite : composites) {
            if (!graph.isInstanceOf(composite, STR.Composite)) {
                return;
            }
            Resource r = (Resource)graph.sync((ReadInterface)new PossibleIndexRoot(composite));
            if (r == null || root != null && !r.equals(root)) {
                return;
            }
            root = r;
            Resource diagram = graph.getPossibleObject(composite, MOD.CompositeToDiagram);
            if (diagram == null) {
                return;
            }
            Resource initial = graph.getPossibleObject(diagram, TEMPLATE2D.HasDrawingTemplate);
            if (initial == null) continue;
            initialResources.add(initial);
        }
        final ArrayList<Pair> elements = new ArrayList<Pair>();
        for (Resource template : query.find(graph, root)) {
            String name = NameLabelUtil.modalName((ReadGraph)graph, (Resource)template);
            elements.add(Pair.make((Object)template, (Object)name));
        }
        Resource init = initialResources.size() == 1 ? (Resource)initialResources.iterator().next() : null;
        final Pair initialSelection = init != null ? Pair.make((Object)init, (Object)NameLabelUtil.modalName((ReadGraph)graph, (Resource)init)) : null;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                AssignDrawingTemplate.queryDrawingTemplate(composites, elements, (Pair<Resource, String>)initialSelection);
            }
        });
    }

    private static void queryDrawingTemplate(final Collection<Resource> composites, List<Pair<Resource, String>> elements, Pair<Resource, String> initialSelection) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        ResourceListDialog dialog = new ResourceListDialog(shell, "Select template from list", "Select diagram template to assign  (? = any character, * = any String)", new LabelProvider()){

            protected void createButtonsForButtonBar(Composite parent) {
                Button unassign = this.createButton(parent, 1024, "Unassign", false);
                unassign.setToolTipText("Remove Diagram Template Assignment");
                this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            }

            protected void buttonPressed(int buttonId) {
                super.buttonPressed(buttonId);
                if (buttonId == 1024) {
                    this.setSelectionResult(new Object[0]);
                    this.setReturnCode(0);
                    this.close();
                }
            }

            protected IDialogSettings getDialogBoundsSettings() {
                return Activator.getDefault().getDialogSettings();
            }
        };
        dialog.setElements(elements);
        dialog.sortElements();
        dialog.setInitialSelection(initialSelection);
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            Resource initialTemplate;
            Pair result = (Pair)dialog.getSingleResult();
            final Resource template = result != null ? (Resource)result.first : null;
            Resource resource = initialTemplate = initialSelection != null ? (Resource)initialSelection.first : null;
            if (!Objects.equals(template, initialTemplate)) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        AssignDrawingTemplate.assignTemplateToDiagrams(graph, composites, template);
                    }
                });
            }
        }
    }

    public static void assignTemplateToDiagrams(WriteGraph graph, Collection<Resource> composites, Resource template) throws DatabaseException {
        graph.markUndoPoint();
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Template2dResource TEMPLATE2D = Template2dResource.getInstance((ReadGraph)graph);
        StringBuilder comment = new StringBuilder();
        if (template != null) {
            comment.append("Assigned diagram template ").append(NameUtils.getSafeName((ReadGraph)graph, (Resource)template, (boolean)true)).append(" to diagram");
        } else {
            comment.append("Removed diagram template from diagram");
        }
        if (composites.size() > 1) {
            comment.append('s');
        }
        comment.append('\n');
        for (Resource composite : composites) {
            Resource diagram = graph.getSingleObject(composite, MOD.CompositeToDiagram);
            graph.deny(diagram, TEMPLATE2D.HasDrawingTemplate);
            if (template != null) {
                graph.claim(diagram, TEMPLATE2D.HasDrawingTemplate, null, template);
            }
            comment.append('\t').append(NameUtils.getSafeName((ReadGraph)graph, (Resource)composite, (boolean)true));
        }
        CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
        graph.addMetadata((Metadata)cm.add(comment.toString()));
    }

    private static class LabelProvider
    extends BaseLabelProvider
    implements ILabelProvider {
        private LabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return (String)((Pair)element).second;
        }
    }
}

