/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.ObjectResourceIdMap;
import org.simantics.db.common.WriteBindings;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.procedure.InternalProcedure;
import org.simantics.db.impl.query.IntProcedure;
import org.simantics.db.impl.query.QueryCache;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.query.QuerySerializerImpl;
import org.simantics.db.impl.query.SyncIntProcedure;
import org.simantics.db.impl.query.UnaryQueryP;
import org.simantics.db.service.CollectionSupport;

public final class ChildMap
extends UnaryQueryP<ObjectResourceIdMap<String>> {
    public ChildMap(int r) {
        super(r);
    }

    static final ChildMap entry(QueryProcessor provider, int r) {
        return (ChildMap)provider.cache.childMapMap.get(r);
    }

    @Override
    public final void removeEntry(QueryProcessor provider) {
        provider.cache.remove(this);
    }

    @Override
    public void compute(ReadGraphImpl graph, InternalProcedure<ObjectResourceIdMap<String>> procedure) throws DatabaseException {
        ChildMap.computeForEach(graph, this.id, this, procedure);
    }

    public static void computeForEach(ReadGraphImpl graph, int root, ChildMap entry, InternalProcedure<ObjectResourceIdMap<String>> procedure_) throws DatabaseException {
        InternalProcedure<ObjectResourceIdMap<String>> procedure = entry != null ? entry : procedure_;
        ChildMap.computeForEach2(graph, root, entry, procedure);
        if (entry != null) {
            entry.performFromCache(graph, procedure_);
        }
    }

    public static void computeForEach2(ReadGraphImpl graph, int root, final ChildMap parent, final InternalProcedure<ObjectResourceIdMap<String>> procedure) throws DatabaseException {
        if (root == 0) {
            procedure.execute(graph, null);
            return;
        }
        QueryProcessor processor = graph.processor;
        int consistsOf = processor.getConsistsOf();
        final int hasName = processor.getHasName();
        final ObjectResourceIdMap result = (ObjectResourceIdMap)graph.getService(CollectionSupport.class).createObjectResourceMap(String.class);
        QueryCache.runnerObjects(graph, root, consistsOf, parent, null, new SyncIntProcedure(){

            @Override
            public void run(ReadGraphImpl graph) throws DatabaseException {
                procedure.execute(graph, result);
            }

            @Override
            public void finished(ReadGraphImpl graph) throws DatabaseException {
                this.dec(graph);
            }

            @Override
            public void execute(ReadGraphImpl graph, final int obj) throws DatabaseException {
                this.inc();
                QueryCache.runnerObjects(graph, obj, hasName, parent, null, new IntProcedure(){

                    @Override
                    public void execute(ReadGraphImpl graph, int i) throws DatabaseException {
                        this.inc();
                        QueryCache.runnerValueQuery(graph, i, parent, null, new InternalProcedure<byte[]>(){

                            @Override
                            public void execute(ReadGraphImpl graph, byte[] value) throws DatabaseException {
                                if (value != null) {
                                    try {
                                        Binding b = WriteBindings.STRING;
                                        Serializer serializer = b.serializer();
                                        String part = (String)serializer.deserialize(value);
                                        result.putId((Object)part, obj);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                this.dec(graph);
                            }

                            @Override
                            public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                                this.dec(graph);
                            }
                        });
                    }

                    @Override
                    public void finished(ReadGraphImpl graph) throws DatabaseException {
                        this.dec(graph);
                    }

                    @Override
                    public void exception(ReadGraphImpl graph, Throwable t) throws DatabaseException {
                        this.dec(graph);
                    }
                });
            }
        });
    }

    @Override
    public void serializeValue(QuerySerializerImpl serializer) {
        ObjectResourceIdMap is = (ObjectResourceIdMap)this.getResult();
        serializer.writeLE(is.size());
        for (String s : is.keySet()) {
            serializer.addString(s);
            serializer.addResource(is.getId((Object)s));
        }
    }

    public String toString() {
        return "ChildMap[" + this.id + "]";
    }
}

