/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.primitives.MutableBoolean;
import org.simantics.databoard.primitives.MutableByte;
import org.simantics.databoard.primitives.MutableDouble;
import org.simantics.databoard.primitives.MutableFloat;
import org.simantics.databoard.primitives.MutableInteger;
import org.simantics.databoard.primitives.MutableLong;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.db.ExternalValueSupport;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteOnlyRequest;
import org.simantics.db.exception.ArgumentException;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.impl.MemWatch;
import org.simantics.db.impl.graph.DelayedWriteGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.impl.internal.RandomAccessValueSupport;
import org.simantics.db.impl.internal.ResourceData;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.support.WriteRequestScheduleSupport;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.DelayedWriteResult;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteEvents;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteOnlyResult;
import org.simantics.db.request.WriteResult;
import org.simantics.db.request.WriteTraits;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WriteGraphImpl
extends ReadGraphImpl
implements WriteGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteGraphImpl.class);
    public static final Binding DATA_TYPE_BINDING = Bindings.getBindingUnchecked(Datatype.class);
    public final WriteSupport writeSupport;
    public final VirtualGraph provider;
    Map<Object, Resource> builtinValues = new IdentityHashMap<Object, Resource>(40);

    private String resourceName(Resource resource) throws DatabaseException {
        throw new IllegalStateException();
    }

    private Layer0 getBuiltins() {
        return this.getService(Layer0.class);
    }

    private WriteRequestScheduleSupport getWriteRequestScheduler() {
        return (WriteRequestScheduleSupport)this.getSession();
    }

    private WriteGraphImpl(CacheEntry parent2, QueryProcessor readSupport, WriteSupport writeSupport, VirtualGraph provider) {
        super(null, parent2, readSupport);
        this.writeSupport = writeSupport;
        this.provider = provider;
    }

    public static final WriteGraphImpl create(QueryProcessor support, WriteSupport writeSupport, VirtualGraph provider) {
        WriteGraphImpl impl = new WriteGraphImpl(null, support, writeSupport, provider);
        try {
            writeSupport.setDefaultClusterSet(null);
        }
        catch (ServiceException e) {
            LOGGER.error("Failed to reset default cluster set for new WriteGraph", (Throwable)e);
        }
        return impl;
    }

    public final WriteGraphImpl newAsync() {
        return this;
    }

    public WriteGraphImpl newSync(VirtualGraph provider) {
        return new WriteGraphImpl(this.parent, this.processor, this.writeSupport, provider);
    }

    public final WriteGraphImpl newSync(CacheEntry parent) {
        return new WriteGraphImpl(parent, this.processor, this.writeSupport, this.provider);
    }

    @Override
    public ReadGraphImpl newRestart(ReadGraphImpl impl) {
        WriteGraphImpl write = (WriteGraphImpl)this.processor.getSession().getService(WriteGraphImpl.class);
        return write;
    }

    public final Resource newResource() throws ServiceException {
        try {
            Resource result = this.writeSupport.createResource(this.provider);
            return result;
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public final Resource newResource(long clusterId) throws ServiceException {
        try {
            Resource result = this.writeSupport.createResource(this.provider, clusterId);
            return result;
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Resource newResource(Resource clusterSet) throws ServiceException {
        try {
            Resource result = this.provider != null ? this.writeSupport.createResource(this.provider) : this.writeSupport.createResource(this.provider, clusterSet);
            return result;
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void newClusterSet(Resource clusterSet) throws ServiceException {
        try {
            if (this.provider == null) {
                this.writeSupport.createClusterSet(this.provider, clusterSet);
            }
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public Resource setClusterSet4NewResource(Resource clusterSet) throws ServiceException {
        return this.writeSupport.setDefaultClusterSet(clusterSet);
    }

    static boolean safeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    @Override
    public void asyncRequest(DelayedWrite request) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, e -> {
            if (e != null) {
                LOGGER.error("asyncRequest(DelayedWrite {}) failed", (Object)request, (Object)e);
            }
        }, null, Boolean.TRUE);
    }

    @Override
    public void asyncRequest(DelayedWrite request, Consumer<DatabaseException> callback) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, callback, null, Boolean.TRUE);
    }

    @Override
    public <T> void asyncRequest(DelayedWriteResult<T> request, Procedure<T> procedure) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, procedure, null, Boolean.TRUE);
    }

    @Override
    public void asyncRequest(Write r) {
        assert (r != null);
        this.getWriteRequestScheduler().scheduleRequest(r, e -> {
            if (e != null) {
                LOGGER.error("asyncRequest(Write {}) failed", (Object)r, (Object)e);
            }
        }, null, Boolean.TRUE);
    }

    @Override
    public void asyncRequest(Write request, Consumer<DatabaseException> callback) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, callback, null, Boolean.TRUE);
    }

    @Override
    public void asyncRequest(WriteOnly request) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, e -> {
            if (e != null) {
                LOGGER.error("asyncRequest(WriteOnly {}) failed", (Object)request, (Object)e);
            }
        }, null, Boolean.TRUE);
    }

    @Override
    public void asyncRequest(WriteOnly request, Consumer<DatabaseException> callback) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, callback, null, Boolean.TRUE);
    }

    @Override
    public <T> void asyncRequest(WriteOnlyResult<T> request, Procedure<T> procedure) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, procedure, null, Boolean.TRUE);
    }

    @Override
    public <T> void asyncRequest(WriteResult<T> request, Procedure<T> procedure) {
        assert (request != null);
        this.getWriteRequestScheduler().scheduleRequest(request, procedure, null, Boolean.TRUE);
    }

    @Override
    public void syncRequest(Write request) throws DatabaseException {
        Resource defaultClusterSet = this.setClusterSet4NewResource(null);
        WriteGraphImpl graph = this.newSync(request.getProvider());
        try {
            try {
                this.writeSupport.performWriteRequest((WriteGraph)graph, request);
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        finally {
            this.setClusterSet4NewResource(defaultClusterSet);
        }
    }

    @Override
    public <T> T syncRequest(WriteResult<T> request) throws DatabaseException {
        Resource defaultClusterSet = this.setClusterSet4NewResource(null);
        WriteGraphImpl graph = this.newSync(request.getProvider());
        try {
            T t = this.writeSupport.performWriteRequest((WriteGraph)graph, request);
            return t;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            this.setClusterSet4NewResource(defaultClusterSet);
            this.fireAfterListeners(request);
        }
    }

    @Override
    public void syncRequest(final DelayedWrite request) throws DatabaseException {
        try {
            try {
                final DelayedWriteGraph dwg = new DelayedWriteGraph((ReadGraph)this);
                request.perform((WriteGraph)dwg);
                this.syncRequest((WriteOnly)new WriteOnlyRequest(){

                    public void perform(WriteOnlyGraph graph) throws DatabaseException {
                        dwg.commit(graph, (WriteTraits)request);
                    }
                });
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new DatabaseException(e);
            }
        }
        finally {
            this.fireAfterListeners(request);
        }
    }

    @Override
    public void syncRequest(WriteOnly request) throws DatabaseException {
        Resource defaultClusterSet = this.setClusterSet4NewResource(null);
        try {
            try {
                this.writeSupport.performWriteRequest((WriteGraph)this, request);
            }
            catch (DatabaseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new DatabaseException(t);
            }
        }
        finally {
            this.setClusterSet4NewResource(defaultClusterSet);
        }
    }

    public void claim(Resource subject, Resource predicate, Resource object) throws ServiceException {
        if (subject == null || predicate == null || object == null) {
            throw new ServiceException("Claim does not accept null arguments (subject=" + String.valueOf(subject) + ",predicate=" + String.valueOf(predicate) + ",object=" + String.valueOf(object) + ").");
        }
        if (this.processor.isImmutableForWriting(object)) {
            this.claim(subject, predicate, null, object);
        } else {
            this.claim(subject, predicate, this.getPossibleInverse(predicate), object);
        }
    }

    public void claim(Resource subject, Resource predicate, Resource inverse, Resource object) throws ServiceException {
        if (MemWatch.isLowOnMemory()) {
            this.writeSupport.gc();
        }
        if (subject == null) {
            throw new ServiceException("Claim does not accept null arguments (subject).");
        }
        if (predicate == null) {
            throw new ServiceException("Claim does not accept null arguments (predicate).");
        }
        if (object == null) {
            throw new ServiceException("Claim does not accept null arguments (object).");
        }
        if (this.provider == null && subject.isPersistent() && !object.isPersistent()) {
            throw new ServiceException("Cannot claim persistent statements where subject is persistent and object is virtual. Persistent database cannot contain statements that refer to virtual graphs.");
        }
        try {
            this.writeSupport.claim(this.provider, subject, predicate, object);
        }
        catch (RuntimeException e) {
            throw new ServiceException((Throwable)e);
        }
        if (inverse == null) {
            return;
        }
        if (subject.equals(object) && predicate.equals(inverse)) {
            return;
        }
        if (this.processor.isImmutableForWriting(object)) {
            return;
        }
        try {
            this.writeSupport.claim(this.provider, object, inverse, subject);
        }
        catch (RuntimeException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void deny(Resource subject) throws ServiceException {
        assert (subject != null);
        try {
            for (Statement stm : this.getStatements(subject, this.getBuiltins().IsWeaklyRelatedTo)) {
                if (!subject.equals(stm.getSubject())) continue;
                Resource inverse = this.getPossibleInverse(stm.getPredicate());
                this.deny(stm.getSubject(), stm.getPredicate(), inverse, stm.getObject());
            }
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public void deny(Resource subject, Resource predicate) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        try {
            for (Statement stm : this.getStatements(subject, predicate)) {
                if (!subject.equals(stm.getSubject())) continue;
                Resource inverse = this.getPossibleInverse(stm.getPredicate());
                this.deny(stm.getSubject(), stm.getPredicate(), inverse, stm.getObject());
            }
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public void deny(Resource subject, Resource predicate, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        try {
            for (Statement stm : this.getStatements(subject, predicate)) {
                if (!subject.equals(stm.getSubject()) || !object.equals(stm.getObject())) continue;
                Resource inverse = this.getPossibleInverse(stm.getPredicate());
                this.deny(stm.getSubject(), stm.getPredicate(), inverse, stm.getObject());
            }
        }
        catch (DatabaseException e) {
            throw new ServiceException(INTERNAL_ERROR_STRING, (Throwable)e);
        }
    }

    public void denyStatement(Resource subject, Resource predicate, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        Resource inverse = this.getPossibleInverse(predicate);
        this.deny(subject, predicate, inverse, object);
    }

    public void deny(Statement statement) throws ServiceException {
        assert (statement != null);
        this.denyStatement(statement.getSubject(), statement.getPredicate(), statement.getObject());
    }

    public void deny(Resource subject, Resource predicate, Resource inverse, Resource object) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        VirtualGraph provider = this.processor.getProvider(subject, predicate, object);
        this.deny(subject, predicate, inverse, object, provider);
    }

    public void deny(Resource subject, Resource predicate, Resource inverse, Resource object, VirtualGraph provider) throws ServiceException {
        assert (subject != null);
        assert (predicate != null);
        assert (object != null);
        try {
            this.writeSupport.removeStatement(provider, subject, predicate, object);
        }
        catch (Throwable e) {
            throw new InternalException("bug in deny(s,p,i,o)", e);
        }
        if (inverse == null || subject.equals(object) && predicate.equals(inverse)) {
            return;
        }
        if (this.processor.isImmutableForWriting(object)) {
            return;
        }
        try {
            this.writeSupport.removeStatement(provider, object, inverse, subject);
        }
        catch (Throwable e) {
            throw new InternalException("bug in deny(s,p,i,o)", e);
        }
    }

    public void claimValue(Resource resource, Object value) throws ServiceException {
        try {
            Binding b = Bindings.getBinding(value.getClass());
            this.claimValue(resource, value, b);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimValue(Resource resource, Object value, Binding binding) throws ServiceException {
        if (value == null) {
            throw new ServiceException("claimValue does not accept null value");
        }
        if (binding == null) {
            throw new ServiceException("claimValue does not accept null binding");
        }
        try {
            Serializer serializer = this.getSerializer(binding);
            byte[] data = serializer.serialize(value);
            this.writeSupport.claimValue(this.provider, resource, data);
        }
        catch (DatabaseException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (SerializationException e) {
            throw new ServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private void initBuiltinValues(Layer0 b) {
        if (!this.builtinValues.isEmpty()) {
            return;
        }
        this.builtinValues.put(String.class, b.String);
        this.builtinValues.put(Double.class, b.Double);
        this.builtinValues.put(Float.class, b.Float);
        this.builtinValues.put(Long.class, b.Long);
        this.builtinValues.put(Integer.class, b.Integer);
        this.builtinValues.put(Byte.class, b.Byte);
        this.builtinValues.put(Boolean.class, b.Boolean);
        this.builtinValues.put(Variant.class, b.Variant);
        this.builtinValues.put(String[].class, b.StringArray);
        this.builtinValues.put(double[].class, b.DoubleArray);
        this.builtinValues.put(float[].class, b.FloatArray);
        this.builtinValues.put(long[].class, b.LongArray);
        this.builtinValues.put(int[].class, b.IntegerArray);
        this.builtinValues.put(byte[].class, b.ByteArray);
        this.builtinValues.put(boolean[].class, b.BooleanArray);
        this.builtinValues.put(MutableString.class, b.String);
        this.builtinValues.put(MutableDouble.class, b.Double);
        this.builtinValues.put(MutableFloat.class, b.Float);
        this.builtinValues.put(MutableLong.class, b.Long);
        this.builtinValues.put(MutableInteger.class, b.Integer);
        this.builtinValues.put(MutableByte.class, b.Byte);
        this.builtinValues.put(MutableBoolean.class, b.Boolean);
        this.builtinValues.put(Datatypes.DOUBLE, b.Double);
        this.builtinValues.put(Datatypes.STRING, b.String);
        this.builtinValues.put(Datatypes.INTEGER, b.Integer);
        this.builtinValues.put(Datatypes.LONG, b.Long);
        this.builtinValues.put(Datatypes.FLOAT, b.Float);
        this.builtinValues.put(Datatypes.BYTE, b.Byte);
        this.builtinValues.put(Datatypes.BOOLEAN, b.Boolean);
        this.builtinValues.put(Datatypes.VARIANT, b.Variant);
        this.builtinValues.put(Datatypes.DOUBLE_ARRAY, b.DoubleArray);
        this.builtinValues.put(Datatypes.STRING_ARRAY, b.StringArray);
        this.builtinValues.put(Datatypes.INTEGER_ARRAY, b.IntegerArray);
        this.builtinValues.put(Datatypes.LONG_ARRAY, b.LongArray);
        this.builtinValues.put(Datatypes.FLOAT_ARRAY, b.FloatArray);
        this.builtinValues.put(Datatypes.BYTE_ARRAY, b.ByteArray);
        this.builtinValues.put(Datatypes.BOOLEAN_ARRAY, b.BooleanArray);
        this.builtinValues.put(Datatypes.VARIANT_ARRAY, b.VariantArray);
    }

    private static Datatype canonicalizeToBuiltinDatatype(Datatype datatype) {
        if (datatype instanceof ArrayType) {
            ArrayType at = (ArrayType)datatype;
            if ((datatype = at.componentType()) instanceof ByteType) {
                return Datatypes.BYTE_ARRAY;
            }
            if (datatype instanceof DoubleType) {
                return Datatypes.DOUBLE_ARRAY;
            }
            if (datatype instanceof FloatType) {
                return Datatypes.FLOAT_ARRAY;
            }
            if (datatype instanceof IntegerType) {
                return Datatypes.INTEGER_ARRAY;
            }
            if (datatype instanceof LongType) {
                return Datatypes.LONG_ARRAY;
            }
            if (datatype instanceof BooleanType) {
                return Datatypes.BOOLEAN_ARRAY;
            }
            if (datatype instanceof StringType) {
                return Datatypes.STRING_ARRAY;
            }
            if (datatype instanceof VariantType) {
                return Datatypes.VARIANT_ARRAY;
            }
            return null;
        }
        if (datatype instanceof ByteType) {
            return Datatypes.BYTE;
        }
        if (datatype instanceof DoubleType) {
            return Datatypes.DOUBLE;
        }
        if (datatype instanceof FloatType) {
            return Datatypes.FLOAT;
        }
        if (datatype instanceof IntegerType) {
            return Datatypes.INTEGER;
        }
        if (datatype instanceof LongType) {
            return Datatypes.LONG;
        }
        if (datatype instanceof BooleanType) {
            return Datatypes.BOOLEAN;
        }
        if (datatype instanceof StringType) {
            return Datatypes.STRING;
        }
        if (datatype instanceof VariantType) {
            return Datatypes.VARIANT;
        }
        return null;
    }

    private Resource resolveBuiltinResourceType(Class<?> valueClass, Datatype datatype) {
        Resource type = this.builtinValues.get(valueClass);
        return type != null ? type : this.builtinValues.get(datatype);
    }

    private Resource resolveBuiltinResourceTypeByCanonicalizedDatatype(Datatype datatype, Resource defaultResult) {
        Datatype cdt = WriteGraphImpl.canonicalizeToBuiltinDatatype(datatype);
        return cdt != null ? this.builtinValues.get(cdt) : defaultResult;
    }

    public void addLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Layer0 b = this.getBuiltins();
        Resource valueResource = this.newResource();
        this.claim(valueResource, b.InstanceOf, null, type);
        this.claim(resource, predicate, inverse, valueResource);
        this.claimValue(valueResource, value, binding);
    }

    public void addLiteral(Resource resource, Resource predicate, Resource inverse, Object value, Binding binding) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Layer0 b = this.getBuiltins();
        this.initBuiltinValues(b);
        Resource literal = this.newResource();
        Datatype dt = binding.type();
        Resource type = this.resolveBuiltinResourceType(value.getClass(), dt);
        if (type == null) {
            type = this.resolveBuiltinResourceTypeByCanonicalizedDatatype(dt, b.Literal);
            Resource dataType = this.newResource();
            this.claim(dataType, b.InstanceOf, null, b.DataType);
            this.claimValue(dataType, dt, DATA_TYPE_BINDING);
            this.claim(literal, b.HasDataType, b.HasDataType_Inverse, dataType);
        }
        this.claim(literal, b.InstanceOf, null, type);
        this.claim(resource, predicate, inverse, literal);
        this.claimValue(literal, value, binding);
    }

    public <T extends Accessor> T newLiteral(Resource resource, Resource predicate, Datatype datatype, Object initialValue) throws DatabaseException {
        Layer0 b = this.getBuiltins();
        this.initBuiltinValues(b);
        Resource literal = this.newResource();
        this.claim(literal, b.InstanceOf, null, b.Literal);
        Resource dataType = this.newResource();
        this.claim(dataType, b.InstanceOf, null, b.DataType);
        this.claimValue(dataType, datatype, DATA_TYPE_BINDING);
        this.claim(literal, b.HasDataType, dataType);
        this.claim(resource, predicate, literal);
        return this.createAccessor(literal, datatype, initialValue);
    }

    public RandomAccessBinary createRandomAccessBinary(Resource resource, Resource predicate, Datatype datatype, Object initiaValue) throws DatabaseException {
        Layer0 b = this.getBuiltins();
        this.initBuiltinValues(b);
        Resource literal = this.newResource();
        this.claim(literal, b.InstanceOf, null, b.Literal);
        Resource dataType = this.newResource();
        this.claim(dataType, b.InstanceOf, null, b.DataType);
        this.claimValue(dataType, datatype, DATA_TYPE_BINDING);
        this.claim(literal, b.HasDataType, dataType);
        this.claim(resource, predicate, literal);
        return this.createRandomAccessBinary(literal, datatype, initiaValue);
    }

    public void claimLiteral(Resource resource, Resource predicate, Object value) throws ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding binding = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, value, binding);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Object value, Binding binding) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Layer0 b = this.getBuiltins();
        this.initBuiltinValues(b);
        Statement literalStatement = this.getPossibleStatement(resource, predicate);
        if (literalStatement != null && resource.equals(literalStatement.getSubject())) {
            this.claimValue(literalStatement.getObject(), value, binding);
        } else {
            Resource literal = this.newResource();
            Datatype dt = binding.type();
            Resource type = this.resolveBuiltinResourceType(value.getClass(), dt);
            if (type == null) {
                type = this.resolveBuiltinResourceTypeByCanonicalizedDatatype(dt, b.Literal);
                Resource dataType = this.newResource();
                this.claim(dataType, b.InstanceOf, null, b.DataType);
                this.claimValue(dataType, dt, DATA_TYPE_BINDING);
                this.claim(literal, b.HasDataType, null, dataType);
            }
            this.claim(literal, b.InstanceOf, null, type);
            this.claimValue(literal, value, binding);
            this.claim(resource, predicate, literal);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource type, Object value) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding binding = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, type, value, binding);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Layer0 b = this.getBuiltins();
        Statement literalStatement = this.getPossibleStatement(resource, predicate);
        if (literalStatement != null && resource.equals(literalStatement.getSubject())) {
            this.claimValue(literalStatement.getObject(), value, binding);
        } else {
            Resource literal = this.newResource();
            this.claim(literal, b.InstanceOf, null, type);
            this.claimValue(literal, value, binding);
            this.claim(resource, predicate, literal);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        try {
            Binding binding = Bindings.getBinding(value.getClass());
            this.claimLiteral(resource, predicate, inverse, type, value, binding);
        }
        catch (BindingConstructionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void claimLiteral(Resource resource, Resource predicate, Resource inverse, Resource type, Object value, Binding binding) throws BindingException, ManyObjectsForFunctionalRelationException, ServiceException {
        Layer0 b = this.getBuiltins();
        Statement literalStatement = this.getPossibleStatement(resource, predicate);
        if (literalStatement != null && resource.equals(literalStatement.getSubject())) {
            this.claimValue(literalStatement.getObject(), value, binding);
        } else {
            Resource literal = this.newResource();
            this.claim(literal, b.InstanceOf, null, type);
            this.claimValue(literal, value, binding);
            this.claim(resource, predicate, inverse, literal);
        }
    }

    public void denyValue(Resource resource) throws ServiceException {
        this.denyValue0(resource, null);
    }

    public void denyValue(Resource resource, VirtualGraph valueProvider) throws ServiceException {
        this.denyValue0(resource, valueProvider);
    }

    private void denyValue0(Resource resource, VirtualGraph valueProvider) throws ServiceException {
        if (valueProvider != null) {
            if (resource.isPersistent()) {
                throw new ArgumentException("Tried to remove literal value from persistent resource " + String.valueOf(resource) + " using virtual graph '" + this.provider.getIdentifier() + "'");
            }
            this.writeSupport.denyValue(valueProvider, resource);
        } else if (resource.isPersistent()) {
            this.writeSupport.denyValue(this.provider, resource);
        } else {
            Layer0 L0 = this.getBuiltins();
            if (valueProvider == null) {
                if (this.hasStatement(resource, L0.InstanceOf)) {
                    valueProvider = this.processor.getProvider(resource, L0.InstanceOf);
                } else if (this.hasStatement(resource, L0.Inherits)) {
                    valueProvider = this.processor.getProvider(resource, L0.Inherits);
                } else if (this.hasStatement(resource, L0.SubrelationOf)) {
                    valueProvider = this.processor.getProvider(resource, L0.SubrelationOf);
                }
            }
            if (valueProvider != null) {
                this.writeSupport.denyValue(valueProvider, resource);
            }
        }
    }

    public void denyValue(Resource resource, Resource predicate) throws ManyObjectsForFunctionalRelationException, ServiceException {
        Statement valueStatement = this.getPossibleStatement(resource, predicate);
        if (valueStatement != null && !valueStatement.isAsserted(resource)) {
            Resource value = valueStatement.getObject();
            Resource inverse = this.getPossibleInverse(predicate);
            if (this.provider != null) {
                this.deny(resource, predicate, inverse, value, this.provider);
                this.writeSupport.denyValue(this.provider, value);
            } else {
                VirtualGraph statementProvider = this.processor.getProvider(resource, valueStatement.getPredicate(), value);
                this.deny(resource, predicate, inverse, value, statementProvider);
                this.denyValue0(value, statementProvider);
            }
        }
    }

    public void flushCluster() {
        this.writeSupport.flushCluster();
    }

    public void flushCluster(Resource r) {
        this.writeSupport.flushCluster(r);
    }

    Object serialize(Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.isArray()) {
            return value;
        }
        if (Double.class == clazz) {
            return new double[]{(Double)value};
        }
        if (String.class == clazz) {
            return new String[]{(String)value};
        }
        if (Integer.class == clazz) {
            return new int[]{(Integer)value};
        }
        if (Boolean.class == clazz) {
            return new boolean[]{(Boolean)value};
        }
        if (Long.class == clazz) {
            return new long[]{(Long)value};
        }
        if (Byte.class == clazz) {
            return new byte[]{(Byte)value};
        }
        if (Float.class == clazz) {
            return new float[]{((Float)value).floatValue()};
        }
        return value;
    }

    public <T> void addMetadata(Metadata data) throws ServiceException {
        this.writeSupport.addMetadata(data);
    }

    public <T extends Metadata> T getMetadata(Class<T> clazz) throws ServiceException {
        return (T)this.writeSupport.getMetadata(clazz);
    }

    public TreeMap<String, byte[]> getMetadata() {
        return this.writeSupport.getMetadata();
    }

    @Override
    public String toString() {
        return "WriteGraphImpl[thread=" + String.valueOf(Thread.currentThread()) + "]";
    }

    public void commitAccessorChanges(WriteTraits writeTraits) {
        try {
            RandomAccessValueSupport ravs = (RandomAccessValueSupport)this.getSession().peekService(RandomAccessValueSupport.class);
            if (ravs == null) {
                return;
            }
            for (Pair<Resource, ResourceData> entry : ravs.entries()) {
                ResourceData rd = (ResourceData)entry.second;
                if (!rd.isChanged()) continue;
                Resource resource = (Resource)entry.first;
                try {
                    long bsize;
                    ExternalValueSupport evs = this.getService(ExternalValueSupport.class);
                    long vsize = rd.oldExternalValue ? evs.getValueSize((ReadGraph)this, resource) : -1L;
                    long left = bsize = rd.binaryFile.length();
                    long offset = 0L;
                    byte[] bytes = new byte[0x100000];
                    rd.binaryFile.reset();
                    rd.binaryFile.position(0L);
                    int count = 0;
                    while (left > 0L) {
                        int length = 0x100000L < left ? 0x100000 : (int)left;
                        rd.binaryFile.readFully(bytes, 0, length);
                        evs.writeValue((WriteGraph)this, resource, offset, length, bytes);
                        offset += (long)length;
                        left -= (long)length;
                        if ((count += length) <= 10000000) continue;
                        count = 0;
                        evs.wait4RequestsLess(1);
                    }
                    if (bsize >= vsize) continue;
                    evs.writeValue((WriteGraph)this, resource, bsize, 0, new byte[0]);
                }
                catch (DatabaseException e) {
                    LOGGER.error("Database failure while committing accessor changes for write {} and resource {}", new Object[]{writeTraits, resource, e});
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("I/O failure while committing accessor changes for write {}", (Object)writeTraits, (Object)e);
        }
        catch (RuntimeException e) {
            LOGGER.error("Unexpected runtime exception while committing accessor changes for write {}", (Object)writeTraits, (Object)e);
        }
    }

    public VirtualGraph getProvider() {
        return this.provider;
    }

    public void clearUndoList(WriteTraits writeTraits) {
        this.writeSupport.clearUndoList(writeTraits);
    }

    public void markUndoPoint() {
        this.writeSupport.startUndo();
    }

    private void fireAfterListeners(Object request) {
        if (request instanceof WriteEvents) {
            try {
                ((WriteEvents)request).afterListeners();
            }
            catch (Exception e) {
                LOGGER.error("Error while invoking WriteEvents.afterListeners", (Throwable)e);
            }
        }
    }
}

