/*
 * Decompiled with CFR 0.152.
 */
package com.infomatiq.jsi.rtree;

import com.infomatiq.jsi.Point;
import com.infomatiq.jsi.PriorityQueue;
import com.infomatiq.jsi.Rectangle;
import com.infomatiq.jsi.SpatialIndex;
import com.infomatiq.jsi.rtree.IRectangleTraverseProcedure;
import com.infomatiq.jsi.rtree.Logger;
import com.infomatiq.jsi.rtree.Node;
import com.infomatiq.jsi.rtree.SortedList;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntProcedure;
import gnu.trove.TIntStack;
import java.util.Properties;

public class RTree
implements SpatialIndex {
    private static final Logger log = Logger.getLogger(RTree.class.getName());
    private static final Logger deleteLog = Logger.getLogger(RTree.class.getName() + "-delete");
    private static final String version = "1.0b8";
    private static final int DEFAULT_MAX_NODE_ENTRIES = 10;
    int maxNodeEntries;
    int minNodeEntries;
    private TIntObjectHashMap<Node> nodeMap = new TIntObjectHashMap();
    private static final boolean INTERNAL_CONSISTENCY_CHECKING = false;
    private static final int ENTRY_STATUS_ASSIGNED = 0;
    private static final int ENTRY_STATUS_UNASSIGNED = 1;
    private byte[] entryStatus = null;
    private byte[] initialEntryStatus = null;
    private TIntStack parents = new TIntStack();
    private TIntStack parentsEntry = new TIntStack();
    private int treeHeight = 1;
    private int rootNodeId = 0;
    private int size = 0;
    private int highestUsedNodeId = this.rootNodeId;
    private TIntStack deletedNodeIds = new TIntStack();
    private TIntArrayList nearestIds = new TIntArrayList();
    private TIntArrayList savedValues = new TIntArrayList();
    private double savedPriority = 0.0;
    private SortedList nearestNIds = new SortedList();
    private PriorityQueue distanceQueue = new PriorityQueue(true);

    @Override
    public void init(Properties props) {
        if (props == null) {
            this.maxNodeEntries = 50;
            this.minNodeEntries = 20;
        } else {
            this.maxNodeEntries = Integer.parseInt(props.getProperty("MaxNodeEntries", "0"));
            this.minNodeEntries = Integer.parseInt(props.getProperty("MinNodeEntries", "0"));
            if (this.maxNodeEntries < 2) {
                log.warn("Invalid MaxNodeEntries = " + this.maxNodeEntries + " Resetting to default value of 10");
                this.maxNodeEntries = 10;
            }
            if (this.minNodeEntries < 1 || this.minNodeEntries > this.maxNodeEntries / 2) {
                log.warn("MinNodeEntries must be between 1 and MaxNodeEntries / 2");
                this.minNodeEntries = this.maxNodeEntries / 2;
            }
        }
        this.entryStatus = new byte[this.maxNodeEntries];
        this.initialEntryStatus = new byte[this.maxNodeEntries];
        int i = 0;
        while (i < this.maxNodeEntries) {
            this.initialEntryStatus[i] = 1;
            ++i;
        }
        Node root = new Node(this.rootNodeId, 1, this.maxNodeEntries);
        this.nodeMap.put(this.rootNodeId, root);
        log.debug("init()  MaxNodeEntries = " + this.maxNodeEntries + ", MinNodeEntries = " + this.minNodeEntries);
    }

    @Override
    public void add(Rectangle r, int id) {
        if (log.isDebugEnabled()) {
            log.debug("Adding rectangle " + String.valueOf(r) + ", id " + id);
        }
        this.add(r.minX, r.minY, r.maxX, r.maxY, id, 1);
        ++this.size;
    }

    private void add(double minX, double minY, double maxX, double maxY, int id, int level) {
        Node n = this.chooseNode(minX, minY, maxX, maxY, level);
        Node newLeaf = null;
        if (n.entryCount < this.maxNodeEntries) {
            n.addEntry(minX, minY, maxX, maxY, id);
        } else {
            newLeaf = this.splitNode(n, minX, minY, maxX, maxY, id);
        }
        Node newNode = this.adjustTree(n, newLeaf);
        if (newNode != null) {
            int oldRootNodeId = this.rootNodeId;
            Node oldRoot = this.getNode(oldRootNodeId);
            this.rootNodeId = this.getNextNodeId();
            ++this.treeHeight;
            Node root = new Node(this.rootNodeId, this.treeHeight, this.maxNodeEntries);
            root.addEntry(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY, newNode.nodeId);
            root.addEntry(oldRoot.mbrMinX, oldRoot.mbrMinY, oldRoot.mbrMaxX, oldRoot.mbrMaxY, oldRoot.nodeId);
            this.nodeMap.put(this.rootNodeId, root);
        }
    }

    @Override
    public boolean delete(Rectangle r, int id) {
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        Node n = null;
        int foundIndex = -1;
        while (foundIndex == -1 && this.parents.size() > 0) {
            n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                deleteLog.debug("searching node " + n.nodeId + ", from index " + startIndex);
                boolean contains = false;
                int i = startIndex;
                while (i < n.entryCount) {
                    if (Rectangle.contains(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], r.minX, r.minY, r.maxX, r.maxY)) {
                        this.parents.push(n.ids[i]);
                        this.parentsEntry.pop();
                        this.parentsEntry.push(i);
                        this.parentsEntry.push(-1);
                        contains = true;
                        break;
                    }
                    ++i;
                }
                if (contains) {
                    continue;
                }
            } else {
                foundIndex = n.findEntry(r.minX, r.minY, r.maxX, r.maxY, id);
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        if (foundIndex != -1) {
            n.deleteEntry(foundIndex);
            this.condenseTree(n);
            --this.size;
        }
        Node root = this.getNode(this.rootNodeId);
        while (root.entryCount == 1 && this.treeHeight > 1) {
            this.deletedNodeIds.push(this.rootNodeId);
            root.entryCount = 0;
            this.rootNodeId = root.ids[0];
            --this.treeHeight;
            root = this.getNode(this.rootNodeId);
        }
        if (this.size == 0) {
            root.mbrMinX = Double.MAX_VALUE;
            root.mbrMinY = Double.MAX_VALUE;
            root.mbrMaxX = -1.7976931348623157E308;
            root.mbrMaxY = -1.7976931348623157E308;
        }
        return foundIndex != -1;
    }

    @Override
    public void nearest(Point p, TIntProcedure v, float furthestDistance) {
        Node rootNode = this.getNode(this.rootNodeId);
        float furthestDistanceSq = furthestDistance * furthestDistance;
        this.nearest(p, rootNode, (double)furthestDistanceSq);
        this.nearestIds.forEach(v);
        this.nearestIds.reset();
    }

    private void createNearestNDistanceQueue(Point p, int count, float furthestDistance) {
        this.distanceQueue.reset();
        this.distanceQueue.setSortOrder(false);
        if (count <= 0) {
            return;
        }
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        double furthestDistanceSq = furthestDistance * furthestDistance;
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean near = false;
                int i = startIndex;
                while (i < n.entryCount) {
                    if (Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y) <= furthestDistanceSq) {
                        this.parents.push(n.ids[i]);
                        this.parentsEntry.pop();
                        this.parentsEntry.push(i);
                        this.parentsEntry.push(-1);
                        near = true;
                        break;
                    }
                    ++i;
                }
                if (near) {
                    continue;
                }
            } else {
                int i = 0;
                while (i < n.entryCount) {
                    double entryDistanceSq = Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
                    int entryId = n.ids[i];
                    if (entryDistanceSq <= furthestDistanceSq) {
                        this.distanceQueue.insert(entryId, entryDistanceSq);
                        while (this.distanceQueue.size() > count) {
                            int value = this.distanceQueue.getValue();
                            double distanceSq = this.distanceQueue.getPriority();
                            this.distanceQueue.pop();
                            if (distanceSq == this.distanceQueue.getPriority()) {
                                this.savedValues.add(value);
                                this.savedPriority = distanceSq;
                                continue;
                            }
                            this.savedValues.reset();
                        }
                        if (this.savedValues.size() > 0 && this.savedPriority == this.distanceQueue.getPriority()) {
                            int svi = 0;
                            while (svi < this.savedValues.size()) {
                                this.distanceQueue.insert(this.savedValues.get(svi), this.savedPriority);
                                ++svi;
                            }
                            this.savedValues.reset();
                        }
                        if (this.distanceQueue.getPriority() < furthestDistanceSq && this.distanceQueue.size() >= count) {
                            furthestDistanceSq = this.distanceQueue.getPriority();
                        }
                    }
                    ++i;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    @Override
    public void nearestNUnsorted(Point p, TIntProcedure v, int count, float furthestDistance) {
        this.createNearestNDistanceQueue(p, count, furthestDistance);
        while (this.distanceQueue.size() > 0) {
            v.execute(this.distanceQueue.getValue());
            this.distanceQueue.pop();
        }
    }

    @Override
    public void nearestN(Point p, TIntProcedure v, int count, float furthestDistance) {
        this.createNearestNDistanceQueue(p, count, furthestDistance);
        this.distanceQueue.setSortOrder(true);
        while (this.distanceQueue.size() > 0) {
            v.execute(this.distanceQueue.getValue());
            this.distanceQueue.pop();
        }
    }

    public void nearestN_orig(Point p, TIntProcedure v, int count, double furthestDistance) {
        if (count <= 0) {
            return;
        }
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        this.nearestNIds.init(count);
        double furthestDistanceSq = furthestDistance * furthestDistance;
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean near = false;
                int i = startIndex;
                while (i < n.entryCount) {
                    if (Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y) <= furthestDistanceSq) {
                        this.parents.push(n.ids[i]);
                        this.parentsEntry.pop();
                        this.parentsEntry.push(i);
                        this.parentsEntry.push(-1);
                        near = true;
                        break;
                    }
                    ++i;
                }
                if (near) {
                    continue;
                }
            } else {
                int i = 0;
                while (i < n.entryCount) {
                    double entryDistanceSq = Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
                    int entryId = n.ids[i];
                    if (entryDistanceSq <= furthestDistanceSq) {
                        this.nearestNIds.add(entryId, -entryDistanceSq);
                        double tempFurthestDistanceSq = -this.nearestNIds.getLowestPriority();
                        if (tempFurthestDistanceSq < furthestDistanceSq) {
                            furthestDistanceSq = tempFurthestDistanceSq;
                        }
                    }
                    ++i;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
        this.nearestNIds.forEachId(v);
    }

    @Override
    public void intersects(Rectangle r, TIntProcedure v) {
        Node rootNode = this.getNode(this.rootNodeId);
        this.intersects(r, v, rootNode);
    }

    @Override
    public void contains(Rectangle r, TIntProcedure v) {
        this.parents.reset();
        this.parents.push(this.rootNodeId);
        this.parentsEntry.reset();
        this.parentsEntry.push(-1);
        while (this.parents.size() > 0) {
            Node n = this.getNode(this.parents.peek());
            int startIndex = this.parentsEntry.peek() + 1;
            if (!n.isLeaf()) {
                boolean intersects = false;
                int i = startIndex;
                while (i < n.entryCount) {
                    if (Rectangle.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])) {
                        this.parents.push(n.ids[i]);
                        this.parentsEntry.pop();
                        this.parentsEntry.push(i);
                        this.parentsEntry.push(-1);
                        intersects = true;
                        break;
                    }
                    ++i;
                }
                if (intersects) {
                    continue;
                }
            } else {
                int i = 0;
                while (i < n.entryCount) {
                    if (Rectangle.contains(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) && !v.execute(n.ids[i])) {
                        return;
                    }
                    ++i;
                }
            }
            this.parents.pop();
            this.parentsEntry.pop();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Rectangle getBounds() {
        Rectangle bounds = null;
        Node n = this.getNode(this.getRootNodeId());
        if (n != null && n.entryCount > 0) {
            bounds = new Rectangle();
            bounds.minX = n.mbrMinX;
            bounds.minY = n.mbrMinY;
            bounds.maxX = n.mbrMaxX;
            bounds.maxY = n.mbrMaxY;
        }
        return bounds;
    }

    @Override
    public String getVersion() {
        return "RTree-1.0b8";
    }

    private int getNextNodeId() {
        int nextNodeId = 0;
        nextNodeId = this.deletedNodeIds.size() > 0 ? this.deletedNodeIds.pop() : 1 + this.highestUsedNodeId++;
        return nextNodeId;
    }

    public Node getNode(int id) {
        return this.nodeMap.get(id);
    }

    public int getHighestUsedNodeId() {
        return this.highestUsedNodeId;
    }

    public int getRootNodeId() {
        return this.rootNodeId;
    }

    private Node splitNode(Node n, double newRectMinX, double newRectMinY, double newRectMaxX, double newRectMaxY, int newId) {
        double initialArea = 0.0;
        if (log.isDebugEnabled()) {
            double unionMinX = Math.min(n.mbrMinX, newRectMinX);
            double unionMinY = Math.min(n.mbrMinY, newRectMinY);
            double unionMaxX = Math.max(n.mbrMaxX, newRectMaxX);
            double unionMaxY = Math.max(n.mbrMaxY, newRectMaxY);
            initialArea = (unionMaxX - unionMinX) * (unionMaxY - unionMinY);
        }
        System.arraycopy(this.initialEntryStatus, 0, this.entryStatus, 0, this.maxNodeEntries);
        Node newNode = null;
        newNode = new Node(this.getNextNodeId(), n.level, this.maxNodeEntries);
        this.nodeMap.put(newNode.nodeId, newNode);
        this.pickSeeds(n, newRectMinX, newRectMinY, newRectMaxX, newRectMaxY, newId, newNode);
        while (n.entryCount + newNode.entryCount < this.maxNodeEntries + 1) {
            int i;
            if (this.maxNodeEntries + 1 - newNode.entryCount == this.minNodeEntries) {
                i = 0;
                while (i < this.maxNodeEntries) {
                    if (this.entryStatus[i] == 1) {
                        this.entryStatus[i] = 0;
                        if (n.entriesMinX[i] < n.mbrMinX) {
                            n.mbrMinX = n.entriesMinX[i];
                        }
                        if (n.entriesMinY[i] < n.mbrMinY) {
                            n.mbrMinY = n.entriesMinY[i];
                        }
                        if (n.entriesMaxX[i] > n.mbrMaxX) {
                            n.mbrMaxX = n.entriesMaxX[i];
                        }
                        if (n.entriesMaxY[i] > n.mbrMaxY) {
                            n.mbrMaxY = n.entriesMaxY[i];
                        }
                        ++n.entryCount;
                    }
                    ++i;
                }
                break;
            }
            if (this.maxNodeEntries + 1 - n.entryCount == this.minNodeEntries) {
                i = 0;
                while (i < this.maxNodeEntries) {
                    if (this.entryStatus[i] == 1) {
                        this.entryStatus[i] = 0;
                        newNode.addEntry(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], n.ids[i]);
                        n.ids[i] = -1;
                    }
                    ++i;
                }
                break;
            }
            this.pickNext(n, newNode);
        }
        n.reorganize(this);
        if (log.isDebugEnabled()) {
            double newArea = Rectangle.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY) + Rectangle.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY);
            double percentageIncrease = 100.0 * (newArea - initialArea) / initialArea;
            log.debug("Node " + n.nodeId + " split. New area increased by " + percentageIncrease + "%");
        }
        return newNode;
    }

    private void pickSeeds(Node n, double newRectMinX, double newRectMinY, double newRectMaxX, double newRectMaxY, int newId, Node newNode) {
        double normalizedSeparation;
        double tempHigh;
        double tempLow;
        double maxNormalizedSeparation = -1.0;
        int highestLowIndex = -1;
        int lowestHighIndex = -1;
        if (newRectMinX < n.mbrMinX) {
            n.mbrMinX = newRectMinX;
        }
        if (newRectMinY < n.mbrMinY) {
            n.mbrMinY = newRectMinY;
        }
        if (newRectMaxX > n.mbrMaxX) {
            n.mbrMaxX = newRectMaxX;
        }
        if (newRectMaxY > n.mbrMaxY) {
            n.mbrMaxY = newRectMaxY;
        }
        double mbrLenX = n.mbrMaxX - n.mbrMinX;
        double mbrLenY = n.mbrMaxY - n.mbrMinY;
        if (log.isDebugEnabled()) {
            log.debug("pickSeeds(): NodeId = " + n.nodeId);
        }
        double tempHighestLow = newRectMinX;
        int tempHighestLowIndex = -1;
        double tempLowestHigh = newRectMaxX;
        int tempLowestHighIndex = -1;
        int i = 0;
        while (i < n.entryCount) {
            tempLow = n.entriesMinX[i];
            if (tempLow >= tempHighestLow) {
                tempHighestLow = tempLow;
                tempHighestLowIndex = i;
            } else {
                tempHigh = n.entriesMaxX[i];
                if (tempHigh <= tempLowestHigh) {
                    tempLowestHigh = tempHigh;
                    tempLowestHighIndex = i;
                }
            }
            double d = normalizedSeparation = mbrLenX == 0.0 ? 1.0 : (tempHighestLow - tempLowestHigh) / mbrLenX;
            if (normalizedSeparation > 1.0 || normalizedSeparation < -1.0) {
                log.error("Invalid normalized separation X");
            }
            if (log.isDebugEnabled()) {
                log.debug("Entry " + i + ", dimension X: HighestLow = " + tempHighestLow + " (index " + tempHighestLowIndex + "), LowestHigh = " + tempLowestHigh + " (index " + tempLowestHighIndex + ", NormalizedSeparation = " + normalizedSeparation);
            }
            if (normalizedSeparation >= maxNormalizedSeparation) {
                highestLowIndex = tempHighestLowIndex;
                lowestHighIndex = tempLowestHighIndex;
                maxNormalizedSeparation = normalizedSeparation;
            }
            ++i;
        }
        tempHighestLow = newRectMinY;
        tempHighestLowIndex = -1;
        tempLowestHigh = newRectMaxY;
        tempLowestHighIndex = -1;
        i = 0;
        while (i < n.entryCount) {
            tempLow = n.entriesMinY[i];
            if (tempLow >= tempHighestLow) {
                tempHighestLow = tempLow;
                tempHighestLowIndex = i;
            } else {
                tempHigh = n.entriesMaxY[i];
                if (tempHigh <= tempLowestHigh) {
                    tempLowestHigh = tempHigh;
                    tempLowestHighIndex = i;
                }
            }
            double d = normalizedSeparation = mbrLenY == 0.0 ? 1.0 : (tempHighestLow - tempLowestHigh) / mbrLenY;
            if (normalizedSeparation > 1.0 || normalizedSeparation < -1.0) {
                log.error("Invalid normalized separation Y");
            }
            if (log.isDebugEnabled()) {
                log.debug("Entry " + i + ", dimension Y: HighestLow = " + tempHighestLow + " (index " + tempHighestLowIndex + "), LowestHigh = " + tempLowestHigh + " (index " + tempLowestHighIndex + ", NormalizedSeparation = " + normalizedSeparation);
            }
            if (normalizedSeparation >= maxNormalizedSeparation) {
                highestLowIndex = tempHighestLowIndex;
                lowestHighIndex = tempLowestHighIndex;
                maxNormalizedSeparation = normalizedSeparation;
            }
            ++i;
        }
        if (highestLowIndex == lowestHighIndex) {
            highestLowIndex = -1;
            double tempMinY = newRectMinY;
            lowestHighIndex = 0;
            double tempMaxX = n.entriesMaxX[0];
            int i2 = 1;
            while (i2 < n.entryCount) {
                if (n.entriesMinY[i2] < tempMinY) {
                    tempMinY = n.entriesMinY[i2];
                    highestLowIndex = i2;
                } else if (n.entriesMaxX[i2] > tempMaxX) {
                    tempMaxX = n.entriesMaxX[i2];
                    lowestHighIndex = i2;
                }
                ++i2;
            }
        }
        if (highestLowIndex == -1) {
            newNode.addEntry(newRectMinX, newRectMinY, newRectMaxX, newRectMaxY, newId);
        } else {
            newNode.addEntry(n.entriesMinX[highestLowIndex], n.entriesMinY[highestLowIndex], n.entriesMaxX[highestLowIndex], n.entriesMaxY[highestLowIndex], n.ids[highestLowIndex]);
            n.ids[highestLowIndex] = -1;
            n.entriesMinX[highestLowIndex] = newRectMinX;
            n.entriesMinY[highestLowIndex] = newRectMinY;
            n.entriesMaxX[highestLowIndex] = newRectMaxX;
            n.entriesMaxY[highestLowIndex] = newRectMaxY;
            n.ids[highestLowIndex] = newId;
        }
        if (lowestHighIndex == -1) {
            lowestHighIndex = highestLowIndex;
        }
        this.entryStatus[lowestHighIndex] = 0;
        n.entryCount = 1;
        n.mbrMinX = n.entriesMinX[lowestHighIndex];
        n.mbrMinY = n.entriesMinY[lowestHighIndex];
        n.mbrMaxX = n.entriesMaxX[lowestHighIndex];
        n.mbrMaxY = n.entriesMaxY[lowestHighIndex];
    }

    private int pickNext(Node n, Node newNode) {
        double maxDifference = Double.NEGATIVE_INFINITY;
        int next = 0;
        boolean nextGroup = false;
        maxDifference = Double.NEGATIVE_INFINITY;
        if (log.isDebugEnabled()) {
            log.debug("pickNext()");
        }
        int i = 0;
        while (i < this.maxNodeEntries) {
            if (this.entryStatus[i] == 1) {
                double newNodeIncrease;
                double nIncrease;
                double difference;
                if (n.ids[i] == -1) {
                    log.error("Error: Node " + n.nodeId + ", entry " + i + " is null");
                }
                if ((difference = Math.abs((nIncrease = Rectangle.enlargement(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])) - (newNodeIncrease = Rectangle.enlargement(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i])))) > maxDifference) {
                    next = i;
                    nextGroup = nIncrease < newNodeIncrease ? false : (newNodeIncrease < nIncrease ? true : (Rectangle.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY) < Rectangle.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY) ? false : (Rectangle.area(newNode.mbrMinX, newNode.mbrMinY, newNode.mbrMaxX, newNode.mbrMaxY) < Rectangle.area(n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY) ? true : newNode.entryCount >= this.maxNodeEntries / 2)));
                    maxDifference = difference;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Entry " + i + " group0 increase = " + nIncrease + ", group1 increase = " + newNodeIncrease + ", diff = " + difference + ", MaxDiff = " + maxDifference + " (entry " + next + ")");
                }
            }
            ++i;
        }
        this.entryStatus[next] = 0;
        if (!nextGroup) {
            if (n.entriesMinX[next] < n.mbrMinX) {
                n.mbrMinX = n.entriesMinX[next];
            }
            if (n.entriesMinY[next] < n.mbrMinY) {
                n.mbrMinY = n.entriesMinY[next];
            }
            if (n.entriesMaxX[next] > n.mbrMaxX) {
                n.mbrMaxX = n.entriesMaxX[next];
            }
            if (n.entriesMaxY[next] > n.mbrMaxY) {
                n.mbrMaxY = n.entriesMaxY[next];
            }
            ++n.entryCount;
        } else {
            newNode.addEntry(n.entriesMinX[next], n.entriesMinY[next], n.entriesMaxX[next], n.entriesMaxY[next], n.ids[next]);
            n.ids[next] = -1;
        }
        return next;
    }

    private double nearest(Point p, Node n, double furthestDistanceSq) {
        int i = 0;
        while (i < n.entryCount) {
            double tempDistanceSq = Rectangle.distanceSq(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i], p.x, p.y);
            if (n.isLeaf()) {
                if (tempDistanceSq < furthestDistanceSq) {
                    furthestDistanceSq = tempDistanceSq;
                    this.nearestIds.reset();
                }
                if (tempDistanceSq <= furthestDistanceSq) {
                    this.nearestIds.add(n.ids[i]);
                }
            } else if (tempDistanceSq <= furthestDistanceSq) {
                furthestDistanceSq = this.nearest(p, this.getNode(n.ids[i]), furthestDistanceSq);
            }
            ++i;
        }
        return furthestDistanceSq;
    }

    private boolean intersects(Rectangle r, TIntProcedure v, Node n) {
        int i = 0;
        while (i < n.entryCount) {
            Node childNode;
            if (Rectangle.intersects(r.minX, r.minY, r.maxX, r.maxY, n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]) && (n.isLeaf() ? !v.execute(n.ids[i]) : !this.intersects(r, v, childNode = this.getNode(n.ids[i])))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void condenseTree(Node l) {
        Node n = l;
        Node parent = null;
        int parentEntry = 0;
        TIntStack eliminatedNodeIds = new TIntStack();
        while (n.level != this.treeHeight) {
            parent = this.getNode(this.parents.pop());
            parentEntry = this.parentsEntry.pop();
            if (n.entryCount < this.minNodeEntries) {
                parent.deleteEntry(parentEntry);
                eliminatedNodeIds.push(n.nodeId);
            } else if (n.mbrMinX != parent.entriesMinX[parentEntry] || n.mbrMinY != parent.entriesMinY[parentEntry] || n.mbrMaxX != parent.entriesMaxX[parentEntry] || n.mbrMaxY != parent.entriesMaxY[parentEntry]) {
                double deletedMinX = parent.entriesMinX[parentEntry];
                double deletedMinY = parent.entriesMinY[parentEntry];
                double deletedMaxX = parent.entriesMaxX[parentEntry];
                double deletedMaxY = parent.entriesMaxY[parentEntry];
                parent.entriesMinX[parentEntry] = n.mbrMinX;
                parent.entriesMinY[parentEntry] = n.mbrMinY;
                parent.entriesMaxX[parentEntry] = n.mbrMaxX;
                parent.entriesMaxY[parentEntry] = n.mbrMaxY;
                parent.recalculateMBRIfInfluencedBy(deletedMinX, deletedMinY, deletedMaxX, deletedMaxY);
            }
            n = parent;
        }
        while (eliminatedNodeIds.size() > 0) {
            Node e = this.getNode(eliminatedNodeIds.pop());
            int j = 0;
            while (j < e.entryCount) {
                this.add(e.entriesMinX[j], e.entriesMinY[j], e.entriesMaxX[j], e.entriesMaxY[j], e.ids[j], e.level);
                e.ids[j] = -1;
                ++j;
            }
            e.entryCount = 0;
            this.deletedNodeIds.push(e.nodeId);
        }
    }

    private Node chooseNode(double minX, double minY, double maxX, double maxY, int level) {
        Node n = this.getNode(this.rootNodeId);
        this.parents.reset();
        this.parentsEntry.reset();
        while (true) {
            if (n == null) {
                log.error("Could not get root node (" + this.rootNodeId + ")");
            }
            if (n.level == level) {
                return n;
            }
            double leastEnlargement = Rectangle.enlargement(n.entriesMinX[0], n.entriesMinY[0], n.entriesMaxX[0], n.entriesMaxY[0], minX, minY, maxX, maxY);
            int index = 0;
            int i = 1;
            while (i < n.entryCount) {
                double tempMinX = n.entriesMinX[i];
                double tempMinY = n.entriesMinY[i];
                double tempMaxX = n.entriesMaxX[i];
                double tempMaxY = n.entriesMaxY[i];
                double tempEnlargement = Rectangle.enlargement(tempMinX, tempMinY, tempMaxX, tempMaxY, minX, minY, maxX, maxY);
                if (tempEnlargement < leastEnlargement || tempEnlargement == leastEnlargement && Rectangle.area(tempMinX, tempMinY, tempMaxX, tempMaxY) < Rectangle.area(n.entriesMinX[index], n.entriesMinY[index], n.entriesMaxX[index], n.entriesMaxY[index])) {
                    index = i;
                    leastEnlargement = tempEnlargement;
                }
                ++i;
            }
            this.parents.push(n.nodeId);
            this.parentsEntry.push(index);
            n = this.getNode(n.ids[index]);
        }
    }

    private Node adjustTree(Node n, Node nn) {
        while (n.level != this.treeHeight) {
            Node parent = this.getNode(this.parents.pop());
            int entry = this.parentsEntry.pop();
            if (parent.ids[entry] != n.nodeId) {
                log.error("Error: entry " + entry + " in node " + parent.nodeId + " should point to node " + n.nodeId + "; actually points to node " + parent.ids[entry]);
            }
            if (parent.entriesMinX[entry] != n.mbrMinX || parent.entriesMinY[entry] != n.mbrMinY || parent.entriesMaxX[entry] != n.mbrMaxX || parent.entriesMaxY[entry] != n.mbrMaxY) {
                parent.entriesMinX[entry] = n.mbrMinX;
                parent.entriesMinY[entry] = n.mbrMinY;
                parent.entriesMaxX[entry] = n.mbrMaxX;
                parent.entriesMaxY[entry] = n.mbrMaxY;
                parent.recalculateMBR();
            }
            Node newNode = null;
            if (nn != null) {
                if (parent.entryCount < this.maxNodeEntries) {
                    parent.addEntry(nn.mbrMinX, nn.mbrMinY, nn.mbrMaxX, nn.mbrMaxY, nn.nodeId);
                } else {
                    newNode = this.splitNode(parent, nn.mbrMinX, nn.mbrMinY, nn.mbrMaxX, nn.mbrMaxY, nn.nodeId);
                }
            }
            n = parent;
            nn = newNode;
            parent = null;
            newNode = null;
        }
        return nn;
    }

    public boolean checkConsistency() {
        return this.checkConsistency(this.rootNodeId, this.treeHeight, null);
    }

    private boolean checkConsistency(int nodeId, int expectedLevel, Rectangle expectedMBR) {
        Node n = this.getNode(nodeId);
        if (n == null) {
            log.error("Error: Could not read node " + nodeId);
            return false;
        }
        if (nodeId == this.rootNodeId && this.size() == 0 && n.level != 1) {
            log.error("Error: tree is empty but root node is not at level 1");
            return false;
        }
        if (n.level != expectedLevel) {
            log.error("Error: Node " + nodeId + ", expected level " + expectedLevel + ", actual level " + n.level);
            return false;
        }
        Rectangle calculatedMBR = this.calculateMBR(n);
        Rectangle actualMBR = new Rectangle();
        actualMBR.minX = n.mbrMinX;
        actualMBR.minY = n.mbrMinY;
        actualMBR.maxX = n.mbrMaxX;
        actualMBR.maxY = n.mbrMaxY;
        if (!actualMBR.equals(calculatedMBR)) {
            log.error("Error: Node " + nodeId + ", calculated MBR does not equal stored MBR");
            if (actualMBR.minX != n.mbrMinX) {
                log.error("  actualMinX=" + actualMBR.minX + ", calc=" + calculatedMBR.minX);
            }
            if (actualMBR.minY != n.mbrMinY) {
                log.error("  actualMinY=" + actualMBR.minY + ", calc=" + calculatedMBR.minY);
            }
            if (actualMBR.maxX != n.mbrMaxX) {
                log.error("  actualMaxX=" + actualMBR.maxX + ", calc=" + calculatedMBR.maxX);
            }
            if (actualMBR.maxY != n.mbrMaxY) {
                log.error("  actualMaxY=" + actualMBR.maxY + ", calc=" + calculatedMBR.maxY);
            }
            return false;
        }
        if (expectedMBR != null && !actualMBR.equals(expectedMBR)) {
            log.error("Error: Node " + nodeId + ", expected MBR (from parent) does not equal stored MBR");
            return false;
        }
        if (expectedMBR != null && actualMBR.sameObject(expectedMBR)) {
            log.error("Error: Node " + nodeId + " MBR using same rectangle object as parent's entry");
            return false;
        }
        int i = 0;
        while (i < n.entryCount) {
            if (n.ids[i] == -1) {
                log.error("Error: Node " + nodeId + ", Entry " + i + " is null");
                return false;
            }
            if (n.level > 1 && !this.checkConsistency(n.ids[i], n.level - 1, new Rectangle(n.entriesMinX[i], n.entriesMinY[i], n.entriesMaxX[i], n.entriesMaxY[i]))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Rectangle calculateMBR(Node n) {
        Rectangle mbr = new Rectangle();
        int i = 0;
        while (i < n.entryCount) {
            if (n.entriesMinX[i] < mbr.minX) {
                mbr.minX = n.entriesMinX[i];
            }
            if (n.entriesMinY[i] < mbr.minY) {
                mbr.minY = n.entriesMinY[i];
            }
            if (n.entriesMaxX[i] > mbr.maxX) {
                mbr.maxX = n.entriesMaxX[i];
            }
            if (n.entriesMaxY[i] > mbr.maxY) {
                mbr.maxY = n.entriesMaxY[i];
            }
            ++i;
        }
        return mbr;
    }

    public void traverse(IRectangleTraverseProcedure p) {
        this.nodeMap.forEachEntry((id, n) -> {
            p.call(id, n.mbrMinX, n.mbrMinY, n.mbrMaxX, n.mbrMaxY, n.level, (Node)n);
            return true;
        });
    }
}

