/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JRadioButton;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.swing.ComponentNode;

public class RadioButtonListNode
extends ComponentNode<Box>
implements ActionListener {
    private static final long serialVersionUID = 7073028693751719102L;
    protected boolean editable = true;
    protected Object value = "";
    protected String tooltip = "";
    protected double borderWidth = 0.0;
    protected transient ActionListener actionListener = null;
    protected Font font = null;
    protected Color color = null;
    protected Map<String, JRadioButton> items = new HashMap<String, JRadioButton>();

    public String toString() {
        return super.toString() + "[editable=" + this.editable + ", value=" + String.valueOf(this.value) + "]";
    }

    @Override
    public void init() {
        this.component = new Box(1);
        ((Box)this.component).setEnabled(this.editable);
        ((Box)this.component).setLocation(0, 0);
        super.init();
    }

    @INode.SyncField(value={"items"})
    public void setItems(List<String> items) {
        this.items.clear();
        ((Box)this.component).removeAll();
        for (String item : items) {
            JRadioButton btn = new JRadioButton();
            btn.setText(item);
            btn.addActionListener(this);
            ((Box)this.component).add(btn);
            this.items.put(item, btn);
        }
        if (items.size() > 0) {
            ((JRadioButton)((Box)this.component).getComponent(0)).setSelected(true);
        }
        ((Box)this.component).doLayout();
    }

    @INode.SyncField(value={"editable"})
    public void setEditable(boolean value) {
        this.editable = value;
        if (this.component != null) {
            ((Box)this.component).setEnabled(value);
        }
    }

    @INode.PropertySetter(value="Stroke Width")
    @INode.SyncField(value={"borderWidth"})
    public void setBorderWidth(Float borderWidth) {
        this.borderWidth = borderWidth.floatValue();
    }

    @INode.SyncField(value={"value"})
    public void setValue(Object value) {
        JRadioButton b;
        this.value = value;
        if (this.component != null && value != null && (b = this.items.get(value)) != null) {
            for (JRadioButton i : this.items.values()) {
                if (i == b) {
                    i.setSelected(true);
                    continue;
                }
                i.setSelected(false);
            }
        }
    }

    @INode.SyncField(value={"tooltip"})
    public void setToolTipText(String tooltip) {
        this.tooltip = tooltip;
        if (this.component != null) {
            ((Box)this.component).setToolTipText(tooltip);
        }
    }

    @INode.PropertySetter(value="Font")
    @INode.SyncField(value={"font"})
    public void setFont(Font font) {
        this.font = font;
        if (this.component != null) {
            this.setComponentFont(font);
        }
    }

    @INode.PropertySetter(value="Color")
    @INode.SyncField(value={"color"})
    public void setColor(Color color) {
        this.color = color;
        if (this.component != null) {
            ((Box)this.component).setForeground(color);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public Font getFont() {
        return this.font;
    }

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @INode.ServerSide
    public void performAction(ActionEvent e) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(e);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JRadioButton b = this.items.get(e.getActionCommand());
        if (b != null) {
            for (JRadioButton i : this.items.values()) {
                if (i == b) {
                    i.setSelected(true);
                    continue;
                }
                i.setSelected(false);
            }
        }
        this.performAction(e);
    }
}

