/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.simantics.message.IDetailStatus;
import org.simantics.message.ILogListener;

public class LogWriter
implements ILogListener {
    private final FrameworkLog frameworkLog;

    public LogWriter(FrameworkLog frameworkLog) {
        this.frameworkLog = frameworkLog;
    }

    @Override
    public synchronized void logging(IStatus status, String plugin) {
        this.frameworkLog.log(this.getLog(status));
    }

    protected FrameworkLogEntry getLog(IStatus status) {
        IStatus[] children;
        IStatus coreStatus;
        int stackCode;
        Throwable t = status.getException();
        ArrayList<FrameworkLogEntry> childlist = new ArrayList<FrameworkLogEntry>();
        int n = stackCode = t instanceof CoreException ? 1 : 0;
        if (stackCode == 1 && (coreStatus = ((CoreException)t).getStatus()) != null) {
            childlist.add(this.getLog(coreStatus));
        }
        if (status.isMultiStatus()) {
            children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                childlist.add(this.getLog(children[i]));
                ++i;
            }
        }
        children = childlist.size() == 0 ? null : childlist.toArray(new FrameworkLogEntry[childlist.size()]);
        Object message = status.getMessage();
        if (status instanceof IDetailStatus) {
            IDetailStatus ds = (IDetailStatus)status;
            message = (String)message + "\n!DETAILS " + ds.getDetailedDescription();
        }
        return new FrameworkLogEntry(status.getPlugin(), status.getSeverity(), status.getCode(), (String)message, stackCode, t, (FrameworkLogEntry[])children);
    }
}

