/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.message;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.simantics.message.IDetailStatus;

public class DetailMultiStatus
extends MultiStatus
implements IDetailStatus {
    private int severity;
    private String detailedDescription;

    public DetailMultiStatus(String pluginId, int code, IStatus[] newChildren, String message, Throwable exception) {
        super(pluginId, code, newChildren, message, exception);
        this.setDetailedDescription(null);
    }

    public DetailMultiStatus(String pluginId, int code, IStatus[] newChildren, String message, String detailedDescription, Throwable exception) {
        super(pluginId, code, newChildren, message, exception);
        this.setDetailedDescription(detailedDescription);
    }

    public DetailMultiStatus(String pluginId, int code, String message, Throwable exception) {
        super(pluginId, code, message, exception);
        this.setDetailedDescription(null);
    }

    public DetailMultiStatus(String pluginId, int code, String message, String detailedDescription, Throwable exception) {
        super(pluginId, code, message, exception);
        this.setDetailedDescription(detailedDescription);
    }

    protected void setSeverity(int severity) {
        Assert.isLegal((severity == 0 || severity == 4 || severity == 2 || severity == 1 || severity == 8 || severity == 16 ? 1 : 0) != 0);
        this.severity = severity;
    }

    public int getSeverity() {
        return this.severity;
    }

    @Override
    public String getDetailedDescription() {
        return this.detailedDescription;
    }

    public void setDetailedDescription(String detailedDescription) {
        this.detailedDescription = detailedDescription == null ? "" : detailedDescription;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Status2 ");
        if (this.severity == 0) {
            buf.append("OK");
        } else if (this.severity == 4) {
            buf.append("ERROR");
        } else if (this.severity == 2) {
            buf.append("WARNING");
        } else if (this.severity == 1) {
            buf.append("INFO");
        } else if (this.severity == 8) {
            buf.append("CANCEL");
        } else if (this.severity == 16) {
            buf.append("DEBUG");
        } else {
            buf.append("severity=");
            buf.append(this.severity);
        }
        buf.append(": ");
        buf.append(this.getPlugin());
        buf.append(" code=");
        buf.append(this.getCode());
        buf.append(' ');
        buf.append(this.getMessage());
        buf.append(' ');
        buf.append(this.getDetailedDescription());
        buf.append(' ');
        buf.append(this.getException());
        return buf.toString();
    }
}

