/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.indexing;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.Activator;
import org.simantics.db.indexing.internal.IndexChangedWriter;
import org.simantics.db.layer0.adapter.GenericRelationIndex;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.internal.SimanticsInternal;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.ServerInformation;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseIndexing {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseIndexing.class);

    public static Path getIndexBaseLocation() {
        return Activator.getDefault().getIndexBaseFile();
    }

    public static Path getIndexLocation(Session session, Resource relation, Resource input) {
        if (session == null) {
            throw new NullPointerException("null session");
        }
        if (relation == null) {
            throw new NullPointerException("null relation");
        }
        if (input == null) {
            throw new NullPointerException("null input");
        }
        String dir = ((ServerInformation)session.getService(ServerInformation.class)).getDatabaseId() + "." + relation.getResourceId() + "." + input.getResourceId();
        return DatabaseIndexing.getIndexBaseLocation().resolve(dir);
    }

    private static Path getAllDirtyFile() {
        return DatabaseIndexing.getIndexBaseLocation().resolve(".dirty");
    }

    private static Path getChangedFile(Path indexPath) {
        return indexPath.resolve(".changed");
    }

    public static void markAllDirty() throws IOException {
        Path allDirtyFile;
        Path indexBase = DatabaseIndexing.getIndexBaseLocation();
        if (!Files.exists(indexBase, new LinkOption[0]) || !Files.isDirectory(indexBase, new LinkOption[0])) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Marking all indexes dirty");
        }
        if (!Files.exists(allDirtyFile = DatabaseIndexing.getAllDirtyFile(), new LinkOption[0])) {
            Files.createFile(allDirtyFile, new FileAttribute[0]);
            FileUtils.sync((Path)allDirtyFile);
        }
    }

    public static void clearAllDirty() throws IOException {
        Path indexBase;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Clearing dirty state of all indexes");
        }
        if (!Files.exists(indexBase = DatabaseIndexing.getIndexBaseLocation(), new LinkOption[0]) || !Files.isDirectory(indexBase, new LinkOption[0])) {
            return;
        }
        DatabaseIndexing.forEachIndexPath(indexPath -> {
            Path p = DatabaseIndexing.getChangedFile(indexPath);
            try {
                FileUtils.delete((Path)p);
            }
            catch (IOException e) {
                LOGGER.error("Could not delete {}", (Object)p.toAbsolutePath(), (Object)e);
            }
        });
        FileUtils.delete((Path)DatabaseIndexing.getAllDirtyFile());
    }

    static void markIndexChanged(Session session, Path indexPath) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Marking index dirty: " + String.valueOf(indexPath));
        }
        Path changedFile = DatabaseIndexing.getChangedFile(indexPath);
        try {
            if (DatabaseIndexing.getIndexChangedWriter(session).markDirty(changedFile)) {
                Files.createDirectories(indexPath, new FileAttribute[0]);
                if (!Files.exists(changedFile, new LinkOption[0])) {
                    Files.createFile(changedFile, new FileAttribute[0]);
                    FileUtils.sync((Path)changedFile);
                } else if (!Files.isRegularFile(changedFile, new LinkOption[0])) {
                    throw new FileAlreadyExistsException(changedFile.toString(), null, "index dirtyness indicator file already exists but it is not a regular file");
                }
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Could not mark index changed for indexPath={} and changedFile={}", (Object)indexPath.toAbsolutePath(), (Object)changedFile.toAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static IndexChangedWriter getIndexChangedWriter(Session session) {
        IndexChangedWriter writer = (IndexChangedWriter)session.peekService(IndexChangedWriter.class);
        if (writer != null) return writer;
        Class<IndexChangedWriter> clazz = IndexChangedWriter.class;
        synchronized (IndexChangedWriter.class) {
            if (writer != null) return writer;
            writer = new IndexChangedWriter();
            session.registerService(IndexChangedWriter.class, (Object)writer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return writer;
        }
    }

    public static void deleteAllIndexes() throws IOException {
        Path indexBase = DatabaseIndexing.getIndexBaseLocation();
        ArrayList<Path> filter = new ArrayList<Path>(2);
        filter.add(DatabaseIndexing.getAllDirtyFile());
        filter.add(indexBase);
        FileUtils.deleteWithFilter((Path)indexBase, path -> !filter.contains(path));
        FileUtils.delete((Path)indexBase);
    }

    public static void deleteIndex(final Resource relation, final Resource modelPart) throws DatabaseException {
        SimanticsInternal.getSession().syncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                DatabaseIndexing.deleteIndex(graph, relation, modelPart);
            }
        });
    }

    public static void deleteIndex(WriteGraph graph, Resource relation, Resource modelPart) throws DatabaseException {
        Resource model = (Resource)graph.syncRequest((Read)new IndexRoot(modelPart));
        GenericRelationIndex index = (GenericRelationIndex)graph.adapt(relation, GenericRelationIndex.class);
        IndexedRelations ir = (IndexedRelations)graph.getService(IndexedRelations.class);
        ir.reset(null, (RequestProcessor)graph, relation, model);
        index.reset((RequestProcessor)graph, model);
    }

    public static void deleteIndex(Path indexPath) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Deleting index " + String.valueOf(indexPath.toAbsolutePath()));
        }
        ArrayList<Path> filter = new ArrayList<Path>(2);
        filter.add(DatabaseIndexing.getChangedFile(indexPath));
        filter.add(indexPath);
        FileUtils.deleteWithFilter((Path)indexPath, path -> !filter.contains(path));
        FileUtils.delete((Path)indexPath);
    }

    public static void validateIndexes() throws IOException {
        Path indexBase = DatabaseIndexing.getIndexBaseLocation();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Validating indexes at " + String.valueOf(indexBase));
        }
        if (!Files.exists(indexBase, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(indexBase, new LinkOption[0])) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.valueOf(indexBase) + " is not a directory! Removing it.");
            }
            FileUtils.emptyDirectory((Path)indexBase);
            Files.createDirectories(indexBase, new FileAttribute[0]);
            return;
        }
        Path allDirtyFile = DatabaseIndexing.getAllDirtyFile();
        if (Files.isRegularFile(allDirtyFile, new LinkOption[0])) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("All indexes marked dirty, removing them.");
            }
            DatabaseIndexing.deleteAllIndexes();
        } else {
            DatabaseIndexing.forEachIndexPath(indexPath -> {
                Path changed = DatabaseIndexing.getChangedFile(indexPath);
                if (Files.isRegularFile(changed, new LinkOption[0])) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Index is dirty, removing: " + String.valueOf(indexPath));
                    }
                    try {
                        DatabaseIndexing.deleteIndex(indexPath);
                    }
                    catch (IOException e) {
                        LOGGER.error("Could not delete index {}", (Object)indexPath.toAbsolutePath(), (Object)e);
                    }
                }
            });
        }
    }

    private static void forEachIndexPath(Consumer<Path> callback) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Stream<Path> paths = Files.walk(DatabaseIndexing.getIndexBaseLocation(), 1, new FileVisitOption[0]).filter(path -> Files.isDirectory(path, new LinkOption[0]));){
            Iterator iter = paths.iterator();
            while (iter.hasNext()) {
                Path p = (Path)iter.next();
                callback.accept(p);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

