/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.type;

import java.util.Set;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.ComponentReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.KeyReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.IdentityPair;

public class OptionalType
extends Datatype {
    public Datatype componentType;

    public OptionalType() {
    }

    public OptionalType(Datatype componentType) {
        this.componentType = componentType;
    }

    public Datatype getComponentType() {
        return this.componentType;
    }

    @Override
    public int getComponentCount() {
        return 1;
    }

    @Override
    public Datatype getComponentType(int index) {
        if (index != 0) {
            throw new IllegalArgumentException();
        }
        return this.componentType;
    }

    @Override
    public Datatype getComponentType(ChildReference path) {
        if (path == null) {
            return this;
        }
        if (path instanceof KeyReference) {
            throw new IllegalArgumentException("KeyReference is not supported in OptionalType");
        }
        if (path instanceof NameReference) {
            throw new IllegalArgumentException("NameReference is not supported in OptionalType");
        }
        if (path instanceof IndexReference && ((IndexReference)path).index != 0) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (path instanceof LabelReference && !((LabelReference)path).label.equals("v")) {
            throw new IllegalArgumentException("Unknown label");
        }
        return this.componentType.getComponentType(path.childReference);
    }

    @Override
    protected void collectSubtypes(Set<Datatype> subtypes, Set<Datatype> recursiveSubtypes) {
        this.componentType.collectSubtypes(subtypes, recursiveSubtypes);
    }

    @Override
    public int hashCode() {
        return this.componentType.hashCode() + this.metadataHashCode();
    }

    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof OptionalType)) {
            return false;
        }
        if (!this.hasEqualMetadata(obj)) {
            return false;
        }
        OptionalType other = (OptionalType)obj;
        return this.componentType.deepEquals(other.componentType, compareHistory);
    }

    @Override
    public void accept(Datatype.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Datatype.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public <T extends Datatype> T getChildType(ChildReference reference) throws ReferenceException {
        if (reference == null) {
            return (T)this;
        }
        if (reference instanceof LabelReference) {
            LabelReference lr = (LabelReference)reference;
            if (lr.label.equals("o")) {
                return this.componentType.getChildType(reference.getChildReference());
            }
        }
        if (reference instanceof ComponentReference) {
            return this.componentType.getChildType(reference.getChildReference());
        }
        throw new ReferenceException(String.valueOf(reference.getClass()) + " is not a reference of OptionalType");
    }
}

