/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;

public class ReferableRecordSerializer
extends Serializer.RecursiveSerializer {
    RecordBinding binding;
    public Serializer[] componentSerializers;
    Integer fixedSizeOfContent;
    int minContentSize;

    public ReferableRecordSerializer(RecordBinding binding, Serializer[] componentSerializers) {
        this.binding = binding;
        this.componentSerializers = componentSerializers;
    }

    @Override
    public void finalizeConstruction() {
        this.fixedSizeOfContent = null;
        Serializer[] serializerArray = this.componentSerializers;
        int n = this.componentSerializers.length;
        int n2 = 0;
        while (n2 < n) {
            Serializer componentSerializer = serializerArray[n2];
            this.minContentSize += componentSerializer.getMinSize();
            Integer componentFixedSize = componentSerializer.getConstantSize();
            if (componentFixedSize == null) {
                this.fixedSizeOfContent = null;
                break;
            }
            this.fixedSizeOfContent = this.fixedSizeOfContent == null ? componentFixedSize : this.fixedSizeOfContent + componentFixedSize;
            ++n2;
        }
    }

    boolean referable() {
        return this.binding.type().isReferable();
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        try {
            int id = in.readInt();
            if (id > 0) {
                return identities.get(id - 1);
            }
            Object result = this.binding.createPartial();
            identities.add(result);
            Object[] temp = new Object[this.componentSerializers.length];
            int i = 0;
            while (i < this.componentSerializers.length) {
                temp[i] = this.componentSerializers[i].deserialize(in, identities);
                ++i;
            }
            this.binding.setComponents(result, temp);
            return result;
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        try {
            int id = in.readInt();
            if (id > 0) {
                Object alreadyDeserializedObject = identities.get(id - 1);
                if (alreadyDeserializedObject != obj) {
                    int i = 0;
                    while (i < this.binding.getComponentCount()) {
                        Object component = this.binding.getComponent(alreadyDeserializedObject, i);
                        this.binding.setComponent(obj, i, component);
                        ++i;
                    }
                }
                return;
            }
            identities.add(obj);
            int i = 0;
            while (i < this.componentSerializers.length) {
                Serializer cs = this.componentSerializers[i];
                boolean csImmutable = this.binding.getComponentBinding(i).isImmutable();
                if (csImmutable) {
                    component = cs.deserialize(in, identities);
                    this.binding.setComponent(obj, i, component);
                } else {
                    component = this.binding.getComponent(obj, i);
                    component = cs.deserializeToTry(in, identities, component);
                    this.binding.setComponent(obj, i, component);
                }
                ++i;
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException, SerializationException {
        int id = in.readInt();
        if (id > 0) {
            return;
        }
        int i = 0;
        while (i < this.componentSerializers.length) {
            this.componentSerializers[i].skip(in, identities);
            ++i;
        }
    }

    @Override
    public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object obj) throws IOException {
        try {
            int id = identities.get(obj);
            if (id > 0) {
                out.writeInt(id);
            } else {
                out.writeInt(0);
                identities.put(obj, identities.size() + 1);
                int i = 0;
                while (i < this.componentSerializers.length) {
                    this.componentSerializers[i].serialize(out, identities, this.binding.getComponent(obj, i));
                    ++i;
                }
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return null;
    }

    @Override
    public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
        block5: {
            int id = identities.get(obj);
            if (id <= 0) break block5;
            return 4;
        }
        try {
            identities.put(obj, identities.size() + 1);
            if (this.fixedSizeOfContent != null) {
                return 4 + this.fixedSizeOfContent;
            }
            int result = 4;
            int i = 0;
            while (i < this.componentSerializers.length) {
                result += this.componentSerializers[i].getSize(this.binding.getComponent(obj, i), identities);
                ++i;
            }
            return result;
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMinSize() {
        return 4;
    }
}

