/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.RuntimeSerializerConstructionException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.serialization.SerializerScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConcurrentSerializerFactory
implements SerializerScheme {
    private Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private ConcurrentHashMap<Binding, CompletableFuture<Serializer>> repository = new ConcurrentHashMap();
    private ConcurrentHashMap<Binding, Serializer> inProgress = new ConcurrentHashMap();

    protected abstract Serializer doConstruct(Binding var1) throws SerializerConstructionException;

    protected Serializer construct(Binding request) throws SerializerConstructionException {
        if (request.cachedSerializer() != null) {
            return request.cachedSerializer();
        }
        this.repository.putIfAbsent(request, new CompletableFuture());
        Serializer binding = this.inProgress.get(request);
        if (binding == null) {
            binding = this.doConstruct(request);
            request.cacheSerializer(binding);
            CompletableFuture<Serializer> completableFuture = this.repository.get(request);
            completableFuture.complete(binding);
        }
        return binding;
    }

    protected void addInProgress(Binding request, Serializer serializer) {
        this.inProgress.put(request, serializer);
    }

    protected void finishInProgress(Binding request) {
        Serializer remove = this.inProgress.remove(request);
        request.cacheSerializer(remove);
        CompletableFuture<Serializer> existing = this.repository.get(request);
        if (existing != null) {
            existing.complete(remove);
        } else {
            this.LOGGER.warn("Finishing binding request {} for serializer {} without CompletableFuture!", (Object)request, (Object)remove);
        }
    }

    @Override
    public Serializer getSerializer(Binding binding) throws SerializerConstructionException {
        if (binding.cachedSerializer() != null) {
            return binding.cachedSerializer();
        }
        AtomicBoolean shouldConstruct = new AtomicBoolean(false);
        CompletableFuture completableFuture = this.repository.computeIfAbsent(binding, t -> {
            shouldConstruct.set(true);
            return new CompletableFuture();
        });
        if (shouldConstruct.get()) {
            this.construct(binding);
        }
        try {
            return (Serializer)completableFuture.get();
        }
        catch (Exception e) {
            throw new SerializerConstructionException(e);
        }
    }

    @Override
    public Serializer getSerializerUnchecked(Binding binding) throws RuntimeSerializerConstructionException {
        try {
            return this.getSerializer(binding);
        }
        catch (SerializerConstructionException e) {
            throw new RuntimeSerializerConstructionException(e);
        }
    }
}

