/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.parser.unparsing;

import java.util.List;
import org.simantics.databoard.parser.StringEscapeUtils;
import org.simantics.databoard.parser.ast.type.AstArrayType;
import org.simantics.databoard.parser.ast.type.AstAttribute;
import org.simantics.databoard.parser.ast.type.AstComponent;
import org.simantics.databoard.parser.ast.type.AstRecordType;
import org.simantics.databoard.parser.ast.type.AstTupleType;
import org.simantics.databoard.parser.ast.type.AstType;
import org.simantics.databoard.parser.ast.type.AstTypeDefinition;
import org.simantics.databoard.parser.ast.type.AstTypeReference;
import org.simantics.databoard.parser.ast.type.AstUnionType;
import org.simantics.databoard.parser.repository.DataTypeRepository;
import org.simantics.databoard.parser.unparsing.DataTypeToAst;
import org.simantics.databoard.type.Datatype;

public class DataTypePrinter {
    StringBuilder stringBuilder;
    int indentation = 0;
    boolean linefeed = true;
    DataTypeRepository repo;

    public DataTypePrinter(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    public DataTypeRepository getDataTypeRepository() {
        return this.repo;
    }

    public void setDataTypeRepository(DataTypeRepository repo) {
        this.repo = repo;
    }

    public StringBuilder getStringBuilder() {
        return this.stringBuilder;
    }

    public void setStringBuilder(StringBuilder stringBuilder) {
        this.stringBuilder = stringBuilder;
    }

    private void indent() {
        int i = 0;
        while (i < this.indentation) {
            this.stringBuilder.append("  ");
            ++i;
        }
    }

    public void setLinefeed(boolean linefeed) {
        this.linefeed = linefeed;
    }

    public void visit(AstTypeDefinition definition) {
        this.indent();
        this.stringBuilder.append("type ");
        this.stringBuilder.append(definition.name);
        this.stringBuilder.append(" = ");
        this.visit(definition.type);
        this.stringBuilder.append("\n");
    }

    public void visit(AstType type) {
        Class<?> clazz = type.getClass();
        if (clazz == AstArrayType.class) {
            this.visit((AstArrayType)type);
        } else if (clazz == AstRecordType.class) {
            this.visit((AstRecordType)type);
        } else if (clazz == AstTupleType.class) {
            this.visit((AstTupleType)type);
        } else if (clazz == AstTypeReference.class) {
            this.visit((AstTypeReference)type);
        } else if (clazz == AstUnionType.class) {
            this.visit((AstUnionType)type);
        } else {
            throw new AssertionError((Object)"Unhandled abstract syntax tree node type.");
        }
    }

    public void visit(AstArrayType type) {
        this.visit(type.componentType);
        if (type.minLength == null) {
            if (type.maxLength == null) {
                this.stringBuilder.append("[]");
            } else {
                this.stringBuilder.append("[..");
                this.stringBuilder.append(type.maxLength);
                this.stringBuilder.append(']');
            }
        } else if (type.maxLength == null) {
            this.stringBuilder.append('[');
            this.stringBuilder.append(type.minLength);
            this.stringBuilder.append("..]");
        } else {
            this.stringBuilder.append('[');
            if (type.minLength.equals(type.maxLength)) {
                this.stringBuilder.append(type.minLength);
            } else {
                this.stringBuilder.append(type.minLength);
                this.stringBuilder.append("..");
                this.stringBuilder.append(type.maxLength);
            }
            this.stringBuilder.append(']');
        }
    }

    public void visit(AstAttribute attribute) {
        this.stringBuilder.append(attribute.key);
        this.stringBuilder.append("=\"");
        this.stringBuilder.append(StringEscapeUtils.escape(attribute.value));
        this.stringBuilder.append('\"');
    }

    public void visit(AstComponent component) {
        this.stringBuilder.append(component.name);
        this.stringBuilder.append(" : ");
        this.visit(component.type);
    }

    public void visit(AstRecordType type) {
        if (type.referable) {
            this.stringBuilder.append("referable ");
        }
        if (type.components.isEmpty()) {
            this.stringBuilder.append("{}");
        } else {
            this.stringBuilder.append('{');
            if (this.linefeed) {
                this.stringBuilder.append('\n');
            }
            this.indentation += 2;
            int i = 0;
            while (i < type.components.size()) {
                if (this.linefeed) {
                    this.indent();
                }
                this.visit(type.components.get(i));
                if (i < type.components.size() - 1) {
                    this.stringBuilder.append(',');
                }
                if (this.linefeed) {
                    this.stringBuilder.append('\n');
                }
                ++i;
            }
            this.indentation -= 2;
            if (this.linefeed) {
                this.indent();
            }
            this.stringBuilder.append('}');
        }
    }

    public void visit(AstTupleType type) {
        this.stringBuilder.append('(');
        int i = 0;
        while (i < type.components.size()) {
            if (i > 0) {
                this.stringBuilder.append(", ");
            }
            this.visit(type.components.get(i));
            ++i;
        }
        this.stringBuilder.append(')');
    }

    public void visit(AstTypeReference type) {
        this.stringBuilder.append(type.name);
        if (!type.parameters.isEmpty() || !type.attributes.isEmpty()) {
            this.stringBuilder.append('(');
            boolean first = true;
            for (AstType parameter : type.parameters) {
                if (first) {
                    first = false;
                } else {
                    this.stringBuilder.append(", ");
                }
                this.visit(parameter);
            }
            for (AstAttribute attribute : type.attributes) {
                if (first) {
                    first = false;
                } else {
                    this.stringBuilder.append(", ");
                }
                this.visit(attribute);
            }
            this.stringBuilder.append(')');
        }
    }

    public void visit(AstUnionType type) {
        if (type.components.size() == 1) {
            this.stringBuilder.append("| ");
            this.stringBuilder.append(type.components.get((int)0).name);
            this.stringBuilder.append(' ');
            this.visit(type.components.get((int)0).type);
        } else {
            ++this.indentation;
            for (AstComponent component : type.components) {
                if (this.linefeed) {
                    this.stringBuilder.append('\n');
                }
                this.indent();
                this.stringBuilder.append("| ");
                this.stringBuilder.append(component.name);
                this.stringBuilder.append(' ');
                ++this.indentation;
                this.visit(component.type);
                --this.indentation;
            }
        }
        --this.indentation;
    }

    public void print(Datatype type) {
        DataTypeToAst converter = new DataTypeToAst(new DataTypeRepository());
        AstType astType = converter.visit(type);
        this.visit(astType);
    }

    public void printDefinitions(Datatype type) {
        DataTypeToAst converter = new DataTypeToAst(new DataTypeRepository());
        this.visit(converter.visit(type));
        List<AstTypeDefinition> definitions = converter.getTypeDefinitions();
        for (AstTypeDefinition def : definitions) {
            this.visit(def);
        }
    }

    public String toString() {
        return this.stringBuilder.toString();
    }

    public static String toString(Datatype dataType, boolean linefeed) {
        DataTypePrinter printer = new DataTypePrinter(new StringBuilder());
        printer.setLinefeed(linefeed);
        printer.print(dataType);
        return printer.toString();
    }
}

