/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.Set;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.adapter.AdapterFactory;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.classfactory.TypeClassFactory;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.factory.BindingRepository;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;

public class BeanBinding
extends VariantBinding {
    ClassBindingFactory bindingFactory;
    AdapterFactory adapterFactory;
    TypeClassFactory typeClassFactory;

    public BeanBinding(ClassBindingFactory bindingFactory, TypeClassFactory typeClassFactory, AdapterFactory adapterFactory) {
        this.bindingFactory = bindingFactory;
        this.adapterFactory = adapterFactory;
        this.typeClassFactory = typeClassFactory;
    }

    public ClassBindingFactory getBindingFactory() {
        return this.bindingFactory;
    }

    public BindingRepository getRepository() {
        return this.bindingFactory.getRepository();
    }

    @Override
    public Object create(Binding srcBinding, Object value) throws BindingException {
        try {
            BindingRequest request = this.typeClassFactory.getClass(srcBinding.type());
            Binding dstBinding = this.bindingFactory.getBinding(request);
            return this.adapterFactory.adapt(value, srcBinding, dstBinding);
        }
        catch (BindingConstructionException e) {
            throw new BindingException(e);
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Binding getContentBinding(Object variant) throws BindingException {
        Bean bean = (Bean)variant;
        return bean.getBinding();
    }

    @Override
    public Datatype getContentType(Object variant) throws BindingException {
        Bean bean = (Bean)variant;
        return bean.getBinding().type();
    }

    @Override
    public Object getContent(Object variant, Binding binding) throws BindingException {
        try {
            if (!(binding instanceof RecordBinding)) {
                throw new BindingException("Cannot assign " + String.valueOf(binding.getClass()) + " to bean.");
            }
            RecordBinding dstBinding = (RecordBinding)binding;
            Bean src = (Bean)variant;
            RecordBinding srcBinding = src.getBinding();
            return this.adapterFactory.adapt(src, srcBinding, dstBinding);
        }
        catch (AdaptException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Object getContent(Object variant) throws BindingException {
        return variant;
    }

    @Override
    public void setContent(Object variant, Binding binding, Object src) throws BindingException {
        if (variant == src) {
            return;
        }
        if (!(binding instanceof RecordBinding)) {
            throw new BindingException("Cannot assign " + String.valueOf(binding.getClass()) + " to bean.");
        }
        RecordBinding srcBinding = (RecordBinding)binding;
        Bean dst = (Bean)variant;
        RecordBinding dstBinding = dst.getBinding();
        dstBinding.readFrom(srcBinding, src, dst);
    }

    @Override
    public void assertInstaceIsValid(Object obj, Set<Object> validInstances) throws BindingException {
        Bean bean = (Bean)obj;
        bean.getBinding().assertInstaceIsValid(bean, validInstances);
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Bean;
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    protected boolean baseEquals(Object obj) {
        BeanBinding o = (BeanBinding)obj;
        return super.baseEquals(obj) && o.adapterFactory == this.adapterFactory && o.bindingFactory == this.bindingFactory && o.typeClassFactory == this.typeClassFactory;
    }

    @Override
    public int baseHashCode() {
        return super.baseHashCode() + 7 * this.adapterFactory.hashCode() + 13 * this.bindingFactory.hashCode() + 17 * this.typeClassFactory.hashCode();
    }
}

