/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.factory;

import java.util.HashMap;
import java.util.Map;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.reflection.BindingRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(BindingRepository.class);
    Map<BindingRequest, Binding> requestMap;
    Map<Class<?>, Binding> classMap;

    public BindingRepository() {
        this.requestMap = new HashMap<BindingRequest, Binding>();
        this.classMap = new HashMap();
    }

    public BindingRepository(Map<BindingRequest, Binding> requests) {
        this.requestMap = requests;
        for (Map.Entry<BindingRequest, Binding> e : requests.entrySet()) {
            if (!this.isClassRequest(e.getKey())) continue;
            this.registerClassMapping(e.getKey().getClazz(), e.getValue());
        }
    }

    public synchronized Binding get(Class<?> clazz) {
        return this.classMap.get(clazz);
    }

    public synchronized Binding get(BindingRequest request) {
        return this.requestMap.get(request);
    }

    public synchronized void put(BindingRequest request, Binding binding) {
        Binding existing;
        if (this.isClassRequest(request)) {
            this.registerClassMapping(request.getClazz(), binding);
        }
        if ((existing = this.requestMap.put(request, binding)) != null && !existing.equals(binding)) {
            LOGGER.error("Replacing existing binding with a different one! {} {} {}", new Object[]{request, binding, existing});
        }
    }

    public synchronized void remove(Binding binding) {
        for (Map.Entry<BindingRequest, Binding> entry : this.requestMap.entrySet()) {
            if (entry.getValue() != binding) continue;
            this.requestMap.remove(entry.getValue());
            break;
        }
        for (Map.Entry<Object, Binding> entry : this.classMap.entrySet()) {
            if (entry.getValue() != binding) continue;
            this.classMap.remove(entry.getValue());
            break;
        }
    }

    public synchronized boolean containsRequest(BindingRequest request) {
        return this.requestMap.containsKey(request);
    }

    public synchronized boolean containsClass(Class<?> clazz) {
        return this.classMap.containsKey(clazz);
    }

    public synchronized void clear() {
        this.requestMap.clear();
        this.classMap.clear();
    }

    boolean isClassRequest(BindingRequest request) {
        return request.className != null && (request.annotations == null || request.annotations.length == 0);
    }

    public void registerClassMapping(Class<?> clazz, Binding binding) {
        Binding previous = this.classMap.putIfAbsent(clazz, binding);
        if (previous != null && !previous.equals(binding)) {
            LOGGER.warn("WARN: Can not put same key again to classMap! {} mapping {} not replaced by {} (datatypes: {} vs. {})", new Object[]{clazz, previous, binding, previous.type(), binding != null ? binding.type() : "null", new Exception("trace")});
        }
    }
}

