/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.IndexReference;
import org.simantics.databoard.accessor.reference.NameReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ClassificationsRequest;
import org.simantics.db.layer0.request.HasEnumerationRange;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.utils.datastructures.Pair;

public final class PropertyInfoRequest
extends ResourceRead<PropertyInfo> {
    private static int classHash = 31 * PropertyInfo.class.hashCode();

    public PropertyInfoRequest(Resource resource) {
        super(resource);
    }

    public PropertyInfo perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
        boolean isHasProperty = graph.isSubrelationOf(this.resource, L0.HasProperty);
        String name = (String)graph.getPossibleRelatedValue(this.resource, L0.HasName, (Binding)Bindings.STRING);
        if (name != null) {
            name = name.intern();
        }
        boolean isFunctional = graph.isInstanceOf(this.resource, L0.FunctionalRelation);
        Set classifications = (Set)graph.sync((ReadInterface)new ClassificationsRequest(graph.getPrincipalTypes(this.resource)));
        VariableBuilder variableBuilder = (VariableBuilder)graph.getPossibleAdapter(this.resource, VariableBuilder.class);
        Datatype requiredDataType = (Datatype)graph.getPossibleRelatedValue(this.resource, L0X.RequiresDataType, Bindings.DATATYPE);
        String definedUnit = (String)graph.getPossibleRelatedValue(this.resource, L0X.HasUnit, (Binding)Bindings.STRING);
        Resource literalRange = graph.getPossibleObject(this.resource, L0.HasRange);
        String requiredValueType = (String)graph.getPossibleRelatedValue(this.resource, L0.RequiresValueType, (Binding)Bindings.STRING);
        ValueAccessor accessor = (ValueAccessor)graph.getPossibleRelatedValue2(this.resource, Layer0.getInstance((ReadGraph)graph).valueAccessor, (Object)this.resource);
        boolean hasEnumerationRange = (Boolean)graph.syncRequest((Read)new HasEnumerationRange(this.resource));
        Collection ranges = graph.getObjects(this.resource, L0.HasRange);
        if (!ranges.isEmpty()) {
            for (Resource range : ranges) {
                Collection subliterals;
                Collection valueTypes;
                if (requiredValueType == null && (valueTypes = graph.getAssertedObjects(range, L0.HasValueType)).size() > 0) {
                    for (Resource valueType : valueTypes) {
                        String vt = (String)graph.getPossibleValue(valueType, (Binding)Bindings.STRING);
                        if (vt == null || vt.isEmpty()) continue;
                        requiredValueType = vt;
                    }
                }
                if ((subliterals = graph.getObjects(range, L0.HasSubliteralPredicate)).isEmpty()) continue;
                THashMap map = new THashMap();
                for (Resource p : subliterals) {
                    NameReference r;
                    String pN = (String)graph.getPossibleRelatedValue(p, L0.HasName, (Binding)Bindings.STRING);
                    if (pN == null) continue;
                    if (pN.startsWith("n-")) {
                        r = new NameReference(pN.substring(2));
                        map.put(pN, Pair.make((Object)p, (Object)r));
                        continue;
                    }
                    if (!pN.startsWith("i-")) continue;
                    r = new IndexReference(Integer.parseInt(pN.substring(2)));
                    map.put(pN, Pair.make((Object)p, (Object)r));
                }
                return PropertyInfo.make(graph, this.resource, name, isFunctional, isHasProperty, classifications, variableBuilder, literalRange, requiredDataType, definedUnit, requiredValueType, (Map<String, Pair<Resource, ChildReference>>)map, accessor, hasEnumerationRange);
            }
        }
        return PropertyInfo.make(graph, this.resource, name, isFunctional, isHasProperty, classifications, variableBuilder, literalRange, requiredDataType, definedUnit, requiredValueType, Collections.emptyMap(), accessor, hasEnumerationRange);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof PropertyInfoRequest)) {
            return false;
        }
        PropertyInfoRequest r = (PropertyInfoRequest)((Object)object);
        return r.resource.equals(this.resource);
    }

    public int hashCode() {
        return this.resource.hashCode() + classHash;
    }
}

