/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.IsEnumeratedType;
import org.simantics.db.request.PersistentRead;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class HasEnumerationRange
extends ResourceRead<Boolean>
implements PersistentRead<Boolean> {
    private static final byte ONE = 1;
    private static final QueryFactoryKey queryFactoryKey = new QueryFactoryKey("org.simantics.db.layer0", HasEnumerationRange.class.getName());

    public HasEnumerationRange(Resource resource) {
        super(resource);
    }

    public Boolean perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource range : graph.getObjects(this.resource, L0.HasRange)) {
            boolean enu = (Boolean)graph.syncRequest((Read)new IsEnumeratedType(range));
            if (!enu) continue;
            return true;
        }
        return false;
    }

    public void serializeValue(QuerySerializer serializer, Boolean value) {
        serializer.addByte(value != false ? (byte)1 : 0);
    }

    public QueryFactoryKey classId() {
        return queryFactoryKey;
    }
}

