/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.export;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.osgi.service.prefs.Preferences;
import org.simantics.NameLabelUtil;
import org.simantics.databoard.Accessors;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.BooleanAccessor;
import org.simantics.databoard.accessor.RecordAccessor;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.accessor.reference.LabelReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.util.URIUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleObjectWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.ExportClass;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.utils.strings.AlphanumComparator;

public abstract class ExperimentExportClass
implements ExportClass {
    public static ChildReference P_EXPERIMENT = new LabelReference("Experiment");
    public static ChildReference P_EXPERIMENT_START = ChildReference.parsePath((String)"Experiment/Start Time");
    public static ChildReference P_EXPERIMENT_END = ChildReference.parsePath((String)"Experiment/End Time");

    public RecordType options(ExportContext context, Collection<String> content) throws ExportException {
        DoubleType second = new DoubleType("s");
        RecordType experimentOptions = new RecordType();
        experimentOptions.addComponent("Start Time", (Datatype)second);
        experimentOptions.addComponent("End Time", (Datatype)second);
        try {
            List models = (List)context.session.syncRequest(ExportQueries.toModels(content));
            for (Resource model : models) {
                List runs = (List)context.session.syncRequest(ExperimentExportClass.getExperimentRuns(model));
                String modelLabel = (String)context.session.syncRequest(ExportQueries.label((Resource)model));
                if (modelLabel == null) continue;
                ArrayList<String> runLabels = new ArrayList<String>();
                for (Resource run : runs) {
                    String runLabel = (String)context.session.syncRequest(ExperimentExportClass.getRunLabel(run));
                    if (runLabel == null) continue;
                    runLabels.add(runLabel);
                }
                Collections.sort(runLabels, AlphanumComparator.CASE_INSENSITIVE_COMPARATOR);
                RecordType modelRunSelection = new RecordType();
                modelRunSelection.metadata.put("style", "dialog");
                for (String runLabel : runLabels) {
                    modelRunSelection.addComponent(runLabel, (Datatype)Datatypes.BOOLEAN);
                }
                experimentOptions.addComponent(modelLabel + ", experiment runs", (Datatype)modelRunSelection);
            }
        }
        catch (DatabaseException e) {
            throw new ExportException((Throwable)e);
        }
        RecordType options = new RecordType();
        options.addComponent("Experiment", (Datatype)experimentOptions);
        return options;
    }

    public void fillDefaultPrefs(ExportContext ctx, Variant options) throws ExportException {
        RecordAccessor ra;
        try {
            ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            ra.setValue(P_EXPERIMENT_END, (Binding)Bindings.DOUBLE, (Object)86400.0);
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
        try {
            ra = Accessors.getAccessor((Variant)options);
            ra = ra.getComponent(P_EXPERIMENT);
            for (ModelRef modelRef : ExperimentExportClass.getResult(ctx, options, false)) {
                for (ExperimentRef experimentRef : modelRef.experiments) {
                    for (RunRef runRef : experimentRef.runs) {
                        if (!runRef.isActive) continue;
                        try {
                            BooleanAccessor ba = (BooleanAccessor)ra.getComponent(runRef.optionsRef);
                            ba.setValue(true);
                        }
                        catch (AccessorConstructionException accessorConstructionException) {}
                    }
                }
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
        catch (DatabaseException e1) {
            throw new ExportException((Throwable)e1);
        }
    }

    public void savePref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        try {
            Double endTime;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            Double startTime = (Double)ra.getValue(P_EXPERIMENT_START, (Binding)Bindings.DOUBLE);
            if (startTime != null) {
                contentScopeNode.putDouble(P_EXPERIMENT_START.tail().toString(), startTime.doubleValue());
            }
            if ((endTime = (Double)ra.getValue(P_EXPERIMENT_END, (Binding)Bindings.DOUBLE)) != null) {
                contentScopeNode.putDouble(P_EXPERIMENT_END.tail().toString(), endTime.doubleValue());
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public void loadPref(Variant options, Preferences contentScopeNode, Preferences workbenchScopeNode) throws ExportException {
        try {
            double endTime;
            RecordAccessor ra = (RecordAccessor)Accessors.getAccessor((Variant)options);
            double startTime = contentScopeNode.getDouble(P_EXPERIMENT_START.tail().toString(), -1.7976931348623157E308);
            if (startTime != -1.7976931348623157E308) {
                ra.setValue(P_EXPERIMENT_START, (Binding)Bindings.DOUBLE, (Object)startTime);
            }
            if ((endTime = contentScopeNode.getDouble(P_EXPERIMENT_END.tail().toString(), -1.7976931348623157E308)) != -1.7976931348623157E308) {
                ra.setValue(P_EXPERIMENT_END, (Binding)Bindings.DOUBLE, (Object)endTime);
            }
        }
        catch (AccessorConstructionException e) {
            throw new ExportException((Throwable)e);
        }
        catch (AccessorException e) {
            throw new ExportException((Throwable)e);
        }
    }

    public static Read<List<Resource>> getExperimentRuns(final Resource model) {
        return new Read<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> result = new ArrayList<Resource>();
                Layer0 b = Layer0.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                for (Resource config : graph.getObjects(model, b.ConsistsOf)) {
                    if (!graph.isInstanceOf(config, SIMU.Experiment)) continue;
                    for (Resource run : graph.getObjects(config, b.ConsistsOf)) {
                        if (!graph.isInstanceOf(run, SIMU.Run)) continue;
                        result.add(run);
                    }
                }
                return result;
            }
        };
    }

    public static Read<String> getRunLabel(final Resource run) {
        return new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                Resource experiment = (Resource)graph.syncRequest((Read)new PossibleObjectWithType(run, L0.PartOf, SIMU.Experiment));
                if (experiment == null) {
                    return null;
                }
                String experimentLabel = NameLabelUtil.modalName((ReadGraph)graph, (Resource)experiment);
                String runLabel = NameLabelUtil.modalName((ReadGraph)graph, (Resource)run);
                if (experimentLabel == null || runLabel == null) {
                    return null;
                }
                return experimentLabel + "\\" + runLabel;
            }
        };
    }

    public static Read<Resource> getRunByLabel(final Resource model, final String runLabel) {
        return new Read<Resource>(){

            public Resource perform(ReadGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                for (Resource config : graph.getObjects(model, L0.ConsistsOf)) {
                    String experimentLabel;
                    if (!graph.isInstanceOf(config, SIMU.Experiment) || (experimentLabel = NameLabelUtil.modalName((ReadGraph)graph, (Resource)config)) == null || !runLabel.startsWith(experimentLabel)) continue;
                    for (Resource run : graph.getObjects(config, L0.ConsistsOf)) {
                        String lbl2;
                        if (!graph.isInstanceOf(run, SIMU.Run) || (lbl2 = NameLabelUtil.modalName((ReadGraph)graph, (Resource)run)) == null || !runLabel.equals(experimentLabel + "\\" + lbl2)) continue;
                        return run;
                    }
                }
                return null;
            }
        };
    }

    public static Read<List<Resource>> getChildByLabelAndType(final Resource subject, final Resource type, final String label) {
        return new Read<List<Resource>>(){

            public List<Resource> perform(ReadGraph graph) throws DatabaseException {
                ArrayList<Resource> result = new ArrayList<Resource>();
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                for (Resource child : graph.getObjects(subject, L0.ConsistsOf)) {
                    String lbl;
                    if (!graph.isInstanceOf(child, type) || (lbl = NameLabelUtil.modalName((ReadGraph)graph, (Resource)child)) == null || !lbl.equals(label)) continue;
                    result.add(child);
                }
                return result;
            }
        };
    }

    public static List<ModelRef> getResult(final ExportContext ctx, final Variant options, final boolean returnOnlyEnabledInOptions) throws DatabaseException {
        return (List)ctx.session.syncRequest((Read)new Read<List<ModelRef>>(){

            public List<ModelRef> perform(ReadGraph graph) throws DatabaseException {
                try {
                    ArrayList<ModelRef> result = new ArrayList<ModelRef>();
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                    Resource project = graph.getResource(ctx.project);
                    Accessor ra = Accessors.getAccessor((Variant)options);
                    ra = ra.getComponent(P_EXPERIMENT);
                    RecordType type = (RecordType)((RecordType)options.type()).getComponentType("Experiment");
                    if (type != null) {
                        Component[] componentArray = type.getComponents();
                        int n = componentArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String modelName;
                            Component c = componentArray[n2];
                            int endIndex = c.name.length() - ", experiment runs".length();
                            if (endIndex > 0 && !(modelName = c.name.substring(0, endIndex)).isEmpty()) {
                                List models = (List)graph.syncRequest(ExperimentExportClass.getChildByLabelAndType(project, SIMU.Model, modelName));
                                for (Resource model : models) {
                                    ModelRef modelRef = new ModelRef();
                                    modelRef.resource = model;
                                    modelRef.label = modelName;
                                    modelRef.uri = graph.getURI(model);
                                    if (!(c.type instanceof RecordType)) continue;
                                    RecordType rt = (RecordType)c.type;
                                    Component[] componentArray2 = rt.getComponents();
                                    int n3 = componentArray2.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        Component cc = componentArray2[n4];
                                        String pp = cc.name;
                                        String[] parts = pp.split("\\\\");
                                        if (parts.length == 2) {
                                            String experimentLabel = parts[0];
                                            String runLabel = parts[1];
                                            for (Resource experiment : (List)graph.syncRequest(ExperimentExportClass.getChildByLabelAndType(model, SIMU.Experiment, experimentLabel))) {
                                                ExperimentRef experimentRef = new ExperimentRef();
                                                experimentRef.resource = experiment;
                                                experimentRef.label = experimentLabel;
                                                experimentRef.uri = graph.getURI(experiment);
                                                for (Resource run : (List)graph.syncRequest(ExperimentExportClass.getChildByLabelAndType(experiment, SIMU.Run, runLabel))) {
                                                    RunRef runRef;
                                                    block13: {
                                                        runRef = new RunRef();
                                                        runRef.optionsRef = new LabelReference(c.name, (ChildReference)new LabelReference(experimentLabel + "\\" + runLabel));
                                                        try {
                                                            BooleanAccessor ba = (BooleanAccessor)ra.getComponent(runRef.optionsRef);
                                                            runRef.isEnabled = ba.getValue();
                                                            if (!runRef.isEnabled && returnOnlyEnabledInOptions) {
                                                            }
                                                            break block13;
                                                        }
                                                        catch (AccessorException accessorException) {
                                                            if (!returnOnlyEnabledInOptions) break block13;
                                                        }
                                                        continue;
                                                    }
                                                    runRef.resource = run;
                                                    runRef.label = runLabel;
                                                    runRef.uri = graph.getURI(run);
                                                    runRef.isActive = graph.hasStatement(run, SIMU.IsActive);
                                                    runRef.identifier = (String)graph.getRelatedValue(run, L0.HasName, (Binding)Bindings.STRING);
                                                    runRef.historyFolder = ExperimentExportClass.getExperimentDirectory(modelRef.resource, experimentRef.resource, "result-" + runRef.identifier);
                                                    experimentRef.runs.add(runRef);
                                                }
                                                if (experimentRef.runs.isEmpty()) continue;
                                                modelRef.experiments.add(experimentRef);
                                            }
                                        }
                                        ++n4;
                                    }
                                    if (modelRef.experiments.isEmpty()) continue;
                                    result.add(modelRef);
                                }
                            }
                            ++n2;
                        }
                    }
                    return result;
                }
                catch (AccessorConstructionException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    public static ModelRef getModelRefByResource(List<ModelRef> modelRefs, Resource model) {
        for (ModelRef modelRef : modelRefs) {
            if (!modelRef.resource.equals(model)) continue;
            return modelRef;
        }
        return null;
    }

    public static File getExperimentDirectory(Resource model, Resource experiment, String ... subdirs) throws DatabaseException {
        String[] dirs = new String[4 + subdirs.length];
        dirs[0] = "resources";
        dirs[1] = "model-" + model.getResourceId();
        dirs[2] = "experiments";
        dirs[3] = "" + experiment.getResourceId();
        System.arraycopy(subdirs, 0, dirs, 4, subdirs.length);
        return ExperimentExportClass.getWorkspacePath(false, dirs);
    }

    public static File getWorkspacePath(boolean escapeNames, String ... relativeSegments) {
        IPath finalPath = Platform.getLocation();
        int i = 0;
        while (i < relativeSegments.length) {
            finalPath = finalPath.append(escapeNames ? URIUtil.encodeFilename((String)relativeSegments[i]) : relativeSegments[i]);
            ++i;
        }
        return finalPath.toFile();
    }

    public static File getWorkspacePath() {
        return ExperimentExportClass.getWorkspacePath(false, new String[0]);
    }

    public static class ExperimentRef {
        public String uri;
        public Resource resource;
        public String label;
        public List<RunRef> runs = new ArrayList<RunRef>();

        public int enabledRunCount() {
            int count = 0;
            for (RunRef rr : this.runs) {
                if (!rr.isEnabled) continue;
                ++count;
            }
            return count;
        }
    }

    public static class ModelRef {
        public String uri;
        public Resource resource;
        public String label;
        public List<ExperimentRef> experiments = new ArrayList<ExperimentRef>();

        public int runCount() {
            int count = 0;
            for (ExperimentRef er : this.experiments) {
                count += er.runs.size();
            }
            return count;
        }

        public int enabledRunCount() {
            int count = 0;
            for (ExperimentRef er : this.experiments) {
                count += er.enabledRunCount();
            }
            return count;
        }

        public List<RunRef> getRunRefs() {
            ArrayList<RunRef> result = new ArrayList<RunRef>();
            for (ExperimentRef er : this.experiments) {
                result.addAll(er.runs);
            }
            return result;
        }
    }

    public static class RunRef {
        public String uri;
        public Resource resource;
        public String label;
        public ChildReference optionsRef;
        public boolean isActive;
        public boolean isEnabled;
        public File historyFolder;
        public String identifier;
    }
}

