/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.experiment;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.progress.IProgressConstants2;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleActiveExperiment;
import org.simantics.db.layer0.request.PossibleActiveRun;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.layer0.Layer0;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.model.IModel;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;

public final class ExperimentUtil {
    public static void refreshExperiment(ReadGraph graph, IExperiment experiment) {
        experiment.refresh((RequestProcessor)graph);
    }

    public static void stepExperiment(IExperiment experiment, double duration) {
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulateDuration(duration);
        }
    }

    public static void simulateExperiment(IExperiment experiment, boolean enabled) {
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulate(enabled);
        }
    }

    public static ExperimentState getExperimentState(ReadGraph graph, IExperiment experiment) throws DatabaseException {
        return experiment.getState(graph);
    }

    public static void disposeExperiment(final IExperiment experiment) {
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).shutdown(null);
            Session session = Simantics.getSession();
            VirtualGraphSupport vgs = (VirtualGraphSupport)session.getService(VirtualGraphSupport.class);
            session.asyncRequest((Write)new WriteRequest(vgs.getMemoryPersistent("experiments")){

                public void perform(WriteGraph graph) throws DatabaseException {
                    SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
                    Resource activeRun = experiment.getResource();
                    graph.deny(activeRun, SIMU.IsActive, activeRun);
                }
            });
        }
    }

    public static void step(double duration) {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulateDuration(duration);
        }
    }

    public static boolean canStepUntil(double endTime) {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            IDynamicExperiment exp = (IDynamicExperiment)experiment;
            double currentTime = exp.getSimulationTime();
            return currentTime < endTime;
        }
        return false;
    }

    public static void stepUntil(double endTime) {
        IDynamicExperiment exp;
        double currentTime;
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment && (currentTime = (exp = (IDynamicExperiment)experiment).getSimulationTime()) < endTime) {
            exp.simulateDuration(endTime - currentTime);
        }
    }

    public static void simulate(boolean enabled) {
        IExperimentManager manager = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulate(enabled);
        }
    }

    public static void shutdownActiveExperiment(IProject project) {
        ExperimentUtil.shutdownActiveExperiment(project, null);
    }

    public static void shutdownActiveExperiment(IProject project, IProgressMonitor monitor) {
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null) {
            experiment.shutdown(monitor);
        }
    }

    public static void scheduleShutdownActiveExperiment(IProject project) {
        ExperimentUtil.scheduleShutdownActiveExperiment(project, null);
    }

    public static void scheduleShutdownActiveExperiment(IProject project, final Consumer<IExperiment> callback) {
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        final IExperiment experiment = manager.getActiveExperiment();
        if (experiment != null) {
            DatabaseJob job = new DatabaseJob("Shutting down experiment"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        experiment.shutdown(monitor);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    finally {
                        monitor.done();
                        if (callback != null) {
                            callback.accept(null);
                        }
                    }
                }
            };
            job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, (Object)Boolean.TRUE);
            job.setUser(true);
            job.schedule();
        } else if (callback != null) {
            callback.accept(null);
        }
    }

    public static Variable possibleActiveRunVariable(ReadGraph graph, Resource model) throws DatabaseException {
        return (Variable)graph.syncRequest((Read)new PossibleActiveRun(model));
    }

    public static Resource activateExperiment(RequestProcessor processor, final Resource experiment, Procedure<Resource> asyncCallback) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)processor.getService(VirtualGraphSupport.class);
        WriteResultRequest<Resource> w = new WriteResultRequest<Resource>(vgs.getMemoryPersistent("experiments")){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                return ExperimentUtil.activateExperiment(graph, experiment);
            }
        };
        if (processor instanceof WriteGraph) {
            return (Resource)((WriteGraph)processor).syncRequest((WriteResult)w);
        }
        if (asyncCallback == null) {
            asyncCallback = new ProcedureAdapter();
        }
        processor.getSession().asyncRequest((WriteResult)w, (Procedure)asyncCallback);
        return null;
    }

    public static void activateRun(RequestProcessor processor, final Resource run) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)processor.getService(VirtualGraphSupport.class);
        WriteRequest w = new WriteRequest(vgs.getMemoryPersistent("experiments")){

            public void perform(WriteGraph graph) throws DatabaseException {
                ExperimentUtil.activateRun(graph, run);
            }
        };
        if (processor instanceof WriteGraph) {
            ((WriteGraph)processor).syncRequest((Write)w);
        } else {
            processor.getSession().asyncRequest((Write)w);
        }
    }

    public static Resource activateExperiment(WriteGraph graph, final Resource experiment) throws DatabaseException {
        VirtualGraphSupport vgs = (VirtualGraphSupport)graph.getService(VirtualGraphSupport.class);
        return (Resource)graph.syncRequest((WriteResult)new WriteResultRequest<Resource>(vgs.getMemoryPersistent("experiments")){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                return ExperimentUtil.createExperimentRun(graph, experiment, true);
            }
        });
    }

    public static Resource createExperimentRun(WriteGraph graph, Resource experiment) throws DatabaseException {
        return ExperimentUtil.createExperimentRun(graph, experiment, true);
    }

    public static Resource createExperimentRun(WriteGraph graph, Resource experiment, boolean activate) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource experimentType = graph.getPossibleType(experiment, SIMU.Experiment);
        if (experimentType == null) {
            throw new DatabaseException("No unique experiment type was found for experiment " + graph.getPossibleURI(experiment));
        }
        Collection runTypes = (Collection)graph.sync((ReadInterface)new ObjectsWithType(experimentType, L0.ConsistsOf, SIMU.RunType));
        if (runTypes.size() != 1) {
            throw new DatabaseException("No unique run type was found for experiment " + graph.getPossibleURI(experiment));
        }
        Resource runType = (Resource)runTypes.iterator().next();
        return ExperimentUtil.createExperimentRunWithType(graph, experiment, runType, activate);
    }

    public static Resource createExperimentRunWithType(WriteGraph graph, Resource experiment, Resource runType) throws DatabaseException {
        return ExperimentUtil.createExperimentRunWithType(graph, experiment, runType, true);
    }

    public static Resource createExperimentRunWithType(WriteGraph graph, Resource experiment, Resource runType, boolean activate) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource run = graph.newResource();
        graph.claim(run, L0.InstanceOf, runType);
        graph.addLiteral(run, L0.HasName, L0.NameOf, L0.String, (Object)UUID.randomUUID().toString(), (Binding)Bindings.STRING);
        graph.claim(experiment, L0.ConsistsOf, run);
        if (activate) {
            ExperimentUtil.activateRun(graph, run);
        }
        return run;
    }

    public static void activateRun(WriteGraph graph, Resource run) throws DatabaseException {
        SimulationResource SIMU = SimulationResource.getInstance((ReadGraph)graph);
        Resource activeRun = (Resource)graph.syncRequest((Read)new PossibleActiveExperiment(run));
        if (activeRun != null) {
            graph.deny(activeRun, SIMU.IsActive, activeRun);
        }
        graph.claim(run, SIMU.IsActive, run);
    }

    public static IModel getIModel(ReadGraph graph, Resource experimentResource) throws DatabaseException {
        IModel result = (IModel)graph.getPossibleUniqueAdapter(experimentResource, IModel.class);
        if (result != null) {
            return result;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return (IModel)graph.adaptUnique(graph.getSingleObject(experimentResource, L0.PartOf), IModel.class);
    }
}

