/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural2.modelingRules;

import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.AbstractModelingRules;
import org.simantics.structural2.modelingRules.AllowedConnectionTypes;
import org.simantics.structural2.modelingRules.CPConnection;
import org.simantics.structural2.modelingRules.CPConnectionJoin;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.ConnectionJudgement;
import org.simantics.structural2.modelingRules.ConnectionJudgementType;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IConnectionConstraint;
import org.simantics.structural2.modelingRules.IConnectionPoint;
import org.simantics.structural2.modelingRules.Policy;
import org.simantics.structural2.modelingRules.StandardAttachmentRelationMap;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.utils.strings.AlphanumComparator;

public class StandardModelingRules
extends AbstractModelingRules {
    Layer0 L0;
    StructuralResource2 STR;

    public StandardModelingRules(ReadGraph g) {
        this.L0 = Layer0.getInstance((ReadGraph)g);
        this.STR = StructuralResource2.getInstance((ReadGraph)g);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected ConnectionJudgement judgeConnection(ReadGraph g, Collection<IConnectionPoint> connectionPoints, boolean allowExisting) throws DatabaseException {
        ConnectionJudgement judgement;
        if (connectionPoints.isEmpty()) {
            ConnectionJudgement judgement2 = new ConnectionJudgement(ConnectionJudgementType.LEGAL);
            judgement2.attachmentRelations = StandardAttachmentRelationMap.INSTANCE;
            return judgement2;
        }
        if (!allowExisting) {
            for (IConnectionPoint cp : connectionPoints) {
                if (!(cp instanceof CPTerminal)) continue;
                CPTerminal terminal = (CPTerminal)cp;
                if (!g.isInstanceOf(terminal.relation, this.L0.FunctionalRelation) || terminal.component == null) continue;
                if (g.hasStatement(terminal.component, terminal.relation)) {
                    if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                        System.out.println(terminal.toString(g) + " failed FunctionalRelation test -> ILLEGAL");
                    }
                    return ConnectionJudgement.ILLEGAL;
                }
                for (Resource eqRelation : g.getObjects(terminal.relation, this.STR.ConnectionRelation_equivalentConnectionPoint)) {
                    if (!g.hasStatement(terminal.component, eqRelation)) continue;
                    if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                        System.out.println(terminal.toString(g) + " failed FunctionalRelation test of equivalent connection point -> ILLEGAL");
                    }
                    return ConnectionJudgement.ILLEGAL;
                }
            }
        }
        Set<CPTerminal> terminals = this.resolveTerminals(g, connectionPoints);
        Resource defaultConnectionType = null;
        boolean singleDefaultConnectionType = false;
        ArrayList<Set<Resource>> typeSets = new ArrayList<Set<Resource>>();
        for (CPTerminal terminal : terminals) {
            if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                System.out.println(String.valueOf(this) + ": allowed connection types determination: " + terminal.toString(g) + " " + String.valueOf(terminal.relation));
            }
            Collection allowedConnectionTypes = (Collection)g.syncRequest((Read)new AllowedConnectionTypes(terminal.relation));
            if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                for (Resource type : allowedConnectionTypes) {
                    System.out.println("\tallowedConnectionType: " + NameUtils.getSafeName((ReadGraph)g, (Resource)type, (boolean)true));
                }
            }
            typeSets.add((Set<Resource>)new THashSet(allowedConnectionTypes));
            Resource defaultsTo = g.getPossibleObject(terminal.relation, this.STR.DefaultsToConnectionType);
            if (defaultsTo == null) continue;
            if (defaultConnectionType == null) {
                defaultConnectionType = defaultsTo;
                singleDefaultConnectionType = true;
                continue;
            }
            if (defaultsTo.equals(defaultConnectionType)) continue;
            singleDefaultConnectionType = false;
        }
        Collection<Resource> connectionTypes = this.getAllowedConnectionTypes(g, typeSets);
        if (connectionTypes == null) {
            if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                System.out.println("No connection types -> CANBEMADELEGAL");
            }
            ConnectionJudgement judgement3 = new ConnectionJudgement(ConnectionJudgementType.CANBEMADELEGAL);
            judgement3.attachmentRelations = StandardAttachmentRelationMap.INSTANCE;
            return judgement3;
        }
        Resource possibleConnectionType = null;
        Resource chosenConnectionType = null;
        String chosenConnectionTypeName = null;
        block9: for (Resource connectionType : connectionTypes) {
            if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                System.out.println("Check constraints for " + NameUtils.getSafeName((ReadGraph)g, (Resource)connectionType));
            }
            switch (this.evaluateConstraints(g, connectionType, terminals)) {
                case ILLEGAL: {
                    break;
                }
                case CANBEMADELEGAL: {
                    possibleConnectionType = connectionType;
                    break;
                }
                case LEGAL: {
                    if (chosenConnectionType != null) {
                        String connectionTypeName;
                        if (singleDefaultConnectionType) {
                            chosenConnectionType = defaultConnectionType;
                            break block9;
                        }
                        if (chosenConnectionTypeName == null) {
                            chosenConnectionTypeName = NameUtils.getSafeName((ReadGraph)g, (Resource)chosenConnectionType);
                        }
                        if (AlphanumComparator.COMPARATOR.compare((Object)chosenConnectionTypeName, (Object)(connectionTypeName = NameUtils.getSafeName((ReadGraph)g, (Resource)connectionType))) <= 0) break;
                        chosenConnectionType = connectionType;
                        chosenConnectionTypeName = connectionTypeName;
                        break;
                    }
                    chosenConnectionType = connectionType;
                }
            }
        }
        if (chosenConnectionType != null) {
            judgement = new ConnectionJudgement(chosenConnectionType);
            judgement.attachmentRelations = StandardAttachmentRelationMap.INSTANCE;
            return judgement;
        }
        if (possibleConnectionType != null) {
            judgement = new ConnectionJudgement(ConnectionJudgementType.CANBEMADELEGAL, possibleConnectionType);
            judgement.attachmentRelations = StandardAttachmentRelationMap.INSTANCE;
            return judgement;
        }
        return ConnectionJudgement.ILLEGAL;
    }

    protected Collection<Resource> getAllowedConnectionTypes(ReadGraph graph, Collection<Set<Resource>> typeSets) throws DatabaseException {
        THashSet all = new THashSet();
        for (Set<Resource> s : typeSets) {
            all.addAll(s);
        }
        for (Resource r : all) {
            for (Resource inc : graph.getObjects(r, this.STR.IsIncludedInConnectionType)) {
                for (Set<Resource> s : typeSets) {
                    if (!s.contains(inc)) continue;
                    s.add(r);
                }
            }
        }
        ArrayList<Resource> connectionTypes = null;
        for (Set<Resource> allowedConnectionTypes : typeSets) {
            if (allowedConnectionTypes.isEmpty()) continue;
            if (connectionTypes == null) {
                connectionTypes = new ArrayList<Resource>(allowedConnectionTypes);
                continue;
            }
            connectionTypes.retainAll(allowedConnectionTypes);
        }
        return connectionTypes;
    }

    protected ConnectionJudgementType evaluateConstraints(ReadGraph g, Resource connectionType, Set<CPTerminal> terminals) throws DatabaseException {
        boolean legal = true;
        for (Resource constraint : g.getObjects(connectionType, this.STR.HasConnectionConstraint)) {
            IConnectionConstraint cc = (IConnectionConstraint)g.adapt(constraint, IConnectionConstraint.class);
            if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                System.out.println("Checking " + cc.getClass().getSimpleName());
            }
            switch (cc.isLegal(g, terminals)) {
                case ILLEGAL: {
                    if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                        System.out.println("    " + cc.getClass().getSimpleName() + " -> ILLEGAL");
                    }
                    return ConnectionJudgementType.ILLEGAL;
                }
                case CANBEMADELEGAL: {
                    if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                        System.out.println("    " + cc.getClass().getSimpleName() + " -> CANBEMADELEGAL");
                    }
                    legal = false;
                }
            }
        }
        return legal ? ConnectionJudgementType.LEGAL : ConnectionJudgementType.CANBEMADELEGAL;
    }

    @Override
    public ConnectionJudgement judgeConnection(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        return this.judgeConnection(g, connectionPoints, false);
    }

    @Override
    public Resource computeConnectionType(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        return this.judgeConnection((ReadGraph)g, connectionPoints, (boolean)true).connectionType;
    }

    @Override
    public IAttachmentRelationMap getAttachmentRelations(ReadGraph g, Resource connection) {
        return StandardAttachmentRelationMap.INSTANCE;
    }

    @Override
    public Set<CPTerminal> resolveTerminals(ReadGraph g, Collection<IConnectionPoint> connectionPoints) throws DatabaseException {
        THashSet terminals = new THashSet();
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)g);
        for (IConnectionPoint cp : connectionPoints) {
            if (Policy.DEBUG_STANDARD_MODELING_RULES) {
                System.out.println(String.valueOf(this) + ": translate connection point: " + cp.toString(g));
            }
            if (cp instanceof CPTerminal) {
                terminals.add((CPTerminal)cp);
                continue;
            }
            if (cp instanceof CPConnection) {
                CPConnection connection = (CPConnection)cp;
                for (Resource c : StructuralUtils.getRelatedConnections((RequestProcessor)g, connection.connection)) {
                    for (Statement stat : g.getStatements(c, STR.Connects)) {
                        terminals.add(new CPTerminal(stat.getObject(), g.getInverse(stat.getPredicate())));
                    }
                    Resource inf = g.getPossibleObject(c, STR.Binds);
                    if (inf == null) continue;
                    terminals.add(new CPTerminal(inf, inf));
                }
                continue;
            }
            if (cp instanceof CPConnectionJoin) {
                CPConnectionJoin connectionJoin = (CPConnectionJoin)cp;
                for (Resource c : StructuralUtils.getRelatedConnectionsOfConnectionJoin((RequestProcessor)g, connectionJoin.connectionJoin)) {
                    for (Statement stat : g.getStatements(c, STR.Connects)) {
                        terminals.add(new CPTerminal(stat.getObject(), g.getInverse(stat.getPredicate())));
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("Connection point " + String.valueOf(cp) + " encountered.");
        }
        return terminals;
    }
}

