/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history.util.subscription;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.Bean;
import org.simantics.history.util.subscription.SamplingFormat;

public class SubscriptionItem
extends Bean {
    private static final Binding BINDING = Bindings.getBindingUnchecked(SubscriptionItem.class);
    @Identifier
    public String id;
    public String variableId;
    public Datatype format;
    public double deadband = Double.NaN;
    public double interval = Double.NaN;
    public double gain = 1.0;
    public double bias = 0.0;
    public boolean enabled = true;
    public String groupId = "";
    public String groupItemId = "";
    public String formatId = "";

    public SubscriptionItem() {
        super(BINDING);
    }

    public SubscriptionItem(Binding binding) {
        super(binding);
    }

    public static SubscriptionItem[] createItems(SubscriptionItem item, String groupItemId, String groupId, Collection<SamplingFormat> formats) {
        Iterator<SamplingFormat> itr = formats.iterator();
        SubscriptionItem[] items = new SubscriptionItem[formats.size()];
        int i = 0;
        while (i < formats.size()) {
            items[i] = SubscriptionItem.createItem(item, groupItemId, groupId, itr.next());
            ++i;
        }
        return items;
    }

    public static SubscriptionItem[] createItems(String variableId, String subscriptionId, SamplingFormat ... formats) {
        SubscriptionItem[] items = new SubscriptionItem[formats.length];
        int i = 0;
        while (i < formats.length) {
            items[i] = SubscriptionItem.createItem(variableId, subscriptionId, formats[i]);
            ++i;
        }
        return items;
    }

    public static SubscriptionItem[] createItems(String groupItemId, String groupId, Collection<SamplingFormat> formats) {
        Iterator<SamplingFormat> itr = formats.iterator();
        SubscriptionItem[] items = new SubscriptionItem[formats.size()];
        int i = 0;
        while (i < formats.size()) {
            items[i] = SubscriptionItem.createItem(groupItemId, groupId, itr.next());
            ++i;
        }
        return items;
    }

    public static SubscriptionItem createItem(SubscriptionItem item, String groupItemId, String groupId, SamplingFormat format) {
        SubscriptionItem hi = new SubscriptionItem();
        hi.variableId = item.variableId;
        hi.groupItemId = item.groupItemId;
        hi.id = SubscriptionItem.composeItemName(groupId, groupItemId, format.formatId);
        hi.deadband = format.deadband;
        hi.interval = format.interval;
        hi.gain = item.gain;
        hi.bias = item.bias;
        hi.formatId = format.formatId;
        hi.format = format.format;
        hi.groupId = item.groupId;
        hi.enabled = item.enabled;
        return hi;
    }

    public static SubscriptionItem createItem(String groupItemId, String groupId, SamplingFormat format) {
        SubscriptionItem hi = new SubscriptionItem();
        hi.variableId = groupItemId;
        hi.groupItemId = groupItemId;
        hi.id = SubscriptionItem.composeItemName(groupId, groupItemId, format.formatId);
        hi.deadband = format.deadband;
        hi.interval = format.interval;
        hi.formatId = format.formatId;
        hi.format = format.format;
        hi.groupId = groupId;
        hi.enabled = true;
        return hi;
    }

    public static String composeItemName(String groupId, String groupItemId, String formatId) {
        return groupId + " " + groupItemId + " " + formatId;
    }
}

