/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.acorn;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.simantics.acorn.AcornKey;
import org.simantics.acorn.AcornKeyRocks;
import org.simantics.acorn.MainState;
import org.simantics.acorn.Store;
import org.simantics.db.IO;

public class RocksStore
implements Store {
    private Path dbPath;
    private RocksDB db;

    public RocksStore(Path root) throws IOException {
        this.dbPath = root.resolve("rocks");
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Options options = new Options();){
                options.setCreateIfMissing(true);
                this.db = RocksDB.open((Options)options, (String)this.dbPath.toAbsolutePath().toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (RocksDBException e) {
            throw new IOException(e);
        }
    }

    public RocksDB db() {
        return this.db;
    }

    public IO getIO(AcornKey key) {
        return null;
    }

    public void dispose() {
    }

    @Override
    public AcornKey rootKey(String name) {
        return new AcornKeyRocks(this, null, name);
    }

    @Override
    public Stream<AcornKey> directories() throws IOException {
        ArrayList<AcornKey> result = new ArrayList<AcornKey>();
        RocksIterator it = this.db.newIterator();
        String prefix = "$";
        it.seek(prefix.getBytes());
        while (it.isValid()) {
            String key = new String(it.key());
            if (!key.startsWith(prefix)) break;
            result.add(this.rootKey(key.substring(1)));
            it.next();
        }
        return result.stream();
    }

    @Override
    public void tryPurgeDirectory(AcornKey f, MainState mainState) {
    }

    @Override
    public void ensureExists() throws IOException {
    }

    public String toString() {
        return "store:rocks:" + String.valueOf(this.dbPath);
    }
}

