/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.simantics.utils.ui.color.ColorGradient;
import org.simantics.utils.ui.color.ColorGradientCanvas;
import org.simantics.utils.ui.color.ColorValue;

public class ColorGradientAdjustingCanvas
extends ColorGradientCanvas
implements ISelectionProvider {
    ColorValue[] values;
    int last;
    int[] coords;
    int size = 8;
    int sized2 = 4;
    int width;
    int height;
    int selectedValueIndex = -1;
    double min;
    double max;
    private ISelection selection = new StructuredSelection();
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();

    public ColorGradientAdjustingCanvas(Composite parent, int style) {
        super(parent, style | 0x20000000 | 0x40000);
        this.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                int prev = ColorGradientAdjustingCanvas.this.selectedValueIndex;
                ColorGradientAdjustingCanvas.this.selectedValueIndex = -1;
                int d = Integer.MAX_VALUE;
                int i = 0;
                while (i <= ColorGradientAdjustingCanvas.this.last) {
                    int dd;
                    int x = ColorGradientAdjustingCanvas.this.coords[i * 2];
                    int y = ColorGradientAdjustingCanvas.this.coords[i * 2 + 1];
                    int dx = Math.abs(x - e.x);
                    int dy = Math.abs(y - e.y);
                    if (dx < ColorGradientAdjustingCanvas.this.size && dy < ColorGradientAdjustingCanvas.this.size && (dd = dx + dy) < d) {
                        ColorGradientAdjustingCanvas.this.selectedValueIndex = i;
                        d = dd;
                    }
                    ++i;
                }
                if (prev != ColorGradientAdjustingCanvas.this.selectedValueIndex) {
                    ColorGradientAdjustingCanvas.this.updateSelection();
                    ColorGradientAdjustingCanvas.this.redraw();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        if ((style & 8) == 0) {
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if ((e.stateMask & 0x80000) > 0 && ColorGradientAdjustingCanvas.this.selectedValueIndex > 0 && ColorGradientAdjustingCanvas.this.selectedValueIndex < ColorGradientAdjustingCanvas.this.last) {
                        double d = (ColorGradientAdjustingCanvas.this.style | 0x100) > 0 ? (double)e.x / (double)ColorGradientAdjustingCanvas.this.width : (double)e.y / (double)ColorGradientAdjustingCanvas.this.height;
                        double r = ColorGradientAdjustingCanvas.this.max - ColorGradientAdjustingCanvas.this.min;
                        d *= r;
                        d += ColorGradientAdjustingCanvas.this.min;
                        double offset = r * 0.015;
                        if (d <= ColorGradientAdjustingCanvas.this.values[ColorGradientAdjustingCanvas.this.selectedValueIndex - 1].getValue() + offset) {
                            d = ColorGradientAdjustingCanvas.this.values[ColorGradientAdjustingCanvas.this.selectedValueIndex - 1].getValue() + offset;
                        } else if (d >= ColorGradientAdjustingCanvas.this.values[ColorGradientAdjustingCanvas.this.selectedValueIndex + 1].getValue() - offset) {
                            d = ColorGradientAdjustingCanvas.this.values[ColorGradientAdjustingCanvas.this.selectedValueIndex + 1].getValue() - offset;
                        }
                        ColorGradientAdjustingCanvas.this.values[ColorGradientAdjustingCanvas.this.selectedValueIndex]._setValue(d);
                        ColorGradientAdjustingCanvas.this.calculateCoords(ColorGradientAdjustingCanvas.this.width, ColorGradientAdjustingCanvas.this.height);
                        ColorGradientAdjustingCanvas.this.redraw();
                    }
                }
            });
        }
    }

    @Override
    public void setGradient(ColorGradient gradient) {
        int prevSize = 0;
        if (this.values != null) {
            prevSize = this.values.length;
        }
        this.values = gradient.getColorValueArray();
        this.last = this.values.length - 1;
        this.coords = new int[this.values.length * 2];
        super.setGradient(gradient);
        if (this.selectedValueIndex >= 0 && prevSize != this.values.length) {
            this.selectedValueIndex = -1;
            this.updateSelection();
        } else {
            this.updateSelection();
        }
    }

    private void calculateCoords(int width, int height) {
        this.width = width;
        this.height = height;
        this.min = this.values[0].getValue();
        this.max = this.values[this.last].getValue();
        if ((this.style & 0x100) > 0) {
            int i = 0;
            while (i <= this.last) {
                int x;
                int y = height / 2;
                double d = this.values[i].getValue();
                this.coords[i * 2] = x = (int)((d - this.min) / (this.max - this.min) * (double)width);
                this.coords[i * 2 + 1] = y;
                ++i;
            }
        } else {
            int i = 0;
            while (i <= this.last) {
                int x = width / 2;
                double d = this.values[i].getValue();
                int y = (int)((d - this.min) / (this.max - this.min) * (double)height);
                this.coords[i * 2] = x;
                this.coords[i * 2 + 1] = y;
                ++i;
            }
        }
    }

    @Override
    protected void paintGradient(GC gc, Rectangle clip) {
        if (this.values != null && this.values.length > 0) {
            Image image = this.gradient.getGradientImage(clip.width, clip.height, this.style);
            gc.drawImage(image, 0, 0);
            image.dispose();
            this.calculateCoords(clip.width, clip.height);
            Color white = new Color(gc.getDevice(), 255, 255, 255);
            Color yellow = new Color(gc.getDevice(), 255, 230, 0);
            Color black = new Color(gc.getDevice(), 0, 0, 0);
            int i = 0;
            while (i <= this.last) {
                int x = this.coords[i * 2];
                int y = this.coords[i * 2 + 1];
                gc.setForeground(black);
                if (this.selectedValueIndex == i) {
                    gc.setBackground(yellow);
                } else {
                    gc.setBackground(white);
                }
                if (i == 0 || i == this.last) {
                    gc.fillRectangle(x - this.sized2, y - this.sized2, this.size, this.size);
                    gc.drawRectangle(x - this.sized2, y - this.sized2, this.size, this.size);
                } else {
                    gc.fillOval(x - this.sized2, y - this.sized2, this.size, this.size);
                    gc.drawOval(x - this.sized2, y - this.sized2, this.size, this.size);
                }
                ++i;
            }
            white.dispose();
            black.dispose();
            yellow.dispose();
        } else {
            gc.setBackground(Display.getCurrent().getSystemColor(1));
            gc.fillRectangle(clip);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        ColorValue value = (ColorValue)((StructuredSelection)selection).getFirstElement();
        this.selectedValueIndex = this.gradient.getColorValues().indexOf(value);
    }

    private void updateSelection() {
        this.selection = this.selectedValueIndex < 0 ? new StructuredSelection() : new StructuredSelection((Object)this.values[this.selectedValueIndex]);
        for (ISelectionChangedListener l : this.listeners) {
            l.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.selection));
        }
    }

    public int getPointSize() {
        return this.size;
    }

    public void setPointSize(int size) {
        this.size = size;
        this.sized2 = size / 2;
    }
}

