/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.color;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.simantics.utils.ui.color.Color;
import org.simantics.utils.ui.color.ColorGradient;
import org.simantics.utils.ui.color.ColorGradientCanvas;
import org.simantics.utils.ui.color.ColorValue;

public class ColorComposite
extends Composite {
    private Color color;
    private ColorGradient rGradient;
    private ColorGradient gGradient;
    private ColorGradient bGradient;
    private ColorGradient hGradient;
    private ColorGradient sGradient;
    private ColorGradient vGradient;
    private ColorGradient colorGradient;
    TabFolder tabFolder;
    Text rText;
    Text gText;
    Text bText;
    IntGradientWidget rCanvas;
    IntGradientWidget gCanvas;
    IntGradientWidget bCanvas;
    ColorGradientCanvas colorCanvas;
    Text hText;
    Text sText;
    Text vText;
    GradientWidget hCanvas;
    GradientWidget sCanvas;
    GradientWidget vCanvas;
    Button dynamicButton;
    boolean dynamic = true;
    private boolean internalUpdate = false;

    public ColorComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        this.colorCanvas = new ColorGradientCanvas(this, 2304);
        this.tabFolder = new TabFolder((Composite)this, 0);
        TabItem rgbTab = new TabItem(this.tabFolder, 0);
        rgbTab.setText("RGB");
        Composite rgbComposite = new Composite((Composite)this.tabFolder, 0);
        rgbTab.setControl((Control)rgbComposite);
        Label rLabel = new Label(rgbComposite, 0);
        rLabel.setText("Red");
        this.rCanvas = new IntGradientWidget(rgbComposite, 2304){

            @Override
            protected void updatePosition(int value) {
                Color newColor = new Color(value, ColorComposite.this.color.getG(), ColorComposite.this.color.getB());
                ColorComposite.this.setColor(newColor);
            }
        };
        this.rText = new Text(rgbComposite, 2048);
        this.rText.addModifyListener((ModifyListener)new IntColorModifyListener(this){

            @Override
            void setValue(int value) {
                Color newColor = new Color(value, color.getG(), color.getB());
                this.setColor(newColor);
            }
        });
        Label gLabel = new Label(rgbComposite, 0);
        gLabel.setText("Green");
        this.gCanvas = new IntGradientWidget(rgbComposite, 2304){

            @Override
            protected void updatePosition(int value) {
                Color newColor = new Color(ColorComposite.this.color.getR(), value, ColorComposite.this.color.getB());
                ColorComposite.this.setColor(newColor);
            }
        };
        this.gText = new Text(rgbComposite, 2048);
        this.gText.addModifyListener((ModifyListener)new IntColorModifyListener(this){

            @Override
            void setValue(int value) {
                Color newColor = new Color(color.getR(), value, color.getB());
                this.setColor(newColor);
            }
        });
        Label bLabel = new Label(rgbComposite, 0);
        bLabel.setText("Blue");
        this.bCanvas = new IntGradientWidget(rgbComposite, 2304){

            @Override
            protected void updatePosition(int value) {
                Color newColor = new Color(ColorComposite.this.color.getR(), ColorComposite.this.color.getG(), value);
                ColorComposite.this.setColor(newColor);
            }
        };
        this.bText = new Text(rgbComposite, 2048);
        this.bText.addModifyListener((ModifyListener)new IntColorModifyListener(this){

            @Override
            void setValue(int value) {
                Color newColor = new Color(color.getR(), color.getG(), value);
                this.setColor(newColor);
            }
        });
        TabItem hsvTab = new TabItem(this.tabFolder, 0);
        hsvTab.setText("HSV");
        Composite hsvComposite = new Composite((Composite)this.tabFolder, 0);
        hsvTab.setControl((Control)hsvComposite);
        Label hLabel = new Label(hsvComposite, 0);
        hLabel.setText("Hue");
        this.hCanvas = new GradientWidget(hsvComposite, 2304){

            @Override
            protected boolean updatePosition(double d) {
                Color newColor = new Color(d * 360.0, (double)ColorComposite.this.color.getS(), (double)ColorComposite.this.color.getV());
                ColorComposite.this.setColor(newColor);
                return true;
            }

            @Override
            protected void setPosition(double d) {
                super.setPosition(d / 360.0);
            }
        };
        this.hText = new Text(hsvComposite, 2048);
        this.hText.addModifyListener((ModifyListener)new DoubleColorModifyListener(this, 0.0, 360.0){

            @Override
            void setValue(double value) {
                Color newColor = new Color(value, (double)color.getS(), (double)color.getV());
                this.setColor(newColor);
            }
        });
        Label sLabel = new Label(hsvComposite, 0);
        sLabel.setText("Saturation");
        this.sCanvas = new GradientWidget(hsvComposite, 2304){

            @Override
            protected boolean updatePosition(double d) {
                Color newColor = new Color((double)ColorComposite.this.color.getH(), d, (double)ColorComposite.this.color.getV());
                ColorComposite.this.setColor(newColor);
                return true;
            }
        };
        this.sText = new Text(hsvComposite, 2048);
        this.sText.addModifyListener((ModifyListener)new DoubleColorModifyListener(this, 0.0, 1.0){

            @Override
            void setValue(double value) {
                Color newColor = new Color((double)color.getH(), value, (double)color.getV());
                this.setColor(newColor);
            }
        });
        Label vLabel = new Label(hsvComposite, 0);
        vLabel.setText("Value");
        this.vCanvas = new GradientWidget(hsvComposite, 2304){

            @Override
            protected boolean updatePosition(double d) {
                Color newColor = new Color((double)ColorComposite.this.color.getH(), (double)ColorComposite.this.color.getS(), d);
                ColorComposite.this.setColor(newColor);
                return true;
            }
        };
        this.vText = new Text(hsvComposite, 2048);
        this.vText.addModifyListener((ModifyListener)new DoubleColorModifyListener(this, 0.0, 1.0){

            @Override
            void setValue(double value) {
                Color newColor = new Color((double)color.getH(), (double)color.getS(), value);
                this.setColor(newColor);
            }
        });
        TabItem settingsTab = new TabItem(this.tabFolder, 0);
        settingsTab.setText("Settings");
        Composite settingsComposite = new Composite((Composite)this.tabFolder, 0);
        settingsTab.setControl((Control)settingsComposite);
        this.dynamicButton = new Button(settingsComposite, 32);
        this.dynamicButton.setText("Dynamic widgets");
        this.dynamicButton.setSelection(this.dynamic);
        this.dynamicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorComposite.this.dynamic = ColorComposite.this.dynamicButton.getSelection();
                ColorComposite.this.updateWidgets();
            }
        });
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(rgbComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(hsvComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(settingsComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)rgbComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)hsvComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)settingsComposite);
        GridDataFactory.fillDefaults().grab(true, false).align(4, 128).applyTo((Control)this.tabFolder);
        GridDataFactory.fillDefaults().hint(-1, 32).grab(true, false).align(4, 128).applyTo((Control)this.colorCanvas);
        GridDataFactory.fillDefaults().hint(-1, 16).grab(true, true).align(4, 4).applyTo((Control)this.rCanvas);
        GridDataFactory.fillDefaults().hint(-1, 16).grab(true, true).align(4, 4).applyTo((Control)this.gCanvas);
        GridDataFactory.fillDefaults().hint(-1, 16).grab(true, true).align(4, 4).applyTo((Control)this.bCanvas);
        GridDataFactory.fillDefaults().hint(-1, 16).grab(true, true).align(4, 4).applyTo((Control)this.hCanvas);
        GridDataFactory.fillDefaults().hint(-1, 16).grab(true, true).align(4, 4).applyTo((Control)this.sCanvas);
        GridDataFactory.fillDefaults().hint(-1, 16).grab(true, true).align(4, 4).applyTo((Control)this.vCanvas);
        GridDataFactory.fillDefaults().hint(30, 16).grab(false, false).applyTo((Control)this.rText);
        GridDataFactory.fillDefaults().hint(30, 16).grab(false, false).applyTo((Control)this.gText);
        GridDataFactory.fillDefaults().hint(30, 16).grab(false, false).applyTo((Control)this.bText);
        GridDataFactory.fillDefaults().hint(30, 16).grab(false, false).applyTo((Control)this.hText);
        GridDataFactory.fillDefaults().hint(30, 16).grab(false, false).applyTo((Control)this.sText);
        GridDataFactory.fillDefaults().hint(30, 16).grab(false, false).applyTo((Control)this.vText);
        if (this.color == null) {
            this.setColor(new Color(255, 255, 255));
        } else {
            this.setColor(this.color);
        }
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateWidgets();
    }

    public Color getColor() {
        return this.color;
    }

    private void updateGradients() {
        if (this.dynamic) {
            this.rGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(0, this.color.getG(), this.color.getB()), 0.0), new ColorValue(new Color(255, this.color.getG(), this.color.getB()), 1.0)});
            this.gGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(this.color.getR(), 0, this.color.getB()), 0.0), new ColorValue(new Color(this.color.getR(), 255, this.color.getB()), 1.0)});
            this.bGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(this.color.getR(), this.color.getG(), 0), 0.0), new ColorValue(new Color(this.color.getR(), this.color.getG(), 255), 1.0)});
            this.hGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(0.0, (double)this.color.getS(), (double)this.color.getV()), 0.0), new ColorValue(new Color(90.0, (double)this.color.getS(), (double)this.color.getV()), 0.25), new ColorValue(new Color(180.0, (double)this.color.getS(), (double)this.color.getV()), 0.5), new ColorValue(new Color(270.0, (double)this.color.getS(), (double)this.color.getV()), 0.75), new ColorValue(new Color(360.0, (double)this.color.getS(), (double)this.color.getV()), 1.0)}, 1);
            this.sGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color((double)this.color.getH(), 0.0, (double)this.color.getV()), 0.0), new ColorValue(new Color((double)this.color.getH(), 1.0, (double)this.color.getV()), 1.0)}, 1);
            this.vGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color((double)this.color.getH(), (double)this.color.getS(), 0.0), 0.0), new ColorValue(new Color((double)this.color.getH(), (double)this.color.getS(), 1.0), 1.0)}, 1);
        } else {
            this.rGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(0, 0, 0), 0.0), new ColorValue(new Color(255, 0, 0), 1.0)});
            this.gGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(0, 0, 0), 0.0), new ColorValue(new Color(0, 255, 0), 1.0)});
            this.bGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(0, 0, 0), 0.0), new ColorValue(new Color(0, 0, 255), 1.0)});
            this.hGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(0.0, 1.0, 1.0), 0.0), new ColorValue(new Color(90.0, 1.0, 1.0), 0.25), new ColorValue(new Color(180.0, 1.0, 1.0), 0.5), new ColorValue(new Color(270.0, 1.0, 1.0), 0.75), new ColorValue(new Color(360.0, 1.0, 1.0), 1.0)}, 1);
            this.sGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color((double)this.color.getH(), 0.0, 1.0), 0.0), new ColorValue(new Color((double)this.color.getH(), 1.0, 1.0), 1.0)}, 1);
            this.vGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color((double)this.color.getH(), 1.0, 0.0), 0.0), new ColorValue(new Color((double)this.color.getH(), 1.0, 1.0), 1.0)}, 1);
        }
        this.colorGradient = new ColorGradient(new ColorValue[]{new ColorValue(new Color(this.color.getR(), this.color.getG(), this.color.getB()), 0.0)});
    }

    private void updateWidgets() {
        if (this.internalUpdate) {
            return;
        }
        this.internalUpdate = true;
        this.updateGradients();
        this.rCanvas.setGradient(this.rGradient);
        this.gCanvas.setGradient(this.gGradient);
        this.bCanvas.setGradient(this.bGradient);
        this.hCanvas.setGradient(this.hGradient);
        this.sCanvas.setGradient(this.sGradient);
        this.vCanvas.setGradient(this.vGradient);
        this.colorCanvas.setGradient(this.colorGradient);
        this.rCanvas.setPosition(this.color.getR());
        this.gCanvas.setPosition(this.color.getG());
        this.bCanvas.setPosition(this.color.getB());
        this.hCanvas.setPosition(this.color.getH());
        this.sCanvas.setPosition(this.color.getS());
        this.vCanvas.setPosition(this.color.getV());
        if (!this.rText.isFocusControl()) {
            this.rText.setText(Integer.toString(this.color.getR()));
        }
        if (!this.gText.isFocusControl()) {
            this.gText.setText(Integer.toString(this.color.getG()));
        }
        if (!this.bText.isFocusControl()) {
            this.bText.setText(Integer.toString(this.color.getB()));
        }
        if (!this.hText.isFocusControl()) {
            this.hText.setText(Double.toString(this.color.getH()));
        }
        if (!this.sText.isFocusControl()) {
            this.sText.setText(Double.toString(this.color.getS()));
        }
        if (!this.vText.isFocusControl()) {
            this.vText.setText(Double.toString(this.color.getV()));
        }
        this.internalUpdate = false;
    }

    private abstract class DoubleColorModifyListener
    implements ModifyListener {
        boolean modify = false;
        double min;
        double max;

        public DoubleColorModifyListener(double min, double max) {
            this.min = min;
            this.max = max;
        }

        public void modifyText(ModifyEvent e) {
            if (ColorComposite.this.internalUpdate) {
                return;
            }
            if (this.modify) {
                return;
            }
            this.modify = true;
            Text text = (Text)e.widget;
            try {
                double value = Integer.parseInt(text.getText());
                if (value < this.min) {
                    value = this.min;
                } else if (value > this.max) {
                    value = this.max;
                }
                this.setValue(value);
            }
            catch (NumberFormatException numberFormatException) {}
            this.modify = false;
        }

        abstract void setValue(double var1);
    }

    private static abstract class GradientWidget
    extends ColorGradientCanvas {
        int pos = -1;
        double posD = -1.0;
        int size = 8;
        int sized2 = 4;
        Rectangle prevClip;

        public GradientWidget(Composite parent, int style) {
            super(parent, style);
            this.addMouseListener(new MouseListener(){

                public void mouseDown(MouseEvent e) {
                    if (e.button == 1) {
                        this.update(e);
                    }
                }

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if ((e.stateMask & 0x80000) > 0) {
                        this.update(e);
                    }
                }
            });
        }

        protected void update(MouseEvent e) {
            Rectangle r = this.getClientArea();
            double d = (this.style & 0x100) > 0 ? (double)e.x / (double)r.width : (double)e.y / (double)r.height;
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
            if (this.updatePosition(d)) {
                this.pos = (this.style & 0x100) > 0 ? (int)(d * (double)r.width) : (int)(d * (double)r.height);
                this.posD = d;
            }
        }

        protected abstract boolean updatePosition(double var1);

        protected void setPosition(double d) {
            if (d == this.posD) {
                return;
            }
            this._setPosition(d);
        }

        private void _setPosition(double d) {
            Rectangle r = this.getClientArea();
            this.posD = d;
            this.pos = this.posD >= 0.0 ? ((this.style & 0x100) > 0 ? (int)(d * (double)r.width) : (int)(d * (double)r.height)) : -1;
        }

        @Override
        protected void paintGradient(GC gc, Rectangle clip) {
            super.paintGradient(gc, clip);
            if (!clip.equals((Object)this.prevClip)) {
                this.prevClip = clip;
                this._setPosition(this.posD);
            }
            if (this.pos >= 0) {
                int y;
                int x;
                org.eclipse.swt.graphics.Color white = new org.eclipse.swt.graphics.Color(gc.getDevice(), 255, 255, 255);
                org.eclipse.swt.graphics.Color black = new org.eclipse.swt.graphics.Color(gc.getDevice(), 0, 0, 0);
                gc.setForeground(black);
                gc.setBackground(white);
                if ((this.style & 0x100) > 0) {
                    x = this.pos;
                    y = clip.height / 2;
                } else {
                    x = clip.width / 2;
                    y = this.pos;
                }
                gc.fillOval(x - this.sized2, y - this.sized2, this.size, this.size);
                gc.drawOval(x - this.sized2, y - this.sized2, this.size, this.size);
                white.dispose();
                black.dispose();
            }
        }
    }

    private abstract class IntColorModifyListener
    implements ModifyListener {
        boolean modify = false;

        private IntColorModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ColorComposite.this.internalUpdate) {
                return;
            }
            if (this.modify) {
                return;
            }
            this.modify = true;
            Text text = (Text)e.widget;
            try {
                int value = Integer.parseInt(text.getText());
                if (value < 0) {
                    value = 0;
                }
                if (value > 255) {
                    value = 255;
                }
                this.setValue(value);
            }
            catch (NumberFormatException numberFormatException) {}
            this.modify = false;
        }

        abstract void setValue(int var1);
    }

    private static abstract class IntGradientWidget
    extends GradientWidget {
        public IntGradientWidget(Composite parent, int style) {
            super(parent, style);
        }

        @Override
        protected boolean updatePosition(double d) {
            int value = (int)(d * 255.0);
            if (value < 0) {
                value = 0;
            }
            if (value > 255) {
                value = 255;
            }
            this.updatePosition(value);
            return true;
        }

        protected abstract void updatePosition(int var1);

        protected void setPosition(int value) {
            double d = (double)value / 255.0;
            this.setPosition(d);
        }
    }
}

