/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.modifiers.EnumeratedValue;
import org.simantics.browsing.ui.common.modifiers.Enumeration;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.swt.contentassist.ContentAssistTextField;
import org.simantics.browsing.ui.swt.contentassist.INamedObject;
import org.simantics.browsing.ui.swt.contentassist.NamedObject;

public abstract class AbstractContentAssistModifier<T>
implements Labeler.CustomModifier {
    protected final Enumeration<T> enumeration;
    protected final T value;
    protected ContentAssistTextField text;

    public AbstractContentAssistModifier(Enumeration<T> enumeration, T value) {
        if (enumeration == null) {
            throw new NullPointerException("null enumeration");
        }
        if (enumeration.size() == 0) {
            throw new IllegalArgumentException("");
        }
        this.enumeration = enumeration;
        this.value = value;
    }

    public String getValue() {
        if (this.value != null) {
            return this.value.toString();
        }
        return ((EnumeratedValue)this.enumeration.values().get(0)).getName();
    }

    public String isValid(String label) {
        if (this.enumeration.findByName(label) == null) {
            return "Value '" + label + "' is not among the enumerated values " + String.valueOf(this.enumeration.values());
        }
        return null;
    }

    public void modify(String label) {
        String error = this.isValid(label);
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        this.modifyWithValue(this.value, label);
    }

    abstract void modifyWithValue(T var1, String var2);

    protected NamedObject<T> createNamedObject(EnumeratedValue<T> value) {
        return new NamedObject<Object>(value.getObject(), value.getName());
    }

    protected List<NamedObject<T>> toNamedObjects(Enumeration<T> enumeration) {
        ArrayList<NamedObject<T>> namedObjects = new ArrayList<NamedObject<T>>();
        for (EnumeratedValue v : enumeration.values()) {
            namedObjects.add(this.createNamedObject(v));
        }
        return namedObjects;
    }

    public Object createControl(Object parentControl, Object controlItem, final int columnIndex, NodeContext context) {
        Composite parent = (Composite)parentControl;
        final TreeItem item = (TreeItem)controlItem;
        List<NamedObject<T>> possibleValues = this.toNamedObjects(this.enumeration);
        EnumeratedValue enuValue = this.enumeration.find(this.value);
        NamedObject<T> selectedValue = enuValue != null ? this.createNamedObject(enuValue) : null;
        this.text = new ContentAssistTextField(parent, selectedValue, possibleValues, 0);
        Listener textListener = new Listener(){
            String error;

            public void handleEvent(Event e) {
                block0 : switch (e.type) {
                    case 24: {
                        String newText = AbstractContentAssistModifier.this.text.getControl().getText();
                        this.error = AbstractContentAssistModifier.this.isValid(newText);
                        if (this.error != null) {
                            AbstractContentAssistModifier.this.text.getControl().setBackground(AbstractContentAssistModifier.this.text.getDisplay().getSystemColor(3));
                            break;
                        }
                        AbstractContentAssistModifier.this.text.getControl().setBackground(null);
                        break;
                    }
                    case 25: {
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                String txt;
                                INamedObject obj = AbstractContentAssistModifier.this.text.getResult();
                                String string = txt = obj != null ? obj.getName() : AbstractContentAssistModifier.this.text.getControl().getText();
                                if (txt == null || this.error != null) {
                                    e.doit = false;
                                    return;
                                }
                                AbstractContentAssistModifier.this.modify(txt);
                                if (!item.isDisposed()) {
                                    item.setText(columnIndex, txt);
                                }
                            }
                            case 2: {
                                AbstractContentAssistModifier.this.text.dispose();
                                e.doit = false;
                                break block0;
                            }
                        }
                    }
                }
            }
        };
        this.text.getControl().addListener(24, textListener);
        this.text.getControl().addListener(31, textListener);
        this.text.setFocus();
        this.text.text.selectAll();
        this.text.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!AbstractContentAssistModifier.this.text.isDisposed()) {
                    AbstractContentAssistModifier.this.text.openAssist();
                }
            }
        });
        return this.text;
    }
}

