/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.chr;

import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.expressions.block.IncludeStatement;
import org.simantics.scl.compiler.internal.codegen.chr.CHRCodeGenerationConstants;
import org.simantics.scl.compiler.internal.codegen.chr.CHRFactCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.chr.CHRPriorityFactContainerCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.chr.StoreInitialization;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;

public class CHRRuntimeRulesetCodeGenerator
implements CHRCodeGenerationConstants {
    public static void generateRuntimeRuleset(ModuleBuilder moduleBuilder, CHRRuleset ruleset) {
        ClassBuilder storeClassBuilder = new ClassBuilder(moduleBuilder, 1, ruleset.runtimeRulesetClassName, "org/simantics/scl/runtime/chr/CHRRuntimeRuleset", new String[0]);
        if (ruleset.rulesetObject.parameters == null) {
            ruleset.rulesetObject.parameters = new BoundVar[0];
        }
        ruleset.rulesetObject.parameterTypeDescs = moduleBuilder.getJavaTypeTranslator().getTypeDescs(ruleset.rulesetObject.parameters);
        TypeDesc[] parameterTypeDescs = ruleset.rulesetObject.parameterTypeDescs;
        ArrayList<StoreInitialization> hashIndexInitializations = new ArrayList<StoreInitialization>();
        for (CHRConstraint constraint : ruleset.constraints) {
            CHRRuntimeRulesetCodeGenerator.generateFact(storeClassBuilder, ruleset, constraint, hashIndexInitializations);
        }
        int i2 = ruleset.rules.size() - 1;
        while (i2 >= 0) {
            CHRRuntimeRulesetCodeGenerator.generateFactContainer(storeClassBuilder, ruleset, ruleset.rules.get(i2));
            --i2;
        }
        i2 = 0;
        while (i2 < parameterTypeDescs.length) {
            TypeDesc typeDesc = parameterTypeDescs[i2];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                storeClassBuilder.addField(17, CHRCodeGenerationConstants.parameterName(i2), typeDesc);
            }
            ++i2;
        }
        for (StoreInitialization ini : hashIndexInitializations) {
            storeClassBuilder.addField(ini.access, ini.fieldName, ini.fieldType);
        }
        for (CHRRule rule : ruleset.rules) {
            storeClassBuilder.addField(17, CHRCodeGenerationConstants.priorityName(rule.priority), CHRPriorityFactContainer);
        }
        if (ruleset.extensible) {
            for (CHRConstraint constraint : ruleset.constraints) {
                if (constraint.nextContainerFieldName == null) continue;
                storeClassBuilder.addField(1, constraint.nextContainerFieldName, CHRPriorityFactContainer);
            }
        }
        MethodBuilder mb = storeClassBuilder.addConstructor(1, parameterTypeDescs);
        mb.loadThis();
        mb.invokeConstructor(storeClassBuilder.getSuperClassName(), Constants.EMPTY_TYPEDESC_ARRAY);
        int p = 0;
        int i3 = 0;
        while (i3 < parameterTypeDescs.length) {
            TypeDesc typeDesc = parameterTypeDescs[i3];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                mb.loadThis();
                mb.loadLocal(mb.getParameter(p++));
                mb.storeField(ruleset.runtimeRulesetClassName, CHRCodeGenerationConstants.parameterName(i3), parameterTypeDescs[i3]);
            }
            ++i3;
        }
        for (StoreInitialization ini : hashIndexInitializations) {
            mb.loadThis();
            mb.newObject(ini.className);
            mb.dup();
            mb.invokeConstructor(ini.className, Constants.EMPTY_TYPEDESC_ARRAY);
            mb.storeField(ruleset.runtimeRulesetClassName, ini.fieldName, ini.fieldType);
        }
        TypeDesc[] runtimeRulesetTypeDescArray = new TypeDesc[]{TypeDesc.forClass(storeClassBuilder.getClassName())};
        for (CHRRule rule : ruleset.rules) {
            mb.loadThis();
            mb.newObject(rule.containerClassName);
            mb.dup();
            mb.loadThis();
            mb.invokeConstructor(rule.containerClassName, runtimeRulesetTypeDescArray);
            mb.storeField(ruleset.runtimeRulesetClassName, CHRCodeGenerationConstants.priorityName(rule.priority), CHRPriorityFactContainer);
        }
        mb.returnVoid();
        mb.finish();
        for (IncludeStatement include : ruleset.includes) {
            int minimumPriority;
            MethodBuilderBase mb2 = storeClassBuilder.addMethodBase(1, "register", TypeDesc.VOID, new TypeDesc[]{CHRContext, include.ruleset.runtimeRulesetTypeDesc});
            LocalVariable contextVar = mb2.getParameter(0);
            LocalVariable importedStore = mb2.getParameter(1);
            ArrayList list = (ArrayList)ruleset.inverseActiveConstraintSourceMap.get((Object)include);
            if (list != null) {
                for (CHRConstraint constraint : list) {
                    minimumPriority = ruleset.getMinimumPriority(constraint);
                    if (minimumPriority == Integer.MAX_VALUE) continue;
                    mb2.loadLocal(importedStore);
                    mb2.loadThis();
                    mb2.loadField(storeClassBuilder.getClassName(), CHRCodeGenerationConstants.priorityName(minimumPriority), CHRPriorityFactContainer);
                    mb2.storeField(include.ruleset.runtimeRulesetClassName, CHRCodeGenerationConstants.nextContainerName(constraint.name), CHRPriorityFactContainer);
                }
            }
            mb2.loadLocal(importedStore);
            mb2.loadLocal(contextVar);
            mb2.invokeVirtual("org/simantics/scl/runtime/chr/CHRRuntimeRuleset", "register", TypeDesc.VOID, new TypeDesc[]{CHRContext});
            mb2.returnVoid();
            mb2.finish();
            mb2 = storeClassBuilder.addMethodBase(1, "unregister", TypeDesc.VOID, new TypeDesc[]{CHRContext, include.ruleset.runtimeRulesetTypeDesc});
            contextVar = mb2.getParameter(0);
            importedStore = mb2.getParameter(1);
            list = (ArrayList)ruleset.inverseActiveConstraintSourceMap.get((Object)include);
            if (list != null) {
                for (CHRConstraint constraint : list) {
                    minimumPriority = ruleset.getMinimumPriority(constraint);
                    if (minimumPriority == Integer.MAX_VALUE) continue;
                    mb2.loadLocal(importedStore);
                    mb2.loadNull();
                    mb2.storeField(include.ruleset.runtimeRulesetClassName, CHRCodeGenerationConstants.nextContainerName(constraint.name), CHRPriorityFactContainer);
                }
            }
            mb2.loadLocal(importedStore);
            mb2.loadLocal(contextVar);
            mb2.invokeVirtual("org/simantics/scl/runtime/chr/CHRRuntimeRuleset", "unregister", TypeDesc.VOID, new TypeDesc[]{CHRContext});
            mb2.returnVoid();
            mb2.finish();
        }
        if (ruleset.initializer != null) {
            mb = storeClassBuilder.addMethod(1, "initialize", TypeDesc.VOID, new TypeDesc[]{CHRContext});
            ruleset.rulesetObject.realizeMethod(mb, (i, target) -> {
                mb.loadThis();
                mb.loadField(cHRRuleset.runtimeRulesetClassName, CHRCodeGenerationConstants.parameterName(i), parameterTypeDescs[i]);
                mb.store(target);
            }, ruleset.initializer, mb.getThis(ruleset.runtimeRulesetTypeDesc), mb.getParameter(0));
            mb.finish();
        }
        if (ruleset.deinitializer != null) {
            mb = storeClassBuilder.addMethod(1, "deinitialize", TypeDesc.VOID, new TypeDesc[]{CHRContext});
            ruleset.rulesetObject.realizeMethod(mb, (i, target) -> {
                mb.loadThis();
                mb.loadField(cHRRuleset.runtimeRulesetClassName, CHRCodeGenerationConstants.parameterName(i), parameterTypeDescs[i]);
                mb.store(target);
            }, ruleset.deinitializer, mb.getThis(ruleset.runtimeRulesetTypeDesc), mb.getParameter(0));
            mb.finish();
        }
        moduleBuilder.addClass(storeClassBuilder);
    }

    private static void generateFact(ClassBuilder storeClassBuilder, CHRRuleset ruleset, CHRConstraint constraint, ArrayList<StoreInitialization> hashIndexInitializations) {
        CHRFactCodeGenerator generator = new CHRFactCodeGenerator(storeClassBuilder, ruleset, constraint);
        generator.generate(hashIndexInitializations);
    }

    private static void generateFactContainer(ClassBuilder storeClassBuilder, CHRRuleset ruleset, CHRRule rule) {
        CHRPriorityFactContainerCodeGenerator generator = new CHRPriorityFactContainerCodeGenerator(storeClassBuilder, ruleset, rule);
        generator.generate();
        rule.containerClassName = generator.containerClassName;
    }
}

