/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.query;

import gnu.trove.map.hash.THashMap;
import java.util.Collection;
import java.util.Set;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.QAbstractModifier;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.QueryVisitor;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.DerivateException;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.relations.LocalRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class QExists
extends QAbstractModifier {
    public Variable[] variables;

    public QExists(Variable[] variables, Query query) {
        super(query);
        this.variables = variables;
    }

    public QExists(Collection<Variable> variables, Query query) {
        this(variables.toArray(new Variable[variables.size()]), query);
    }

    @Override
    public void checkType(TypingContext context) {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            var.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        super.checkType(context);
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context) throws UnsolvableQueryException {
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            context.addVariable(variable);
            ++n2;
        }
        this.query.collectConstraints(context);
    }

    @Override
    public Query.Diff[] derivate(THashMap<LocalRelation, Query.Diffable> diffables) throws DerivateException {
        Query.Diff[] result = this.query.derivate(diffables);
        int i = 0;
        while (i < result.length) {
            result[i].query = new QExists(this.variables, result[i].query);
            ++i;
        }
        return result;
    }

    @Override
    public Query replace(ReplaceContext context) {
        Variable[] newVariables = new Variable[this.variables.length];
        int i = 0;
        while (i < this.variables.length) {
            Variable newVariable;
            Variable variable = this.variables[i];
            newVariables[i] = newVariable = new Variable(variable.getName(), variable.getType().replace(context.tvarMap));
            context.varMap.put((Object)variable, (Object)new EVariable(newVariable));
            ++i;
        }
        QExists result = new QExists(newVariables, this.query.replace(context));
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable v = variableArray[n2];
            context.varMap.remove((Object)v);
            ++n2;
        }
        return result;
    }

    @Override
    public Query removeRelations(Set<SCLRelation> relations) {
        Query newQuery = this.query.removeRelations(relations);
        if (newQuery == this.query) {
            return this;
        }
        if (newQuery == EMPTY_QUERY) {
            return EMPTY_QUERY;
        }
        return new QExists(this.variables, newQuery);
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }
}

