/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.example;

import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.handler.Validator;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.impl.DummyDiagramMutator;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementHeartbeater;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.FillColor;
import org.simantics.g2d.element.handler.Move;
import org.simantics.g2d.element.handler.ParentTransform;
import org.simantics.g2d.element.handler.Resize;
import org.simantics.g2d.element.handler.TerminalTopology;
import org.simantics.g2d.element.handler.Text;
import org.simantics.g2d.element.handler.impl.ElementParentTransform;
import org.simantics.g2d.element.impl.Element;
import org.simantics.g2d.elementclass.BoxClass;
import org.simantics.g2d.elementclass.FilmClass;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.g2d.elementclass.ImageClass;
import org.simantics.g2d.elementclass.LabelClass;
import org.simantics.g2d.elementclass.ShapeClass;
import org.simantics.g2d.elementclass.button.ButtonClass;
import org.simantics.g2d.elementclass.button.ToggleButtonClass;
import org.simantics.g2d.elementclass.canvas.CanvasClass;
import org.simantics.g2d.elementclass.canvas.ElementViewport;
import org.simantics.g2d.elementclass.connection.EdgeClass;
import org.simantics.g2d.elementclass.slider.SliderClass;
import org.simantics.g2d.elementclass.valve.ValveClass;
import org.simantics.g2d.elementclass.wheel.WheelClass;
import org.simantics.g2d.example.LoadingMessageDiagram;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.multileveldiagram.LayerComposition;
import org.simantics.g2d.multileveldiagram.TransitionFunction;
import org.simantics.g2d.multileveldiagram.ZoomTransitionParticipant;
import org.simantics.g2d.participant.BackgroundPainter;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.GridPainter;
import org.simantics.g2d.participant.KeyToCommand;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.PointerPainter;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.tooltip.EditableTextTooltipProvider2;
import org.simantics.g2d.tooltip.TextTooltipProvider;
import org.simantics.g2d.tooltip.TooltipParticipant;
import org.simantics.scenegraph.g2d.events.command.CommandKeyBinding;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.IThreadWorkQueue;

public class TestCanvas {
    public static final Color C1 = new Color(0.7f, 0.7f, 0.7f);
    public static final Color C2 = new Color(0.8f, 0.8f, 0.8f);
    public static final Color C3 = new Color(0.9f, 0.9f, 0.9f);
    public static final Color C4 = new Color(1.0f, 1.0f, 1.0f);

    public static CanvasContext createDefaultCanvas(IThreadWorkQueue thread) {
        CanvasContext canvasContext = new CanvasContext(thread);
        IHintContext h = canvasContext.getDefaultHintContext();
        canvasContext.add(new PanZoomRotateHandler());
        canvasContext.add(new TransformUtil());
        canvasContext.add(new MouseUtil());
        canvasContext.add(new KeyUtil());
        canvasContext.add(new CanvasGrab());
        canvasContext.add(new SymbolUtil());
        canvasContext.add(new TimeParticipant());
        h.setHint(PointerPainter.KEY_PAINT_POINTER, (Object)true);
        canvasContext.add(new GridPainter());
        canvasContext.add(new RulerPainter());
        canvasContext.add(new BackgroundPainter());
        h.setHint(Hints.KEY_GRID_COLOR, (Object)new Color(0.95f, 0.95f, 0.95f));
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        h.setHint(RulerPainter.KEY_RULER_BACKGROUND_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f, 0.75f));
        h.setHint(RulerPainter.KEY_RULER_TEXT_COLOR, (Object)Color.BLACK);
        canvasContext.add(new KeyToCommand(CommandKeyBinding.DEFAULT_BINDINGS));
        canvasContext.add(new PointerInteractor(true, true, true, false, true, ElementClassProviders.staticProvider(EdgeClass.STRAIGHT)));
        canvasContext.add(new ElementInteractor());
        canvasContext.add(new Selection());
        canvasContext.add(new DiagramParticipant());
        canvasContext.add(new ElementPainter());
        canvasContext.add(new TerminalPainter(true, true, false, true));
        canvasContext.add(new ElementHeartbeater());
        canvasContext.add(new ZOrderHandler());
        canvasContext.add(new ZoomTransitionParticipant(TransitionFunction.SIGMOID));
        canvasContext.add(new CanvasBoundsParticipant());
        canvasContext.add(new TooltipParticipant());
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        return canvasContext;
    }

    public static IDiagram createMultilevelDiagram(ICanvasContext ctx) {
        IDiagram loading = LoadingMessageDiagram.createLoadingDiagram();
        IDiagram d1 = TestCanvas.createDiagram1();
        IDiagram d2 = TestCanvas.createDiagram2();
        IDiagram d3 = TestCanvas.createDiagram3();
        TestCanvas.validate(d1, ctx);
        TestCanvas.validate(d2, ctx);
        TestCanvas.validate(d3, ctx);
        LayerComposition composition = new LayerComposition();
        composition.addLayer(d1, null, 2.0);
        composition.addLayer(d2, 5.0, 7.0);
        composition.addLayer(d3, 10.0, null);
        List<LayerComposition.LayerInfo> lis = composition.buildMorphLayers();
        loading.setHint(DiagramHints.KEY_LAYER_COMPOSITION, lis);
        return loading;
    }

    public static CanvasContext createTestCanvas(IThreadWorkQueue thread) {
        CanvasContext canvasContext = TestCanvas.createDefaultCanvas(thread);
        IHintContext h = canvasContext.getDefaultHintContext();
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        TestCanvas.createWidgetsDiagram();
        IDiagram uid = TestCanvas.createUIDiagram();
        h.setHint(DiagramHints.KEY_DIAGRAM, (Object)uid);
        return canvasContext;
    }

    public static IDiagram createUIDiagram(IElement forElement) {
        String name = "User Interface Diagram";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement film = Element.spawnNew(FilmClass.FILM_CLASS);
        ElementUtils.fitToRectangle(film, new Rectangle2D.Double(0.0, 10.0, 200.0, 160.0));
        d.addElement(film);
        IElement preview = Element.spawnNew(CanvasClass.ELEMENT_VIEWPORT_CLASS);
        preview.setHint(ElementViewport.KEY_ELEMENT, forElement);
        d.addElement(preview);
        ElementUtils.fitToRectangle(preview, new Rectangle2D.Double(10.0, 20.0, 60.0, 60.0));
        ElementUtils.setBorderColor(preview, Color.WHITE);
        TestCanvas.createButton(d, 10.0, 140.0, 50.0, 20.0, "Cancel", "Cancel");
        TestCanvas.createButton(d, 74.0, 140.0, 50.0, 20.0, "Apply", "Apply");
        TestCanvas.createButton(d, 134.0, 140.0, 50.0, 20.0, "OK", "OK");
        TestCanvas.createToggleButton(d, 10.0, 110.0, 50.0, 20.0, "Toggle", "Toggle");
        String eleName = "?";
        Text text = forElement.getElementClass().getAtMostOneItemOfClass(Text.class);
        if (text != null) {
            eleName = text.getText(forElement);
        }
        IElement nameLbl = TestCanvas.createLabel(d, 10.0, 90.0, "nameLbl", eleName);
        ElementUtils.setTextColor(nameLbl, Color.WHITE);
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createUIDiagram() {
        String name = "User Interface Diagram";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement film = Element.spawnNew(FilmClass.FILM_CLASS);
        ElementUtils.fitToRectangle(film, new Rectangle2D.Double(0.0, 10.0, 200.0, 160.0));
        d.addElement(film);
        TestCanvas.createButton(d, 10.0, 140.0, 50.0, 20.0, "Cancel", "Cancel");
        IElement apply = TestCanvas.createButton(d, 74.0, 140.0, 50.0, 20.0, "Apply", "Apply");
        TestCanvas.createButton(d, 134.0, 140.0, 50.0, 20.0, "OK", "OK");
        IElement toggle = TestCanvas.createToggleButton(d, 10.0, 110.0, 50.0, 20.0, "Toggle", "Toggle");
        toggle.setHint(TooltipParticipant.TOOLTIP_KEY, new TextTooltipProvider(){

            @Override
            public String getTooltipText(IElement element) {
                return element.toString();
            }
        });
        apply.setHint(TooltipParticipant.TOOLTIP_KEY, new EditableTextTooltipProvider2(){

            @Override
            public void setText(IElement element, String text) {
                ElementUtils.setText(element, text);
            }

            @Override
            public String getTooltipText(IElement element) {
                return ElementUtils.getText(element);
            }
        });
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createConnectTestDiagram() {
        String name = "Diagram";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement box1 = TestCanvas.createBox(d, 0.0, 0.0, 70.0, 70.0, C4, "1");
        IElement box2 = TestCanvas.createBox(d, 120.0, 0.0, 80.0, 70.0, C4, "2");
        TestCanvas.connect(d, box1, 4, box2, 8);
        TestCanvas.createLabel(d, 50.0, 90.0, "label", name);
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createAnchorTestDiagram() {
        String name = "Diagram";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement box1 = TestCanvas.createBox(d, 0.0, 0.0, 70.0, 70.0, C4, "1");
        IElement box2 = TestCanvas.createBox(d, 120.0, 0.0, 80.0, 70.0, C4, "2");
        IElement box3 = TestCanvas.createBox(d, 30.0, 90.0, 40.0, 40.0, C3, "3");
        ElementParentTransform pt = (ElementParentTransform)box3.getElementClass().getSingleItem(ParentTransform.class);
        pt.setParent(box3, box2);
        TestCanvas.connect(d, box1, 4, box2, 8);
        TestCanvas.createLabel(d, 50.0, 90.0, "label", name);
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createFlagTestDiagram() {
        String name = "Diagram";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement e1 = TestCanvas.createFlag(d, -100.0, 0.0, 0.0, FlagClass.Type.In, C4, "I3", "From Z");
        IElement e2 = TestCanvas.createFlag(d, -80.0, 20.0, 90.0, FlagClass.Type.In, C4, "I2", "From Y");
        IElement e3 = TestCanvas.createFlag(d, -100.0, 40.0, 180.0, FlagClass.Type.Out, C4, "I1", "To X");
        IElement e4 = TestCanvas.createFlag(d, -120.0, 20.0, 270.0, FlagClass.Type.Out, C4, "I4", "To W");
        IElement e5 = TestCanvas.createFlag(d, -120.0, 120.0, 270.0, FlagClass.Type.Out, C4, "I5", "To P");
        e1.setHint(FlagClass.KEY_FLAG_TEXT, new String[]{"THIS"});
        e2.setHint(FlagClass.KEY_FLAG_TEXT, new String[]{"THIS", "is"});
        e3.setHint(FlagClass.KEY_FLAG_TEXT, new String[]{"THIS", "is", "DEBUG"});
        e4.setHint(FlagClass.KEY_FLAG_TEXT, new String[]{"THIS", "is", "DEBUG", "INFO"});
        e5.setHint(FlagClass.KEY_FLAG_TEXT, new String[]{"THIS", "is", "DEBUG", "INFO", "FOO!"});
        TestCanvas.createFlag(d, 100.0, 50.0, 0.0, FlagClass.Type.Out, C2, "J1O", "O", FlagClass.Mode.Internal);
        TestCanvas.createFlag(d, 100.0, 100.0, 0.0, FlagClass.Type.Out, C2, "J2O", "Oy", FlagClass.Mode.Internal);
        TestCanvas.createFlag(d, 100.0, 150.0, 90.0, FlagClass.Type.Out, C2, "J3O", "OAAAA", FlagClass.Mode.Internal);
        TestCanvas.createFlag(d, 150.0, 50.0, 0.0, FlagClass.Type.In, C2, "J1I", "I", FlagClass.Mode.Internal);
        TestCanvas.createFlag(d, 150.0, 100.0, 0.0, FlagClass.Type.In, C2, "J2I", "Iy", FlagClass.Mode.Internal);
        TestCanvas.createFlag(d, 150.0, 150.0, 90.0, FlagClass.Type.In, C2, "J3I", "IAAAA", FlagClass.Mode.Internal);
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createDiagram1() {
        String name = "Diagram Level 1";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement box1 = TestCanvas.createBox(d, 0.0, 0.0, 70.0, 70.0, C4, "1");
        IElement box2 = TestCanvas.createBox(d, 120.0, 0.0, 80.0, 70.0, C4, "2");
        TestCanvas.connect(d, box1, 4, box2, 8);
        TestCanvas.createLabel(d, 50.0, 90.0, "label", name);
        TestCanvas.createSlider(d, 600.0, 0.0, 100.0, 28.0, "slider");
        TestCanvas.createValve(d, 800.0, 0.0, "valve");
        TestCanvas.createButton(d, 800.0, 100.0, 100.0, 28.0, "button", "button");
        TestCanvas.createImage(d, 400, 400, (Image)DefaultImages.UNKNOWN.get());
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createDiagram2() {
        String name = "Diagram Level 2";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement box1 = TestCanvas.createBox(d, 0.0, 30.0, 70.0, 10.0, C3, "1");
        IElement box1_1 = TestCanvas.createBox(d, 20.0, 0.0, 50.0, 20.0, C2, "1.1");
        IElement box1_2 = TestCanvas.createBox(d, 0.0, 50.0, 70.0, 20.0, C2, "1.2");
        IElement box2 = TestCanvas.createBox(d, 120.0, 0.0, 20.0, 70.0, C3, "2");
        IElement box2_2 = TestCanvas.createBox(d, 150.0, 0.0, 50.0, 20.0, C2, "2.2");
        IElement box2_3 = TestCanvas.createBox(d, 150.0, 30.0, 50.0, 40.0, C2, "2.3");
        TestCanvas.connect(d, box1, 4, box2, 8);
        TestCanvas.connect(d, box1, 2, box1_1, 6);
        TestCanvas.connect(d, box1, 6, box1_2, 2);
        TestCanvas.connect(d, box2, 4, box2_2, 8);
        TestCanvas.connect(d, box2, 4, box2_3, 8);
        TestCanvas.createLabel(d, 50.0, 90.0, "label", name);
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createDiagram3() {
        String name = "Diagram Level 3";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        IElement box1 = TestCanvas.createBox(d, 0.0, 30.0, 70.0, 10.0, C3, "1");
        IElement box1_1 = TestCanvas.createBox(d, 30.0, 0.0, 40.0, 20.0, C2, "1.1");
        IElement box1_1_1 = TestCanvas.createBox(d, 0.0, 0.0, 20.0, 20.0, C2, "1.1.1");
        IElement box1_2 = TestCanvas.createBox(d, 30.0, 50.0, 40.0, 20.0, C2, "1.2");
        IElement box1_2_1 = TestCanvas.createBox(d, 0.0, 50.0, 20.0, 20.0, C1, "1.2.1");
        IElement box2 = TestCanvas.createBox(d, 120.0, 30.0, 20.0, 40.0, C3, "2");
        IElement box2_1 = TestCanvas.createBox(d, 120.0, 0.0, 20.0, 20.0, C2, "2.1");
        IElement box2_2 = TestCanvas.createBox(d, 150.0, 0.0, 20.0, 20.0, C2, "2.2");
        IElement box2_2_1 = TestCanvas.createBox(d, 180.0, 0.0, 20.0, 20.0, C1, "2.2.1");
        IElement box2_3 = TestCanvas.createBox(d, 150.0, 30.0, 20.0, 20.0, C2, "2.3");
        IElement box2_3_1 = TestCanvas.createBox(d, 180.0, 30.0, 20.0, 20.0, C1, "2.3.1");
        IElement box2_3_2 = TestCanvas.createBox(d, 180.0, 60.0, 20.0, 20.0, C1, "2.3.2");
        TestCanvas.connect(d, box1, 4, box2, 8);
        TestCanvas.connect(d, box1, 2, box1_1, 6);
        TestCanvas.connect(d, box1_1, 8, box1_1_1, 4);
        TestCanvas.connect(d, box1, 6, box1_2, 2);
        TestCanvas.connect(d, box1_2, 8, box1_2_1, 4);
        TestCanvas.connect(d, box2, 2, box2_1, 6);
        TestCanvas.connect(d, box2, 3, box2_2, 7);
        TestCanvas.connect(d, box2_2, 4, box2_2_1, 8);
        TestCanvas.connect(d, box2, 4, box2_3, 8);
        TestCanvas.connect(d, box2_3, 4, box2_3_1, 8);
        TestCanvas.connect(d, box2_3, 5, box2_3_2, 1);
        TestCanvas.createLabel(d, 50.0, 90.0, "label", name);
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createWidgetsDiagram() {
        String name = "Test Diagram";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        TestCanvas.createValve(d, 0.0, 0.0, "valve");
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IDiagram createOperationSymbolsDiagram() {
        String name = "Operation Symbols Diagram";
        IDiagram d = Diagram.spawnNew(DiagramClass.DEFAULT);
        d.setHint(DiagramHints.KEY_TEXT, name);
        TestCanvas.createShape(d, new Ellipse2D.Double(-10.0, -10.0, 20.0, 20.0), -50.0, 0.0, Color.RED, "circle");
        d.setHint(DiagramHints.KEY_MUTATOR, new DummyDiagramMutator(d));
        return d;
    }

    public static IElement createSymbol(IDiagram d, ElementClass clazz, double x, double y, Object dada) {
        IElement box = Element.spawnNew(clazz);
        d.addElement(box);
        Move m = box.getElementClass().getSingleItem(Move.class);
        m.moveTo(box, x, y);
        box.setHint(ElementHints.KEY_TEXT, dada.toString());
        box.setHint(ElementHints.KEY_OBJECT, dada);
        return box;
    }

    public static IElement createBox(IDiagram d, double x, double y, double width, double height, Color color, Object dada) {
        IElement box = Element.spawnNew(BoxClass.BOXCLASS.newClassWith(ElementParentTransform.INSTANCE));
        d.addElement(box);
        Move m = box.getElementClass().getSingleItem(Move.class);
        Resize s = box.getElementClass().getSingleItem(Resize.class);
        FillColor ch = box.getElementClass().getSingleItem(FillColor.class);
        ch.setFillColor(box, color);
        m.moveTo(box, x, y);
        s.resize(box, new Rectangle2D.Double(0.0, 0.0, width, height));
        box.setHint(ElementHints.KEY_TEXT, dada.toString());
        box.setHint(ElementHints.KEY_OBJECT, dada);
        return box;
    }

    private static IElement createImage(IDiagram d, int x, int y, Image image) {
        IElement result = Element.spawnNew(ImageClass.INSTANCE);
        d.addElement(result);
        ElementUtils.setPos(result, x, y);
        result.setHint(ElementHints.KEY_IMAGE, image);
        return result;
    }

    public static IElement createShape(IDiagram d, Shape shape, double x, double y, Color color, Object dada) {
        IElement box = Element.spawnNew(ShapeClass.CIRCLE_CLASS);
        d.addElement(box);
        Move m = box.getElementClass().getSingleItem(Move.class);
        FillColor ch = box.getElementClass().getSingleItem(FillColor.class);
        ch.setFillColor(box, color);
        m.moveTo(box, x, y);
        box.setHint(ElementHints.KEY_TEXT, dada.toString());
        box.setHint(ElementHints.KEY_OBJECT, dada);
        return box;
    }

    public static IElement createSlider(IDiagram d, double x, double y, double width, double height, Object dada) {
        IElement e = Element.spawnNew(SliderClass.SLIDER);
        d.addElement(e);
        Move m = e.getElementClass().getSingleItem(Move.class);
        Resize s = e.getElementClass().getSingleItem(Resize.class);
        m.moveTo(e, x, y);
        s.resize(e, new Rectangle2D.Double(0.0, 0.0, width, height));
        e.setHint(ElementHints.KEY_OBJECT, dada);
        return e;
    }

    public static IElement createValve(IDiagram d, double x, double y, Object dada) {
        IElement e = Element.spawnNew(ValveClass.INSTANCE);
        d.addElement(e);
        Move m = e.getElementClass().getSingleItem(Move.class);
        m.moveTo(e, x, y);
        e.setHint(ElementHints.KEY_OBJECT, dada);
        return e;
    }

    public static IElement createWheel(IDiagram d, double x, double y, double width, double height, Object dada) {
        IElement e = Element.spawnNew(WheelClass.WHEEL);
        d.addElement(e);
        ElementUtils.fitToRectangle(e, new Rectangle2D.Double(x, y, width, height));
        e.setHint(ElementHints.KEY_OBJECT, dada);
        return e;
    }

    public static IElement createLabel(IDiagram d, double x, double y, Object dada, String label) {
        IElement e = Element.spawnNew(LabelClass.CLASS);
        d.addElement(e);
        Move m = e.getElementClass().getSingleItem(Move.class);
        m.moveTo(e, x, y);
        ElementUtils.setText(e, label);
        e.setHint(ElementHints.KEY_OBJECT, dada);
        return e;
    }

    public static IElement createButton(IDiagram d, double x, double y, double width, double height, Object dada, String label) {
        IElement e = Element.spawnNew(ButtonClass.BUTTON_CLASS);
        d.addElement(e);
        Move m = e.getElementClass().getSingleItem(Move.class);
        m.moveTo(e, x, y);
        Resize s = e.getElementClass().getSingleItem(Resize.class);
        s.resize(e, new Rectangle2D.Double(0.0, 0.0, width, height));
        Text t = e.getElementClass().getSingleItem(Text.class);
        t.setText(e, label);
        e.setHint(ElementHints.KEY_OBJECT, dada);
        return e;
    }

    public static IElement createFlag(IDiagram d, double x, double y, double dir, FlagClass.Type type, Color color, Object dada, String label) {
        return TestCanvas.createFlag(d, x, y, dir, type, color, dada, label, FlagClass.Mode.External);
    }

    public static IElement createFlag(IDiagram d, double x, double y, double dir, FlagClass.Type type, Color color, Object dada, String label, FlagClass.Mode mode) {
        IElement f = Element.spawnNew(FlagClass.FLAGCLASS);
        d.addElement(f);
        Move m = f.getElementClass().getSingleItem(Move.class);
        FillColor ch = f.getElementClass().getSingleItem(FillColor.class);
        ch.setFillColor(f, color);
        m.moveTo(f, x, y);
        Text t = f.getElementClass().getSingleItem(Text.class);
        t.setText(f, label);
        f.setHint(ElementHints.KEY_OBJECT, dada);
        f.setHint(FlagClass.KEY_FLAG_TYPE, (Object)type);
        f.setHint(FlagClass.KEY_FLAG_MODE, mode);
        return f;
    }

    public static IElement createToggleButton(IDiagram d, double x, double y, double width, double height, Object dada, String label) {
        IElement e = Element.spawnNew(ToggleButtonClass.BUTTON_CLASS);
        d.addElement(e);
        Move m = e.getElementClass().getSingleItem(Move.class);
        m.moveTo(e, x, y);
        Resize s = e.getElementClass().getSingleItem(Resize.class);
        s.resize(e, new Rectangle2D.Double(0.0, 0.0, width, height));
        Text t = e.getElementClass().getSingleItem(Text.class);
        t.setText(e, label);
        e.setHint(ElementHints.KEY_OBJECT, dada);
        return e;
    }

    public static IElement connect(IDiagram d, IElement e1, int t1, IElement e2, int t2) {
        ArrayList<Topology.Terminal> boxTerminals = new ArrayList<Topology.Terminal>();
        TerminalTopology boxNodeHandler = e1.getElementClass().getSingleItem(TerminalTopology.class);
        boxNodeHandler.getTerminals(e1, boxTerminals);
        Topology.Terminal _t1 = (Topology.Terminal)boxTerminals.get(t1);
        boxTerminals.clear();
        boxNodeHandler = e2.getElementClass().getSingleItem(TerminalTopology.class);
        boxNodeHandler.getTerminals(e2, boxTerminals);
        Topology.Terminal _t2 = (Topology.Terminal)boxTerminals.get(t2);
        IElement edge = Element.spawnNew(EdgeClass.STRAIGHT);
        d.addElement(edge);
        Object e1dada = e1.getHint(ElementHints.KEY_OBJECT);
        Object e2dada = e2.getHint(ElementHints.KEY_OBJECT);
        if (e1dada != null && e2dada != null) {
            edge.setHint(ElementHints.KEY_OBJECT, String.valueOf(e1dada) + " to " + String.valueOf(e2dada));
        }
        Topology topology = d.getDiagramClass().getSingleItem(Topology.class);
        topology.connect(edge, EdgeVisuals.EdgeEnd.Begin, e1, _t1);
        topology.connect(edge, EdgeVisuals.EdgeEnd.End, e2, _t2);
        return edge;
    }

    public static void validate(IDiagram d, ICanvasContext ctx) {
        ArrayList<Validator.Issue> issues = new ArrayList<Validator.Issue>();
        for (Validator v : d.getDiagramClass().getItemsByClass(Validator.class)) {
            v.validate(d, ctx, issues);
        }
        ArrayList<Validator.Suggestion> suggestions = new ArrayList<Validator.Suggestion>();
        for (Validator.Issue i : issues) {
            suggestions.clear();
            i.addSuggestions(d, ctx, suggestions);
            if (suggestions.size() == 0) continue;
            ((Validator.Suggestion)suggestions.get(0)).fix(d, ctx);
        }
    }
}

