/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.Font;
import java.util.Objects;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.TextFont;

public class TextFontImpl
implements TextFont,
LifeCycle {
    private static final long serialVersionUID = -6254972866736454459L;
    public static TextFontImpl DEFAULT = new TextFontImpl();
    Font defaultFont;

    public static synchronized TextFontImpl handlerOf(Font f) {
        return new TextFontImpl(f);
    }

    public TextFontImpl() {
        this.defaultFont = new Font("Arial", 0, 12);
    }

    public TextFontImpl(Font defaultFont) {
        this.defaultFont = defaultFont;
    }

    @Override
    public Font getFont(IElement e) {
        return (Font)e.getHint(ElementHints.KEY_FONT);
    }

    @Override
    public void setFont(IElement e, Font f) {
        e.setHint(ElementHints.KEY_FONT, f);
    }

    @Override
    public void onElementActivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementCreated(IElement e) {
        if (this.defaultFont != null) {
            e.setHint(ElementHints.KEY_FONT, this.defaultFont);
        }
    }

    @Override
    public void onElementDeactivated(IDiagram d, IElement e) {
    }

    @Override
    public void onElementDestroyed(IElement e) {
    }

    public int hashCode() {
        return Objects.hashCode(this.defaultFont);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextFontImpl other = (TextFontImpl)obj;
        return Objects.equals(this.defaultFont, other.defaultFont);
    }
}

