/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant.pointertool;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.canvas.IContentContext;
import org.simantics.g2d.canvas.IToolMode;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.connection.IConnectionAdvisor;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.diagram.participant.pointertool.BoxSelectionMode;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.diagram.participant.pointertool.TranslateMode;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.elementclass.RouteGraphConnectionClass;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.utils.CanvasUtils;
import org.simantics.g2d.utils.GeometryUtils;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.color.ColorFilter;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.KeyEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.BoxSelectionStrategy;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.utils.datastructures.context.IContext;
import org.simantics.utils.datastructures.context.IContextListener;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;

public class PointerInteractor
extends AbstractDiagramParticipant {
    public static final IHintContext.Key KEY_PICK_DISTANCE = new IHintContext.KeyOf(Double.class, "PICK_DISTANCE");
    public static final IHintContext.Key KEY_TERMINAL_PICK_DISTANCE = new IHintContext.KeyOf(Double.class, "TERMINAL_PICK_DISTANCE");
    public static final double PICK_DIST = 5.0;
    public static final double TERMINAL_PICK_DIST = 15.0;
    protected int lastStateMask;
    protected boolean temporarilyEnabledConnectTool = false;
    private ColorFilter hoverColorFilter;
    @DependencyReflection.Dependency
    Selection selection;
    @DependencyReflection.Dependency
    KeyUtil keys;
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    PickContext pickContext;
    @DependencyReflection.Dependency
    MouseUtil mice;
    @DependencyReflection.Reference
    TerminalPainter terminalPainter;
    public static final int TOOL_PRIORITY = 0x200000;
    public static final int BOX_SELECT_PRIORITY = 524288;
    private static final Path2D LINE10 = new Path2D.Double();
    private static final Path2D LINE15;
    private static final Path2D LINE20;
    boolean clickSelect;
    boolean boxSelect;
    boolean dragElement;
    boolean dndDragElement;
    boolean connect;
    boolean doubleClickEdit;
    protected IElementClassProvider elementClassProvider;
    PickRequest.PickPolicy boxSelectMode = PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS;
    BoxSelectionStrategy boxSelectionStrategy;
    DefaultHoverStrategy hoverStrategy;
    private PickRequest.PickSorter pickSorter;
    private IElement previousTarget = null;
    protected transient Point2D curCanvasDragPos = new Point2D.Double();
    protected transient Set<IElement> elementsToDrag = Collections.emptySet();

    static {
        LINE10.moveTo(0.0, 0.0);
        LINE10.lineTo(10.0, 0.0);
        LINE10.lineTo(7.0, -3.0);
        LINE10.moveTo(10.0, 0.0);
        LINE10.lineTo(7.0, 3.0);
        LINE15 = new Path2D.Double();
        LINE15.moveTo(0.0, 0.0);
        LINE15.lineTo(15.0, 0.0);
        LINE15.lineTo(12.0, -3.0);
        LINE15.moveTo(15.0, 0.0);
        LINE15.lineTo(12.0, 3.0);
        LINE20 = new Path2D.Double();
        LINE20.moveTo(0.0, 0.0);
        LINE20.lineTo(20.0, 0.0);
        LINE20.lineTo(17.0, -3.0);
        LINE20.moveTo(20.0, 0.0);
        LINE20.lineTo(17.0, 3.0);
    }

    public PointerInteractor() {
        this(true, true, true, false, true, false, ElementClassProviders.staticProvider(null), null);
    }

    public PointerInteractor(PickRequest.PickSorter pickSorter) {
        this(true, true, true, false, true, false, ElementClassProviders.staticProvider(null), pickSorter);
    }

    public PointerInteractor(boolean clickSelect, boolean boxSelect, boolean dragElement, boolean dndDragElement, boolean connect, IElementClassProvider ecp) {
        this(clickSelect, boxSelect, dragElement, dndDragElement, connect, false, ecp, null);
    }

    public PointerInteractor(boolean clickSelect, boolean boxSelect, boolean dragElement, boolean dndDragElement, boolean connect, boolean doubleClickEdit, IElementClassProvider ecp, PickRequest.PickSorter pickSorter) {
        this.clickSelect = clickSelect;
        this.boxSelect = boxSelect;
        this.dragElement = dragElement;
        this.dndDragElement = dndDragElement;
        this.connect = connect;
        this.doubleClickEdit = doubleClickEdit;
        this.elementClassProvider = ecp;
        this.pickSorter = pickSorter;
    }

    public void setHoverColorFilter(ColorFilter hoverColorFilter) {
        this.hoverColorFilter = hoverColorFilter;
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.hoverStrategy = new DefaultHoverStrategy((TerminalPainter.TerminalHoverStrategy)this.getHint(TerminalPainter.TERMINAL_HOVER_STRATEGY));
        this.setHint(TerminalPainter.TERMINAL_HOVER_STRATEGY, this.hoverStrategy);
        this.getContext().getSceneGraph().setGlobalProperty("pickDistance", (Object)this.getPickDistance());
        this.getHintStack().addKeyHintListener(KEY_PICK_DISTANCE, (IHintListener)new HintListenerAdapter(){

            public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                PointerInteractor.this.getContext().getSceneGraph().setGlobalProperty("pickDistance", (Object)PointerInteractor.this.getPickDistance());
            }
        });
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleStateMask(MouseEvent me) {
        this.lastStateMask = me.stateMask;
        if (this.temporarilyEnabledConnectTool) {
            if (!this.connectToolModifiersPressed(me.stateMask)) {
                this.temporarilyEnabledConnectTool = false;
                this.setHint(Hints.KEY_TOOL, Hints.POINTERTOOL);
            }
        } else if (this.getToolMode() == Hints.POINTERTOOL && this.connectToolModifiersPressed(me.stateMask)) {
            this.temporarilyEnabledConnectTool = true;
            this.setHint(Hints.KEY_TOOL, Hints.CONNECTTOOL);
        }
        return false;
    }

    private static int mask(int mask, int mask2, boolean set) {
        return set ? mask | mask2 : mask & ~mask2;
    }

    @EventHandlerReflection.EventHandler(priority=-1)
    public boolean altToggled(KeyEvent ke) {
        boolean altModifier;
        int mods = ke.stateMask;
        boolean press = ke instanceof KeyEvent.KeyPressedEvent;
        boolean modifierPressed = false;
        if (ke.keyCode == 18) {
            mods = PointerInteractor.mask(mods, 512, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 65406) {
            mods = PointerInteractor.mask(mods, 8192, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 16) {
            mods = PointerInteractor.mask(mods, 64, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 17) {
            mods = PointerInteractor.mask(mods, 128, press);
            modifierPressed = true;
        }
        if (ke.keyCode == 157) {
            modifierPressed = true;
        }
        boolean otherModifiers = (mods & 0x40) != 0;
        boolean bl = altModifier = (mods & 0x2200) != 0;
        if (modifierPressed) {
            boolean altPressed = !otherModifiers && altModifier;
            this.lastStateMask = mods;
            if (altPressed) {
                IToolMode mode = this.getToolMode();
                if (mode == Hints.POINTERTOOL) {
                    this.temporarilyEnabledConnectTool = true;
                    this.setHint(Hints.KEY_TOOL, Hints.CONNECTTOOL);
                }
            } else if (this.temporarilyEnabledConnectTool) {
                this.temporarilyEnabledConnectTool = false;
                this.setHint(Hints.KEY_TOOL, Hints.POINTERTOOL);
            }
            if (this.terminalPainter != null) {
                this.terminalPainter.update(this.terminalPainter.highlightEnabled());
            }
        }
        return false;
    }

    public Shape getCanvasPickShape(Point2D controlPos) {
        AffineTransform inverse = this.util.getInverseTransform();
        if (inverse == null) {
            return null;
        }
        double pd = this.getPickDistance();
        Rectangle2D.Double controlPickRect = new Rectangle2D.Double(controlPos.getX() - pd, controlPos.getY() - pd, pd * 2.0, pd * 2.0);
        Shape canvasShape = GeometryUtils.transformShape(controlPickRect, inverse);
        return canvasShape;
    }

    public Shape getTerminalCanvasPickShape(Point2D controlPos) {
        AffineTransform inverse = this.util.getInverseTransform();
        if (inverse == null) {
            return null;
        }
        double pd = this.getTerminalPickDistance();
        Rectangle2D.Double controlPickRect = new Rectangle2D.Double(controlPos.getX() - pd, controlPos.getY() - pd, pd * 2.0, pd * 2.0);
        Shape canvasShape = GeometryUtils.transformShape(controlPickRect, inverse);
        return canvasShape;
    }

    public List<TerminalUtil.TerminalInfo> pickTerminals(Point2D controlPos) {
        Shape canvasPickRect = this.getTerminalCanvasPickShape(controlPos);
        if (canvasPickRect == null) {
            return Collections.emptyList();
        }
        return TerminalUtil.pickTerminals(this.getContext(), this.diagram, canvasPickRect, true, true);
    }

    public TerminalUtil.TerminalInfo pickTerminal(Point2D controlPos) {
        Shape canvasPickRect = this.getTerminalCanvasPickShape(controlPos);
        if (canvasPickRect == null) {
            return null;
        }
        TerminalUtil.TerminalInfo ti = TerminalUtil.pickTerminal(this.getContext(), this.diagram, canvasPickRect);
        return ti;
    }

    @EventHandlerReflection.EventHandler(priority=0x200000)
    public boolean handlePress(MouseEvent.MouseButtonPressedEvent me) {
        if (!this.connects()) {
            return false;
        }
        if (me.button != 1) {
            return false;
        }
        IToolMode mode = this.getToolMode();
        if (mode == Hints.POINTERTOOL && this.connectToolModifiersPressed(me.stateMask)) {
            this.temporarilyEnabledConnectTool = true;
            mode = Hints.CONNECTTOOL;
            this.setHint(Hints.KEY_TOOL, Hints.CONNECTTOOL);
        }
        if (mode == Hints.CONNECTTOOL) {
            Point2D curCanvasPos = this.util.controlToCanvas(me.controlPosition, null);
            return this.checkInitiateConnectTool((MouseEvent)me, curCanvasPos);
        }
        return false;
    }

    protected boolean checkInitiateConnectTool(MouseEvent me, Point2D mouseCanvasPos) {
        IToolMode mode = this.getToolMode();
        if (mode == Hints.CONNECTTOOL || this.connectToolModifiersPressed(me.stateMask)) {
            IConnectionAdvisor advisor = (IConnectionAdvisor)this.diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
            TerminalUtil.TerminalInfo ti = this.pickTerminal(me.controlPosition);
            ICanvasParticipant bsi = null;
            if (ti != null) {
                if (advisor == null || advisor.canBeginConnection(null, ti.e, ti.t)) {
                    bsi = this.createConnectTool(ti, me.mouseId, mouseCanvasPos);
                }
            } else {
                ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
                if (snapAdvisor != null) {
                    snapAdvisor.snap(mouseCanvasPos);
                }
                bsi = this.createConnectTool(null, me.mouseId, mouseCanvasPos);
            }
            if (bsi != null) {
                this.startConnectTool(bsi);
                return true;
            }
        }
        return false;
    }

    protected void startConnectTool(ICanvasParticipant tool) {
        this.getContext().add(tool);
        if (this.temporarilyEnabledConnectTool) {
            this.getContext().addContextListener(new ToolModeResetter(tool));
        }
    }

    @EventHandlerReflection.EventHandler(priority=0x200000)
    public boolean handleMouseEvent(MouseEvent me) {
        this.assertDependencies();
        IElement currentTarget = null;
        Shape canvasPickRect = this.getCanvasPickShape(me.controlPosition);
        if (canvasPickRect == null) {
            return false;
        }
        PickRequest req = new PickRequest(canvasPickRect).context(this.getContext());
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        req.pickSorter = PickRequest.PickSorter.connectionSorter(this.pickSorter, req.pickArea.getBounds2D().getCenterX(), req.pickArea.getBounds2D().getCenterY());
        ArrayList<IElement> pickables = new ArrayList<IElement>();
        this.pickContext.pick(this.diagram, req, pickables);
        currentTarget = this.getEventTarget(me);
        if (currentTarget != this.previousTarget) {
            Node n;
            if (this.previousTarget != null) {
                MouseEvent.MouseExitEvent exit = new MouseEvent.MouseExitEvent((Object)this.getContext(), me.time, me.mouseId, me.buttons, me.stateMask, me.controlPosition, me.screenPosition);
                this.sendElementMouseEvent(this.previousTarget, (MouseEvent)exit);
                n = (Node)this.previousTarget.getHint(ElementHints.KEY_SG_NODE);
                if (n instanceof SingleElementNode) {
                    ((SingleElementNode)n).setHoverFilter(null);
                }
            }
            if (currentTarget != null) {
                MouseEvent.MouseEnterEvent enter = new MouseEvent.MouseEnterEvent((Object)this.getContext(), me.time, me.mouseId, me.buttons, me.stateMask, me.controlPosition, me.screenPosition);
                this.sendElementMouseEvent(currentTarget, (MouseEvent)enter);
                n = (Node)currentTarget.getHint(ElementHints.KEY_SG_NODE);
                if (n instanceof SingleElementNode) {
                    ((SingleElementNode)n).setHoverFilter(this.hoverColorFilter);
                }
            }
            this.previousTarget = currentTarget;
            ICanvasContext ctx = this.getContext();
            if (ctx == null) {
                return false;
            }
            IContentContext cctx = ctx.getContentContext();
            if (cctx == null) {
                return false;
            }
            cctx.setDirty();
        }
        return false;
    }

    private boolean sendElementMouseEvent(IElement e, MouseEvent me) {
        for (HandleMouseEvent eh : e.getElementClass().getItemsByClass(HandleMouseEvent.class)) {
            if (!eh.handleMouseEvent(e, this.getContext(), me)) continue;
            return true;
        }
        return false;
    }

    public IElement getEventTarget(MouseEvent me) {
        IElement selectedPick;
        if (!this.hasClickSelect()) {
            return null;
        }
        if (!this.hasToolMode(Hints.POINTERTOOL)) {
            return null;
        }
        boolean popupWasVisible = this.wasPopupJustClosed((Event)me);
        this.anyModifierPressed(me);
        boolean isShiftPressed = me.hasAllModifiers(64);
        boolean isCtrlPressed = me.hasAllModifiers(128);
        this.assertDependencies();
        Shape canvasPickRect = this.getCanvasPickShape(me.controlPosition);
        int selectionId = me.mouseId;
        PickRequest req = new PickRequest(canvasPickRect).context(this.getContext());
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        req.pickSorter = PickRequest.PickSorter.connectionSorter(this.pickSorter, req.pickArea.getBounds2D().getCenterX(), req.pickArea.getBounds2D().getCenterY());
        ArrayList<IElement> pickables = new ArrayList<IElement>();
        this.pickContext.pick(this.diagram, req, pickables);
        Set<IElement> currentSelection = this.selection.getSelection(selectionId);
        if (pickables.isEmpty()) {
            return null;
        }
        if (isCtrlPressed) {
            IElement removable = null;
            int i = pickables.size() - 1;
            while (i >= 0) {
                IElement pickable = (IElement)pickables.get(i);
                if (!this.selection.contains(selectionId, pickable)) {
                    removable = null;
                    break;
                }
                removable = pickable;
                if (!isShiftPressed) break;
                --i;
            }
            return removable;
        }
        if (popupWasVisible) {
            return null;
        }
        IElement iElement = selectedPick = isShiftPressed ? this.rotatingPick(currentSelection, pickables) : (IElement)pickables.get(pickables.size() - 1);
        if (!Collections.singleton(selectedPick).equals(currentSelection)) {
            return selectedPick;
        }
        return selectedPick;
    }

    @EventHandlerReflection.EventHandler(priority=0x200000)
    public boolean handleClick(MouseEvent.MouseClickEvent me) {
        IElement selectedPick;
        boolean isRight;
        if (this.hasDoubleClickEdit() && me.clickCount == 2 && this.handleDoubleClick(me)) {
            return true;
        }
        if (!this.hasClickSelect()) {
            return false;
        }
        if (!this.hasToolMode(Hints.POINTERTOOL)) {
            return false;
        }
        if (me.clickCount > 1) {
            return false;
        }
        boolean isLeft = me.button == 1;
        boolean bl = isRight = me.button == 2;
        if (!isLeft && !isRight) {
            return false;
        }
        boolean popupWasVisible = this.wasPopupJustClosed((Event)me);
        boolean noModifiers = !this.anyModifierPressed((MouseEvent)me);
        boolean isShiftPressed = me.hasAllModifiers(64);
        boolean isCtrlPressed = me.hasAllModifiers(128);
        this.assertDependencies();
        Shape canvasPickRect = this.getCanvasPickShape(me.controlPosition);
        int selectionId = me.mouseId;
        PickRequest req = new PickRequest(canvasPickRect).context(this.getContext());
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        req.pickSorter = PickRequest.PickSorter.connectionSorter(this.pickSorter, req.pickArea.getBounds2D().getCenterX(), req.pickArea.getBounds2D().getCenterY());
        ArrayList<IElement> pickables = new ArrayList<IElement>();
        this.pickContext.pick(this.diagram, req, pickables);
        Set<IElement> currentSelection = this.selection.getSelection(selectionId);
        if (pickables.isEmpty()) {
            if (!popupWasVisible && isLeft && !isShiftPressed && !isCtrlPressed) {
                this.selection.clear(selectionId);
            }
            if (isRight && noModifiers) {
                this.setHint(DiagramHints.SHOW_POPUP_MENU, me.controlPosition);
            }
            return false;
        }
        if (isCtrlPressed) {
            if (isLeft) {
                IElement removable = null;
                int i = pickables.size() - 1;
                while (i >= 0) {
                    IElement pickable = (IElement)pickables.get(i);
                    if (this.selection.add(selectionId, pickable)) {
                        removable = null;
                        break;
                    }
                    removable = pickable;
                    if (!isShiftPressed) break;
                    --i;
                }
                if (removable != null) {
                    this.selection.remove(selectionId, removable);
                }
            }
            return false;
        }
        boolean result = false;
        if (isLeft && popupWasVisible) {
            return false;
        }
        if (isRight && pickables.size() > 1) {
            IElement selectElement = this.singleElementAboveNonselectedConnections(currentSelection, pickables);
            if (selectElement != null) {
                this.selection.setSelection(selectionId, selectElement);
            }
            if (!currentSelection.isEmpty() && noModifiers) {
                this.setHint(DiagramHints.SHOW_POPUP_MENU, me.controlPosition);
            }
            return false;
        }
        IElement iElement = selectedPick = isShiftPressed ? this.rotatingPick(currentSelection, pickables) : (IElement)pickables.get(pickables.size() - 1);
        if (!Collections.singleton(selectedPick).equals(currentSelection) && (isLeft || isRight && !currentSelection.contains(selectedPick))) {
            this.selection.setSelection(selectionId, selectedPick);
            result = true;
        }
        if (isRight && pickables.size() == 1 && noModifiers) {
            this.setHint(DiagramHints.SHOW_POPUP_MENU, me.controlPosition);
        }
        return result;
    }

    private IElement singleElementAboveNonselectedConnections(Set<IElement> currentSelection, List<IElement> pickables) {
        boolean elementOnTop;
        if (pickables.isEmpty()) {
            return null;
        }
        if (!Collections.disjoint(currentSelection, pickables)) {
            return null;
        }
        IElement top = pickables.get(pickables.size() - 1);
        boolean bl = elementOnTop = !PickRequest.PickFilter.FILTER_CONNECTIONS.accept(top);
        if (!elementOnTop) {
            return null;
        }
        int i = pickables.size() - 2;
        while (i >= 0) {
            IElement e = pickables.get(i);
            if (!PickRequest.PickFilter.FILTER_CONNECTIONS.accept(e)) {
                return null;
            }
            --i;
        }
        return top;
    }

    private boolean wasPopupJustClosed(Event event) {
        long timeDiff;
        Long popupCloseTime = (Long)this.getHint(DiagramHints.POPUP_MENU_HIDDEN);
        return popupCloseTime != null && (timeDiff = event.time - popupCloseTime) < 300L;
    }

    boolean handleDoubleClick(MouseEvent.MouseClickEvent me) {
        if (!this.hasDoubleClickEdit()) {
            return false;
        }
        if (me.button != 1) {
            return false;
        }
        if (this.getToolMode() != Hints.POINTERTOOL) {
            return false;
        }
        if (me.clickCount < 2) {
            return false;
        }
        Shape canvasPickRect = this.getCanvasPickShape(me.controlPosition);
        int selectionId = me.mouseId;
        PickRequest req = new PickRequest(canvasPickRect).context(this.getContext());
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        req.pickSorter = PickRequest.PickSorter.connectionSorter(this.pickSorter, req.pickArea.getBounds2D().getCenterX(), req.pickArea.getBounds2D().getCenterY());
        ArrayList<IElement> pick = new ArrayList<IElement>();
        this.pickContext.pick(this.diagram, req, pick);
        if (pick.isEmpty()) {
            this.selection.clear(selectionId);
            return false;
        }
        IElement selectedPick = this.rotatingPick(selectionId, pick);
        if (!this.selection.contains(selectionId, selectedPick)) {
            this.selection.setSelection(selectionId, selectedPick);
        }
        CanvasUtils.sendCommand(this.getContext(), Commands.RENAME);
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0x200000)
    public boolean handleDrag(MouseEvent.MouseDragBegin me) {
        if (!this.hasElementDrag() && !this.hasBoxSelect()) {
            return false;
        }
        if (me.button != 1) {
            return false;
        }
        if (this.getToolMode() != Hints.POINTERTOOL) {
            return false;
        }
        if (this.hasToolMode(me.mouseId)) {
            return false;
        }
        boolean anyModifierPressed = me.hasAnyModifier(8896);
        boolean nonSelectionModifierPressed = me.hasAnyModifier(8832);
        if (nonSelectionModifierPressed) {
            return false;
        }
        this.assertDependencies();
        Point2D curCanvasPos = this.util.controlToCanvas(me.controlPosition, this.curCanvasDragPos);
        Shape canvasPickRect = this.getCanvasPickShape(me.controlPosition);
        PickRequest req = new PickRequest(canvasPickRect).context(this.getContext());
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        req.pickSorter = PickRequest.PickSorter.connectionSorter(this.pickSorter, req.pickArea.getBounds2D().getCenterX(), req.pickArea.getBounds2D().getCenterY());
        ArrayList<IElement> picks = new ArrayList<IElement>();
        this.pickContext.pick(this.diagram, req, picks);
        Set<IElement> sel = this.selection.getSelection(me.mouseId);
        IElement topMostPick = picks.isEmpty() ? null : (IElement)picks.get(picks.size() - 1);
        HashSet<IElement> elementsToDrag = new HashSet<IElement>();
        this.elementsToDrag = elementsToDrag;
        if (!Collections.disjoint(sel, picks)) {
            elementsToDrag.addAll(sel);
        } else if (topMostPick != null && (sel.isEmpty() || !sel.contains(topMostPick))) {
            this.selection.setSelection(me.mouseId, topMostPick);
            sel = this.selection.getSelection(me.mouseId);
            elementsToDrag.addAll(sel);
        }
        if (!(!elementsToDrag.isEmpty() && this.hasElementDnDDrag() || anyModifierPressed || elementsToDrag.isEmpty() || !this.hasElementDrag())) {
            boolean onlyConnections = PointerInteractor.onlyConnections(elementsToDrag);
            if (!onlyConnections) {
                ICanvasParticipant tm = this.createTranslateTool(me.mouseId, me.startCanvasPos, curCanvasPos, elementsToDrag);
                if (tm != null) {
                    this.getContext().add(tm);
                    return !onlyConnections;
                }
            } else {
                int i = picks.size() - 1;
                while (i >= 0) {
                    RouteGraphNode rgn = (RouteGraphNode)((IElement)picks.get(i)).getHint(RouteGraphConnectionClass.KEY_RG_NODE);
                    if (rgn != null) {
                        rgn.handleDrag(me);
                        break;
                    }
                    --i;
                }
            }
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=524288)
    public boolean handleBoxSelect(MouseEvent.MouseDragBegin me) {
        ICanvasParticipant bsm;
        if (!this.hasBoxSelect()) {
            return false;
        }
        if (me.button != 1) {
            return false;
        }
        if (this.getToolMode() != Hints.POINTERTOOL) {
            return false;
        }
        if (this.hasToolMode(me.mouseId)) {
            return false;
        }
        boolean nonSelectionModifierPressed = me.hasAnyModifier(8704);
        if (nonSelectionModifierPressed) {
            return false;
        }
        if (!nonSelectionModifierPressed && this.elementsToDrag.isEmpty() && (bsm = this.createBoxSelectTool(me.mouseId, me.startCanvasPos, this.curCanvasDragPos, me.button, this.boxSelectMode, this.boxSelectionStrategy)) != null) {
            this.getContext().add(bsm);
        }
        return false;
    }

    protected static boolean onlyConnections(Set<IElement> elements) {
        for (IElement e : elements) {
            if (e.getElementClass().containsClass(ConnectionHandler.class)) continue;
            return false;
        }
        return true;
    }

    private IElement rotatingPick(int selectionId, List<IElement> pickables) {
        Set<IElement> sel = this.selection.getSelection(selectionId);
        return this.rotatingPick(sel, pickables);
    }

    private IElement rotatingPick(Set<IElement> sel, List<IElement> pickables) {
        int earliestIndex = pickables.size();
        int i = pickables.size() - 1;
        while (i >= 0) {
            if (sel.contains(pickables.get(i))) {
                earliestIndex = i;
                break;
            }
            --i;
        }
        if (earliestIndex == 0) {
            earliestIndex = pickables.size();
        }
        IElement selectedPick = pickables.get(earliestIndex - 1);
        return selectedPick;
    }

    protected boolean hasToolMode(int mouseId) {
        for (AbstractMode am : this.getContext().getItemsByClass(AbstractMode.class)) {
            if (am.mouseId != mouseId) continue;
            return true;
        }
        return false;
    }

    protected boolean hasToolMode(IToolMode mode) {
        return Objects.equals(mode, this.getToolMode());
    }

    protected boolean hasToolMode(IToolMode ... modes) {
        IToolMode current = this.getToolMode();
        if (current == null) {
            return false;
        }
        IToolMode[] iToolModeArray = modes;
        int n = modes.length;
        int n2 = 0;
        while (n2 < n) {
            IToolMode mode = iToolModeArray[n2];
            if (current.equals(mode)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IToolMode getToolMode() {
        return (IToolMode)this.getHint(Hints.KEY_TOOL);
    }

    protected boolean hasBoxSelect() {
        return this.boxSelect;
    }

    protected boolean hasClickSelect() {
        return this.clickSelect;
    }

    protected boolean hasDoubleClickEdit() {
        return this.doubleClickEdit;
    }

    protected boolean hasElementDrag() {
        return this.dragElement;
    }

    protected boolean hasElementDnDDrag() {
        return this.dndDragElement;
    }

    protected boolean connects() {
        return this.connect;
    }

    public double getPickDistance() {
        Double pickDistance = (Double)this.getHint(KEY_PICK_DISTANCE);
        return pickDistance == null ? 5.0 : Math.max(pickDistance, 0.0);
    }

    public double getTerminalPickDistance() {
        Double pickDistance = (Double)this.getHint(KEY_TERMINAL_PICK_DISTANCE);
        return pickDistance == null ? 15.0 : Math.max(pickDistance, 0.0);
    }

    public PickRequest.PickPolicy getBoxSelectMode() {
        return this.boxSelectMode;
    }

    public void setBoxSelectMode(PickRequest.PickPolicy boxSelectMode) {
        this.boxSelectMode = boxSelectMode;
    }

    public BoxSelectionStrategy getBoxSelectionStrategy() {
        return this.boxSelectionStrategy;
    }

    public void setBoxSelectionStrategy(BoxSelectionStrategy strategy) {
        this.boxSelectionStrategy = strategy;
    }

    public void setSelectionEnabled(boolean select) {
        int[] ids;
        this.clickSelect = select;
        this.boxSelect = select;
        if (!select && (ids = this.selection.getSelectionIds()).length > 0) {
            ThreadUtils.asyncExec((IThreadWorkQueue)this.getContext().getThreadAccess(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    int[] nArray = ids;
                    int n = ids.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int id = nArray[n2];
                        PointerInteractor.this.selection.clear(id);
                        ++n2;
                    }
                    PointerInteractor.this.getContext().getContentContext().setDirty();
                }
            });
        }
    }

    boolean anyModifierPressed(MouseEvent e) {
        return e.hasAnyModifier(8896);
    }

    boolean connectToolModifiersPressed(int stateMask) {
        return (stateMask & 0x2200) != 0;
    }

    protected ICanvasParticipant createConnectTool(TerminalUtil.TerminalInfo ti, int mouseId, Point2D startCanvasPos) {
        return null;
    }

    protected ICanvasParticipant createConnectToolWithTerminals(List<TerminalUtil.TerminalInfo> tis, int mouseId, Point2D startCanvasPos) {
        return null;
    }

    protected ICanvasParticipant createTranslateTool(int mouseId, Point2D startCanvasPos, Point2D curCanvasPos, Set<IElement> elementsToDrag) {
        return new TranslateMode(startCanvasPos, curCanvasPos, mouseId, elementsToDrag);
    }

    protected ICanvasParticipant createBoxSelectTool(int mouseId, Point2D startCanvasPos, Point2D curCanvasPos, int button, PickRequest.PickPolicy boxSelectMode, BoxSelectionStrategy strategy) {
        return new BoxSelectionMode(startCanvasPos, curCanvasPos, mouseId, button, boxSelectMode, strategy);
    }

    public class DefaultHoverStrategy
    extends TerminalPainter.ChainedHoverStrategy {
        public DefaultHoverStrategy(TerminalPainter.TerminalHoverStrategy orig) {
            super(orig);
        }

        @Override
        public boolean highlightEnabled() {
            if (Hints.CONNECTTOOL.equals(PointerInteractor.this.getToolMode())) {
                return true;
            }
            boolean ct = PointerInteractor.this.connectToolModifiersPressed(PointerInteractor.this.lastStateMask);
            return ct;
        }

        @Override
        public boolean canHighlight(TerminalUtil.TerminalInfo ti) {
            IConnectionAdvisor advisor = (IConnectionAdvisor)PointerInteractor.this.diagram.getHint(DiagramHints.CONNECTION_ADVISOR);
            return advisor == null || advisor.canBeginConnection(null, ti.e, ti.t);
        }
    }

    protected class ToolModeResetter
    implements IContextListener<ICanvasParticipant> {
        private ICanvasParticipant tracked;

        public ToolModeResetter(ICanvasParticipant trackedParticipant) {
            this.tracked = trackedParticipant;
        }

        public void itemAdded(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
        }

        public void itemRemoved(IContext<ICanvasParticipant> sender, ICanvasParticipant item) {
            if (item == this.tracked) {
                sender.removeContextListener((IContextListener)this);
                if (!PointerInteractor.this.isRemoved() && !PointerInteractor.this.connectToolModifiersPressed(PointerInteractor.this.lastStateMask)) {
                    PointerInteractor.this.temporarilyEnabledConnectTool = false;
                    PointerInteractor.this.setHint(Hints.KEY_TOOL, Hints.POINTERTOOL);
                }
            }
        }
    }
}

