/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.participant.pointertool;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.HashSet;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.RenderingQualityInteractor;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.BoxSelectionNode;
import org.simantics.scenegraph.g2d.nodes.BoxSelectionStrategy;
import org.simantics.scenegraph.g2d.nodes.SelectionPolicy;
import org.simantics.scenegraph.utils.Quality;

public class BoxSelectionMode
extends AbstractMode {
    @DependencyReflection.Reference
    RenderingQualityInteractor quality;
    @DependencyReflection.Dependency
    TransformUtil util;
    @DependencyReflection.Dependency
    Selection selection;
    @DependencyReflection.Dependency
    PickContext pickContext;
    @DependencyReflection.Dependency
    KeyUtil keyUtil;
    public static final BasicStroke STROKE = new BasicStroke(1.0f);
    public static final int PAINT_PRIORITY = 30;
    Point2D startingPoint;
    Point2D currentPoint;
    int mouseButton;
    PickRequest.PickPolicy boxSelectMode;
    BoxSelectionNode node;
    BoxSelectionStrategy boxSelectStrategy;

    private static PickRequest.PickPolicy convert(SelectionPolicy p, PickRequest.PickPolicy defaultValue) {
        if (p == null) {
            return defaultValue;
        }
        switch (p) {
            case SELECT_INTERSECTING: {
                return PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
            }
        }
        return PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS;
    }

    protected PickRequest.PickPolicy choosePickPolicy(PickRequest.PickPolicy defaultValue) {
        PickRequest.PickPolicy p = this.boxSelectMode;
        if (this.boxSelectStrategy != null) {
            p = BoxSelectionMode.convert(this.boxSelectStrategy.chooseSelectionPolicy(this.node.getStart(), this.node.getEnd()), this.boxSelectMode);
        }
        return p != null ? p : defaultValue;
    }

    @SGNodeReflection.SGInit
    public void init(G2DParentNode parent) {
        if (this.quality != null) {
            this.quality.setStaticQuality(Quality.LOW);
        }
        this.node = (BoxSelectionNode)parent.getOrCreateNode("" + this.hashCode(), BoxSelectionNode.class);
        this.node.setZIndex(30);
        this.node.setStart(this.startingPoint);
        this.node.setEnd(this.currentPoint);
        this.node.setStroke((Stroke)STROKE);
        this.node.setScaleStroke(true);
        this.node.setColor(this.getToolColor());
        this.node.setStrategy(this.boxSelectStrategy);
        this.node.setMouseButton(this.mouseButton);
        this.node.setSelectionListener(new BoxSelectionNode.SelectionListener(){

            public void onSelect(Rectangle2D rect, int modifiers) {
                if (BoxSelectionMode.this.isRemoved()) {
                    return;
                }
                boolean toggle = (modifiers & 0x80) != 0;
                boolean accumulate = (modifiers & 0x40) != 0;
                HashSet<IElement> boxSelection = new HashSet<IElement>();
                PickRequest request = new PickRequest(rect).context(BoxSelectionMode.this.getContext());
                request.pickPolicy = BoxSelectionMode.this.choosePickPolicy(request.pickPolicy);
                request.intersectionPolicy = PickRequest.IntersectionMode.BOUNDS;
                BoxSelectionMode.this.pickContext.pick(BoxSelectionMode.this.diagram, request, boxSelection);
                int selectionId = BoxSelectionMode.this.mouseId;
                if (toggle) {
                    BoxSelectionMode.this.selection.toggle(selectionId, boxSelection);
                } else if (accumulate) {
                    for (IElement elem : boxSelection) {
                        BoxSelectionMode.this.selection.add(selectionId, elem);
                    }
                } else {
                    BoxSelectionMode.this.selection.setSelection(selectionId, boxSelection);
                }
                if (BoxSelectionMode.this.node != null) {
                    BoxSelectionMode.this.node.remove();
                    BoxSelectionMode.this.node = null;
                }
                BoxSelectionMode.this.setDirty();
                BoxSelectionMode.this.remove();
            }
        });
    }

    @SGNodeReflection.SGCleanup
    public void cleanup() {
        if (this.quality != null) {
            this.quality.setStaticQuality(null);
        }
        if (this.node != null) {
            this.node.remove();
            this.node = null;
        }
    }

    public BoxSelectionMode(Point2D startingPoint, Point2D currentPoint, int mouseId, int mouseButton, PickRequest.PickPolicy boxSelectMode) {
        super(mouseId);
        this.startingPoint = startingPoint;
        this.currentPoint = currentPoint;
        this.mouseButton = mouseButton;
        this.boxSelectMode = boxSelectMode;
    }

    public BoxSelectionMode(Point2D startingPoint, Point2D currentPoint, int mouseId, int mouseButton, PickRequest.PickPolicy boxSelectMode, BoxSelectionStrategy boxSelectStrategy) {
        this(startingPoint, currentPoint, mouseId, mouseButton, boxSelectMode);
        this.boxSelectStrategy = boxSelectStrategy;
    }

    public synchronized Color getToolColor() {
        Color c = (Color)this.getHint(DiagramHints.KEY_SELECTION_FRAME_COLOR);
        if (c != null) {
            return c;
        }
        return Color.BLACK;
    }

    @EventHandlerReflection.EventHandler(priority=100)
    public boolean handleCancel(CommandEvent e) {
        if (e.command.equals((Object)Commands.CANCEL)) {
            this.setDirty();
            this.remove();
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleEvent(Event e) {
        return this.node.handleEvent(e) || e instanceof CommandEvent && this.handleCancel((CommandEvent)e) || !(e instanceof MouseEvent.MouseWheelMovedEvent);
    }
}

