/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HasDiagramSourceListener
extends DisposableListener<Resource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HasDiagramSourceListener.class);
    private DataContainer<IDiagram> diagramContainer;

    public HasDiagramSourceListener(DataContainer<IDiagram> diagramContainer) {
        this.diagramContainer = diagramContainer;
    }

    public void execute(Resource source) {
        IDiagram d;
        DataContainer<IDiagram> c = this.diagramContainer;
        IDiagram iDiagram = d = c != null ? (IDiagram)this.diagramContainer.get() : null;
        if (d != null) {
            ElementUtils.setOrRemoveHint((IHintContext)d, (IHintContext.Key)DiagramModelHints.KEY_HAS_DIAGRAM_SOURCE, (Object)source);
        }
    }

    public void exception(Throwable t) {
        LOGGER.error("Received unexpected exception", t);
    }

    public void dispose() {
        super.dispose();
        this.diagramContainer = null;
    }
}

