/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.componentTypeEditor;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.db.layer0.request.ActiveRuns;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.modeling.ComponentTypeScriptRequest;
import org.simantics.modeling.ComponentTypeScriptResult;
import org.simantics.modeling.ui.componentTypeEditor.ComponentTypeScriptEditor;
import org.simantics.scl.compiler.errors.CompilationError;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.ui.editor2.SCLCodeHighlighting;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;
import org.simantics.ui.workbench.ResourceEditorInput;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.strings.EString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentTypeScriptDocumentProvider
extends AbstractDocumentProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComponentTypeScriptDocumentProvider.class);
    protected ComponentTypeScriptEditor editor;
    protected Resource resource;
    protected String currentText;
    protected boolean immutable;
    protected boolean errorHappened;
    protected AnnotationModel annotationModel = new AnnotationModel();
    protected boolean annotationsInitialized = false;

    public ComponentTypeScriptDocumentProvider(ComponentTypeScriptEditor editor) {
        this.editor = editor;
    }

    protected IDocument createDocument(Object element) throws CoreException {
        ResourceEditorInput input = (ResourceEditorInput)element;
        this.resource = input.getResource();
        try {
            Document doc = (Document)Simantics.getSession().syncRequest((Read)new UniqueRead<Document>(){

                public Document perform(ReadGraph graph) throws DatabaseException {
                    StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                    ComponentTypeScriptDocumentProvider.this.currentText = (String)graph.getRelatedValue(ComponentTypeScriptDocumentProvider.this.resource, STR.ComponentTypeScript_code, (Binding)Bindings.STRING);
                    Resource owner = graph.getPossibleObject(ComponentTypeScriptDocumentProvider.this.resource, STR.ComponentType_hasScript_Inverse);
                    ComponentTypeScriptDocumentProvider.this.immutable = Layer0Utils.isMarkedReadOnly((ReadGraph)graph, (Resource)ComponentTypeScriptDocumentProvider.this.resource) || owner != null && StructuralUtils.isImmutable((ReadGraph)graph, (Resource)owner);
                    ComponentTypeScriptDocumentProvider.this.errorHappened = false;
                    return new Document(ComponentTypeScriptDocumentProvider.this.currentText != null ? ComponentTypeScriptDocumentProvider.this.currentText : "");
                }
            });
            SCLCodeHighlighting.connectPartitioner((IDocument)doc);
            return doc;
        }
        catch (DatabaseException e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.errorHappened = true;
            return new Document(sw.toString());
        }
    }

    protected void updateAnnotations() {
        Simantics.getSession().asyncRequest((Read)new Read<ComponentTypeScriptResult>(){

            public ComponentTypeScriptResult perform(ReadGraph graph) throws DatabaseException {
                StructuralResource2 str = StructuralResource2.getInstance((ReadGraph)graph);
                Resource componentType = graph.getSingleObject(ComponentTypeScriptDocumentProvider.this.resource, str.ComponentType_hasScript_Inverse);
                Object activeExperiments = graph.syncRequest((Read)ActiveExperimentIdentifiersRequest.INSTANCE);
                ComponentTypeScriptResult result = (ComponentTypeScriptResult)graph.syncRequest((Read)new ComponentTypeScriptRequest(ComponentTypeScriptDocumentProvider.this.resource, componentType, activeExperiments));
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateAnnotations request.perform:\n\tactive experiments: {}\r\terrors: {}", activeExperiments, (Object)result.getErrors());
                }
                return result;
            }
        }, (Listener)new Listener<ComponentTypeScriptResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(ComponentTypeScriptResult result) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("updateAnnotations listener.execute: errors:\n\t{}", (Object)EString.implode((Collection)result.getErrors(), (String)"\n\t"));
                }
                Object object = ComponentTypeScriptDocumentProvider.this.annotationModel.getLockObject();
                synchronized (object) {
                    ComponentTypeScriptDocumentProvider.this.annotationModel.removeAllAnnotations();
                    for (CompilationError error : result.getErrors()) {
                        Annotation annotation = new Annotation("org.eclipse.ui.workbench.texteditor.error", true, error.description);
                        int begin = Locations.beginOf((long)error.location);
                        int end = Locations.endOf((long)error.location);
                        Position position = new Position(begin, end - begin);
                        ComponentTypeScriptDocumentProvider.this.annotationModel.addAnnotation(annotation, position);
                    }
                }
            }

            public void exception(Throwable t) {
                LOGGER.error("Failed to update component type script annotations for input resource {}", (Object)ComponentTypeScriptDocumentProvider.this.resource, (Object)t);
            }

            public boolean isDisposed() {
                return ComponentTypeScriptDocumentProvider.this.editor.isDisposed();
            }
        });
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"doSaveDocument");
        this.currentText = document.get();
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                graph.markUndoPoint();
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                graph.claimLiteral(ComponentTypeScriptDocumentProvider.this.resource, STR.ComponentTypeScript_code, (Object)ComponentTypeScriptDocumentProvider.this.currentText, (Binding)Bindings.STRING);
            }
        });
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        if (!this.annotationsInitialized) {
            this.updateAnnotations();
            this.annotationsInitialized = true;
        }
        return this.annotationModel;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    public boolean isModifiable(Object element) {
        return !this.errorHappened && !this.immutable;
    }

    public boolean isReadOnly(Object element) {
        return this.errorHappened || this.immutable;
    }

    private static class ActiveExperimentIdentifiersRequest
    extends UniqueRead<Set<String>> {
        private static final ActiveExperimentIdentifiersRequest INSTANCE = new ActiveExperimentIdentifiersRequest();

        private ActiveExperimentIdentifiersRequest() {
        }

        public Set<String> perform(ReadGraph graph) throws DatabaseException {
            IExperimentManager em = (IExperimentManager)Simantics.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
            Set activeExperimentIds = Arrays.stream(em.getExperiments()).map(IExperiment::getIdentifier).collect(Collectors.toSet());
            for (Resource root : (Collection)graph.syncRequest((Read)new ActiveModels(Simantics.getProjectResource()))) {
                graph.syncRequest((Read)new ActiveRuns(root));
            }
            return activeExperimentIds.isEmpty() ? Collections.emptySet() : activeExperimentIds;
        }
    }
}

