/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.chart.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.NameLabelUtil;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.Combo;
import org.simantics.browsing.ui.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.Scale;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.charts.ontology.ChartResource;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.chart.property.AvailableTemplateFactory;
import org.simantics.modeling.ui.chart.property.BooleanPropertyFactory;
import org.simantics.modeling.ui.chart.property.CurrentTemplateFactory;
import org.simantics.modeling.ui.chart.property.DelayedIntegerToDoublePropertyModifier;
import org.simantics.modeling.ui.chart.property.DoublePropertyFactory;
import org.simantics.modeling.ui.chart.property.DoublePropertyModifier;
import org.simantics.modeling.ui.chart.property.DoubleToIntegerPropertyFactory;
import org.simantics.modeling.ui.chart.property.Messages;
import org.simantics.modeling.ui.chart.property.TemplateModifier;
import org.simantics.modeling.ui.chart.property.TimeInputValidator;
import org.simantics.modeling.ui.chart.property.TimePropertyFactory;
import org.simantics.modeling.ui.chart.property.TimePropertyModifier;
import org.simantics.selectionview.ConfigurationComposite;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ISelectionUtils;

public class ChartComposite
extends ConfigurationComposite {
    public static final TimeInputValidator LENGTH_VALIDATOR = new TimeInputValidator(1.0);
    public static final TimeInputValidator START_VALIDATOR = new TimeInputValidator(-1.7976931348623157E308);

    public static Read<String> getPartTitleRequest(final ISelection selection) {
        return new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                Resource r = ResourceAdaptionUtils.toSingleResource((Object)selection);
                if (r == null) {
                    return "Selection";
                }
                return NameLabelUtil.modalName((ReadGraph)graph, (Resource)r);
            }
        };
    }

    public Read<String> getPartNameReadRequest(ISelection forSelection) {
        return ChartComposite.getPartTitleRequest(forSelection);
    }

    public void create(Composite body, IWorkbenchSite site, ISessionContext context, final WidgetSupport support) {
        Display display = body.getDisplay();
        body.setBackground(display.getSystemColor(1));
        Label autoscrollLabel = new Label(body, support, 0);
        autoscrollLabel.setText(Messages.ChartComposite_AutoScrollSettings);
        autoscrollLabel.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo(autoscrollLabel.getControl());
        Composite templateComposite = new Composite(body, 0);
        templateComposite.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)templateComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(3).extendedMargins(5, 5, 5, 5).applyTo(templateComposite);
        Label templateHeader = new Label(templateComposite, support, 0);
        templateHeader.setText(Messages.ChartComposite_Template);
        templateHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)templateHeader.getWidget());
        Combo templateCombo = new Combo(templateComposite, support, 8);
        templateCombo.setItemFactory((ReadFactory)new AvailableTemplateFactory());
        templateCombo.setSelectionFactory((ReadFactory)new CurrentTemplateFactory());
        templateCombo.addModifyListener((ModifyListener)new TemplateModifier());
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)templateCombo.getWidget());
        Button resetButton = new Button(templateComposite, support, 8);
        resetButton.setText(Messages.ChartComposite_Apply);
        resetButton.addSelectionListener((SelectionListener)new SelectionListenerImpl<Resource>(context){

            public void apply(WriteGraph graph, Resource monitor) throws DatabaseException {
                graph.markUndoPoint();
                ChartResource CHART = ChartResource.getInstance((ReadGraph)graph);
                if (graph.hasStatement(monitor, CHART.Chart_TimeWindowStart)) {
                    graph.deny(monitor, CHART.Chart_TimeWindowStart);
                }
                if (graph.hasStatement(monitor, CHART.Chart_TimeWindowLength)) {
                    graph.deny(monitor, CHART.Chart_TimeWindowLength);
                }
                if (graph.hasStatement(monitor, CHART.Chart_TimeWindowIncrement)) {
                    graph.deny(monitor, CHART.Chart_TimeWindowIncrement);
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).applyTo((Control)resetButton.getWidget());
        Composite buttonComposite = new Composite(body, 0);
        buttonComposite.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)buttonComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(4).extendedMargins(5, 5, 5, 5).applyTo(buttonComposite);
        Label startHeader = new Label(buttonComposite, support, 0);
        startHeader.setText(Messages.ChartComposite_StartTime);
        startHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)startHeader.getWidget());
        TrackedText timeWindowStart = new TrackedText(buttonComposite, support, 0x800800);
        timeWindowStart.getWidget().setToolTipText(Messages.ChartComposite_ChartWindowTT);
        timeWindowStart.setTextFactory((ReadFactory)new TimePropertyFactory("http://www.simantics.org/Charts-1.2/Chart/TimeWindowStart"));
        timeWindowStart.addModifyListener((TextModifyListener)new TimePropertyModifier(context, "http://www.simantics.org/Charts-1.2/Chart/TimeWindowStart", START_VALIDATOR));
        timeWindowStart.setInputValidator((IInputValidator)START_VALIDATOR);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)timeWindowStart.getWidget());
        Label sizeHeader = new Label(buttonComposite, support, 0);
        sizeHeader.setText(Messages.ChartComposite_Length);
        sizeHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)sizeHeader.getWidget());
        TrackedText timeWindowLength = new TrackedText(buttonComposite, support, 0x800800);
        timeWindowLength.getWidget().setToolTipText(Messages.ChartComposite_ChartWindowTT2);
        timeWindowLength.setTextFactory((ReadFactory)new TimePropertyFactory("http://www.simantics.org/Charts-1.2/Chart/TimeWindowLength"));
        timeWindowLength.addModifyListener((TextModifyListener)new TimePropertyModifier(context, "http://www.simantics.org/Charts-1.2/Chart/TimeWindowLength", LENGTH_VALIDATOR));
        timeWindowLength.setInputValidator((IInputValidator)LENGTH_VALIDATOR);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)timeWindowLength.getWidget());
        Label incrementHeader = new Label(buttonComposite, support, 0);
        incrementHeader.setText(Messages.ChartComposite_ScrollIncrement);
        incrementHeader.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(false, false).span(1, 1).align(16384, 0x1000000).applyTo((Control)incrementHeader.getWidget());
        Scale timeWindowIncrement = new Scale(buttonComposite, support, 8);
        timeWindowIncrement.getWidget().setMinimum(1);
        timeWindowIncrement.getWidget().setMaximum(100);
        timeWindowIncrement.getWidget().setIncrement(10);
        timeWindowIncrement.getWidget().setPageIncrement(10);
        timeWindowIncrement.setBackground(display.getSystemColor(1));
        timeWindowIncrement.setSelectionFactory((ReadFactory)new DoubleToIntegerPropertyFactory("http://www.simantics.org/Charts-1.2/Chart/TimeWindowIncrement"));
        timeWindowIncrement.addSelectionListener((SelectionListener)new DelayedIntegerToDoublePropertyModifier(timeWindowIncrement, context, "http://www.simantics.org/Charts-1.2/Chart/TimeWindowIncrement"));
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)timeWindowIncrement.getWidget());
        TrackedText timeWindowIncrementText = new TrackedText(buttonComposite, support, 0x800800);
        timeWindowIncrementText.setTextFactory((ReadFactory)new DoublePropertyFactory("http://www.simantics.org/Charts-1.2/Chart/TimeWindowIncrement"));
        timeWindowIncrementText.addModifyListener((TextModifyListener)new DoublePropertyModifier(context, "http://www.simantics.org/Charts-1.2/Chart/TimeWindowIncrement"));
        timeWindowIncrementText.setInputValidator(new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().isEmpty()) {
                    return null;
                }
                try {
                    Double d = Double.parseDouble(newText);
                    if (d < 1.0 || d > 100.0) {
                        return Messages.ChartComposite_ScrollIncrementRange;
                    }
                    return null;
                }
                catch (NumberFormatException e) {
                    return e.getMessage();
                }
            }
        });
        GridDataFactory.fillDefaults().grab(false, false).align(16384, 0x1000000).span(1, 1).applyTo((Control)timeWindowIncrementText.getWidget());
        Label l3 = new Label(buttonComposite, support, 0);
        l3.setBackground(display.getSystemColor(1));
        l3.setText("%");
        Composite checkboxComposite = new Composite(buttonComposite, 0);
        checkboxComposite.setBackground(display.getSystemColor(1));
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)checkboxComposite);
        GridLayoutFactory.fillDefaults().equalWidth(false).numColumns(2).applyTo(checkboxComposite);
        final Button showMilestones = new Button(checkboxComposite, support, 32);
        showMilestones.setBackground(display.getSystemColor(1));
        showMilestones.setText(Messages.ChartComposite_ShowMileStones);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)showMilestones.getWidget());
        showMilestones.setSelectionFactory((ReadFactory)new BooleanPropertyFactory("http://www.simantics.org/Charts-1.2/Chart/ShowMilestones"));
        showMilestones.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final Resource r = (Resource)ISelectionUtils.filterSingleSelection((Object)support.getInput(), Resource.class);
                    if (r == null) {
                        return;
                    }
                    final Boolean show = showMilestones.getWidget().getSelection();
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            graph.claimLiteral(r, ChartResource.getInstance((ReadGraph)graph).Chart_ShowMilestones, (Object)show, (Binding)Bindings.BOOLEAN);
                        }
                    });
                }
                catch (DatabaseException e1) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", Messages.ChartComposite_ActivatorFailedToSetShowMilestones, (Throwable)e1));
                }
            }
        });
        final Button trackExperimentTime = new Button(checkboxComposite, support, 32);
        trackExperimentTime.setBackground(display.getSystemColor(1));
        trackExperimentTime.setText(Messages.ChartComposite_HairlineAndTracksExperimentTime);
        trackExperimentTime.setTooltipText(Messages.ChartComposite_HairlineAndTracksExperimentTimeTT);
        GridDataFactory.fillDefaults().grab(true, false).span(1, 1).applyTo((Control)trackExperimentTime.getWidget());
        trackExperimentTime.setSelectionFactory((ReadFactory)new BooleanPropertyFactory("http://www.simantics.org/Charts-1.2/Chart/trackExperimentTime"));
        trackExperimentTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    final Resource r = (Resource)ISelectionUtils.filterSingleSelection((Object)support.getInput(), Resource.class);
                    if (r == null) {
                        return;
                    }
                    final Boolean track = trackExperimentTime.getWidget().getSelection();
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            graph.markUndoPoint();
                            graph.claimLiteral(r, ChartResource.getInstance((ReadGraph)graph).Chart_trackExperimentTime, (Object)track, (Binding)Bindings.BOOLEAN);
                        }
                    });
                }
                catch (DatabaseException e1) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", Messages.ChartComposite_ActivatorFailedTrackExperimentTime, (Throwable)e1));
                }
            }
        });
    }
}

