/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graphfile.hack;

import java.net.URI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.simantics.graphfile.hack.GraphFile;
import org.simantics.graphfile.hack.GraphFileEditorInputFactory;

public class GraphFileEditorInput
extends PlatformObject
implements IFileEditorInput,
IPathEditorInput,
IURIEditorInput,
IPersistableElement {
    private GraphFile file;

    public GraphFileEditorInput(GraphFile file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IFileEditorInput)) {
            return false;
        }
        IFileEditorInput other = (IFileEditorInput)obj;
        return this.file.equals(other.getFile());
    }

    public boolean exists() {
        return this.file.exists();
    }

    public String getFactoryId() {
        return GraphFileEditorInputFactory.getFactoryId();
    }

    public IFile getFile() {
        return this.file;
    }

    public ImageDescriptor getImageDescriptor() {
        IContentType contentType = IDE.getContentType((IFile)this.file);
        return PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(this.file.getName(), contentType);
    }

    public String getName() {
        return this.file.getName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public IStorage getStorage() {
        return this.file;
    }

    public String getToolTipText() {
        return this.file.getFullPath().makeRelative().toString();
    }

    public void saveState(IMemento memento) {
        GraphFileEditorInputFactory.saveState(memento, this);
    }

    public URI getURI() {
        return this.file.getLocationURI();
    }

    public IPath getPath() {
        IPath location = this.file.getLocation();
        if (location != null) {
            return location;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + "(" + String.valueOf(this.getFile().getFullPath()) + ")";
    }

    public Object getAdapter(Class adapter) {
        if (IWorkbenchAdapter.class.equals((Object)adapter)) {
            return new IWorkbenchAdapter(){

                public Object[] getChildren(Object o) {
                    return new Object[0];
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return GraphFileEditorInput.this.getImageDescriptor();
                }

                public String getLabel(Object o) {
                    return GraphFileEditorInput.this.getName();
                }

                public Object getParent(Object o) {
                    return GraphFileEditorInput.this.getFile().getParent();
                }
            };
        }
        return super.getAdapter(adapter);
    }
}

