/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import java.util.ArrayList;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ClusterTraitsSmall;
import org.simantics.db.procore.cluster.CompleteTable;
import org.simantics.db.procore.cluster.GetStatementsSmall;
import org.simantics.db.procore.cluster.ObjectTable;
import org.simantics.db.procore.cluster.OutOfSpaceException;
import org.simantics.db.procore.cluster.PredicateTable;
import org.simantics.db.procore.cluster.ResourceElementSmall;
import org.simantics.db.procore.cluster.Statement;
import org.simantics.db.procore.cluster.ToBigStatements;
import org.simantics.db.procore.cluster.ValueTableSmall;

public final class ResourceTableSmall
extends Table<long[]> {
    static final int RESOURCE_COUNT_INDEX = 0;
    static final int FOREIGN_COUNT_INDEX = 1;
    static final int CLUSTER_STATUS_INDEX = 2;

    public ResourceTableSmall(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase);
    }

    public ResourceTableSmall(TableSizeListener sizeListener, int[] header, int headerBase, long[] longs) {
        super(TableFactory.getLongFactory(), sizeListener, header, headerBase, (Object)longs);
    }

    public int getUsedSize() {
        return this.getTableCount();
    }

    public short createResource() {
        int INDEX = this.getTableCount();
        int SIZE = ResourceElementSmall.getSizeOf();
        int resourceIndex = this.createNewElement(SIZE);
        assert (resourceIndex != 0);
        int REAL_INDEX = this.checkIndexAndGetRealIndex(resourceIndex, SIZE);
        ResourceElementSmall.construct((long[])this.getTable(), REAL_INDEX);
        this.incResourceCount();
        return (short)(INDEX + 1);
    }

    void createResource(int resourceIndex) {
        int tableCount = this.getTableCount();
        if (resourceIndex <= tableCount) {
            int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
            if (ResourceElementSmall.isEmpty((long[])this.getTable(), realIndex)) {
                return;
            }
        }
        if (resourceIndex == tableCount + 1) {
            this.createResource();
            return;
        }
        throw new InternalError("Trying to create resource with illegal index=" + resourceIndex);
    }

    public short getCompleteObjectRef(int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.getCompleteObjectRef((long[])this.getTable(), realIndex);
    }

    public ClusterI.CompleteTypeEnum getCompleteType(int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.getCompleteType((long[])this.getTable(), realIndex);
    }

    public int getPredicateIndex(int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.getPredicateIndex((long[])this.table, realIndex);
    }

    public void setPredicateIndex(int resourceIndex, int predicateIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElementSmall.setPredicateIndex((long[])this.getTable(), realIndex, predicateIndex);
    }

    public byte[] getValue(ValueTableSmall valueTable, int resourceIndex) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.getValue(valueTable, (long[])this.getTable(), realIndex);
    }

    public boolean hasValue(int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.hasValue((long[])this.getTable(), realIndex);
    }

    public boolean removeValue(ValueTableSmall valueTable, int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        boolean ret = ResourceElementSmall.removeValue(valueTable, (long[])this.getTable(), realIndex);
        return ret;
    }

    public void setValue(ValueTableSmall valueTable, int resourceIndex, byte[] value, int length) throws OutOfSpaceException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElementSmall.setValue(valueTable, (long[])this.getTable(), realIndex, value, length);
    }

    public boolean isValueEx(ValueTableSmall valueTable, int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.isValueEx(valueTable, (long[])this.getTable(), realIndex);
    }

    public void setValueEx(ValueTableSmall valueTable, int resourceIndex) {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElementSmall.setValueEx(valueTable, (long[])this.getTable(), realIndex);
    }

    int incResourceCount() {
        int count = this.getExtra(0) + 1;
        this.setExtra(0, count);
        return count;
    }

    public int getResourceCount() {
        return this.getExtra(0);
    }

    public int getClusterStatus() {
        return this.getExtra(2);
    }

    public void setClusterStatus(int value) {
        this.setExtra(2, value);
    }

    <Context> boolean foreachResource(ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        int tsize = this.getTableSize();
        int esize = ResourceElementSmall.getSizeOf();
        int key = 1;
        int i = this.getTableBase();
        while (i < this.getTableBase() + tsize) {
            int ref;
            if (ResourceElementSmall.isUsed((long[])this.getTable(), i) && procedure.execute(context, ref = modifier == null ? key : modifier.execute(key))) {
                return true;
            }
            i += esize;
            ++key;
        }
        return false;
    }

    public <Context> boolean foreachPredicate(int resourceIndex, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.foreachPredicate((long[])this.getTable(), realIndex, procedure, context, support, modifier, ct);
    }

    public int getSingleObject(int resourceIndex, ClusterSupport support, short pRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct, Modifier modifier) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.getSingleObject((long[])this.table, realIndex, support, pRef, completeType, ct, modifier);
    }

    public void foreachObject(int resourceIndex, ReadGraphImpl graph, SyncMultiProcedure<Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct, Modifier modifier) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElementSmall.foreachObject((long[])this.table, realIndex, graph, procedure, support, pRef, completeType, ct, modifier);
    }

    public <C> void foreachObject(int resourceIndex, ReadGraphImpl graph, C context, SyncContextMultiProcedure<C, Resource> procedure, ClusterSupport support, int pRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct, Modifier modifier) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        ResourceElementSmall.foreachObject((long[])this.table, realIndex, graph, context, procedure, support, pRef, completeType, ct, modifier);
    }

    public <Context> boolean foreachObject(int resourceIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier, short pRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.foreachObject((long[])this.table, realIndex, procedure, context, support, modifier, pRef, completeType, ct);
    }

    public int addStatement(int resourceIndex, short pRef, short oRef, PredicateTable pt, ObjectTable ot, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        return ResourceElementSmall.addStatement((long[])this.getTable(), realIndex, pRef, oRef, pt, ot, completeType, ct);
    }

    public boolean removeStatementFromCache(int resourceIndex, short pRef, short oRef, ClusterI.CompleteTypeEnum completeType, CompleteTable ct) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        boolean ret = ResourceElementSmall.removeStatement((long[])this.getTable(), realIndex, pRef, oRef, completeType, ct);
        return ret;
    }

    public void removeStatement(int resourceIndex, short pRef, short oRef, ClusterI.CompleteTypeEnum pCompleteType, CompleteTable ct, PredicateTable pt, ObjectTable ot, ClusterSupport support) throws DatabaseException {
        int realIndex = this.checkIndexAndGetRealIndex(resourceIndex);
        boolean removed = ResourceElementSmall.removeStatement((long[])this.getTable(), realIndex, pRef, oRef, pCompleteType, ct);
        if (!removed) {
            return;
        }
        int predicateIndex = ResourceElementSmall.getPredicateIndex((long[])this.getTable(), realIndex);
        if (predicateIndex == 0) {
            return;
        }
        if (ClusterI.CompleteTypeEnum.NotComplete != pCompleteType) {
            return;
        }
        GetStatementsSmall gs = new GetStatementsSmall(ot);
        pt.foreachPredicate(predicateIndex, gs, null, null, null);
        ArrayList<Statement> stms = gs.getStatements();
        int SIZE = stms.size();
        if (SIZE < 3) {
            int i = 0;
            while (i < SIZE) {
                Statement stm = stms.get(i);
                PredicateTable.Status ret = pt.removePredicate(predicateIndex, stm.pRef, stm.oIndex, ot);
                if (ret == PredicateTable.Status.NothingRemoved) {
                    throw new DatabaseException("Internal error during statement cache fix (2).");
                }
                assert (stm.pRef < 65536);
                assert (stm.oIndex < 65536);
                int pi = ResourceElementSmall.addStatement((long[])this.getTable(), realIndex, (short)stm.pRef, (short)stm.oIndex, pt, ot, ClusterI.CompleteTypeEnum.NotComplete, ct);
                assert (pi <= 0);
                ++i;
            }
            assert (pt.getPredicateSetSize(predicateIndex) == 0);
        } else {
            int i = 0;
            while (i < SIZE) {
                Statement stm = stms.get(i);
                assert (stm.pRef < 65536);
                assert (stm.oIndex < 65536);
                int pIndex = ResourceElementSmall.addStatement((long[])this.getTable(), realIndex, (short)stm.pRef, (short)stm.oIndex, pt, ot, ClusterI.CompleteTypeEnum.NotComplete, ct);
                if (pIndex > 0) {
                    return;
                }
                ++i;
            }
            throw new DatabaseException("Internal error during statement cache fix (3).");
        }
        ResourceElementSmall.setPredicateIndex((long[])this.getTable(), realIndex, 0);
    }

    private int checkIndexAndGetRealIndex(int resourceIndex) {
        if (ClusterTraitsBase.isIllegalResourceIndex((int)resourceIndex)) {
            throw new RuntimeException("Illegal resource index. index=" + resourceIndex + ".");
        }
        if (resourceIndex > this.getTableCount()) {
            throw new RuntimeException("Illegal resource index. index=" + resourceIndex + " table count=" + this.getTableCount());
        }
        int SIZE = ResourceElementSmall.getSizeOf();
        int REAL_INDEX = resourceIndex * SIZE - (SIZE - 1) + this.offset;
        return REAL_INDEX;
    }

    void check(ClusterImpl cluster) throws DatabaseException {
    }

    public void toBig(ClusterBase big, ClusterSupport support, ClusterBase small) throws DatabaseException {
        int resourceIndex = 1;
        long[] table = (long[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int TABLE_SIZE = this.getTableSize();
        int pe = ps + TABLE_SIZE;
        int p = ps;
        while (p < pe) {
            big.createResource(support);
            int subjectKey = ClusterTraits.createResourceKey((int)small.clusterKey, (int)resourceIndex);
            if (ResourceElementSmall.isUsed(table, p)) {
                int pi;
                short cr = ResourceElementSmall.getCompleteObjectRef(table, p);
                if (cr != 0) {
                    ClusterI.CompleteTypeEnum ct = ResourceElementSmall.getCompleteType(table, p);
                    if (ClusterI.CompleteTypeEnum.NotComplete != ct) {
                        int pKey = ClusterTraitsBase.getCompleteTypeResourceKeyFromEnum((ClusterI.CompleteTypeEnum)ct);
                        int oKey = small.getCompleteObjectKey(subjectKey, support);
                        big.addRelation(subjectKey, pKey, oKey, support);
                    } else {
                        final class ForeachObject<Context>
                        implements ClusterI.ObjectProcedure<Context> {
                            int sKey;
                            ClusterBase big;
                            private final /* synthetic */ ClusterBase val$small;
                            private final /* synthetic */ ClusterSupport val$support;

                            public ForeachObject(int sKey, ClusterBase big, ClusterBase clusterBase, ClusterSupport clusterSupport) {
                                this.val$small = clusterBase;
                                this.val$support = clusterSupport;
                                this.sKey = sKey;
                                this.big = big;
                            }

                            public boolean execute(Context context, int completeRef) throws DatabaseException {
                                ClusterI.CompleteTypeEnum ct = ClusterTraitsSmall.completeRefAndTypeGetType(completeRef);
                                int p = ClusterTraitsBase.getCompleteTypeResourceKeyFromEnum((ClusterI.CompleteTypeEnum)ct);
                                int o = this.val$small.execute(completeRef & 0xFFFF);
                                this.big.addRelation(this.sKey, p, o, this.val$support);
                                return false;
                            }
                        }
                        ForeachObject op = new ForeachObject(subjectKey, big, small, support);
                        small.getCompleteTable().foreach(cr & 0xFFFF, op, null, support, null);
                    }
                }
                if ((pi = ResourceElementSmall.getPredicateIndex(table, p)) != 0) {
                    ToBigStatements tbs = new ToBigStatements(small, big, support, subjectKey);
                    small.getPredicateTable().foreach(pi, (ClusterI.Procedure)tbs, null, null, null);
                } else {
                    short p1 = ResourceElementSmall.getStm1Predicate(table, p);
                    short o1 = ResourceElementSmall.getStm1Object(table, p);
                    if (p1 != 0) {
                        int pk1 = small.execute((int)p1);
                        int ok1 = small.execute((int)o1);
                        big.addRelation(subjectKey, pk1, ok1, support);
                        short p2 = ResourceElementSmall.getStm2Predicate(table, p);
                        short o2 = ResourceElementSmall.getStm2Object(table, p);
                        if (p2 != 0) {
                            int pk2 = small.execute((int)p2);
                            int ok2 = small.execute((int)o2);
                            big.addRelation(subjectKey, pk2, ok2, support);
                        }
                    }
                }
                int valueIndex = ResourceElementSmall.getValueIndex(table, p);
                if (0x3FFFFF == valueIndex) {
                    big.setValueEx(subjectKey);
                } else {
                    byte[] value = ResourceElementSmall.getValue((ValueTableSmall)small.getValueTable(), table, p);
                    if (value != null) {
                        big.setValue(subjectKey, value, value.length, support);
                    }
                }
            }
            p += ResourceElementSmall.getSizeOf();
            ++resourceIndex;
        }
    }

    public <Context> boolean foreach(int setIndex, ClusterI.Procedure procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        throw new UnsupportedOperationException();
    }
}

