/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.ProCoreSessionReference;
import fi.vtt.simantics.procore.internal.ListenerList;
import fi.vtt.simantics.procore.internal.SessionImplDb;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.Database;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.SessionErrorHandler;
import org.simantics.db.SessionManager;
import org.simantics.db.SessionReference;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.event.SessionEvent;
import org.simantics.db.event.SessionListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.server.DatabaseManager;
import org.simantics.db.service.LifecycleSupport;

class SessionManagerImpl
implements SessionManager {
    private ConcurrentHashMap<SessionImplSocket, SessionImplSocket> sessionMap = new ConcurrentHashMap();
    private ListenerList<SessionListener> sessionListeners = new ListenerList<SessionListener>(SessionListener.class);
    private SessionErrorHandler errorHandler;
    private Database database;

    SessionManagerImpl() throws IOException {
    }

    void finish() {
        this.sessionMap = null;
        this.sessionListeners = null;
    }

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public Session createSession(SessionReference sessionReference, UserAuthenticationAgent authAgent) throws DatabaseException, IOException {
        if (!(sessionReference instanceof ProCoreSessionReference)) {
            throw new DatabaseException("Illegal argument. ProCoreSessionReference needed for creation of corresponding session. ref=" + String.valueOf(sessionReference));
        }
        SessionImplDb sessionImpl = new SessionImplDb(this, authAgent);
        boolean ok = false;
        try {
            try {
                ProCoreSessionReference pcsr = (ProCoreSessionReference)sessionReference;
                Path dbFolder = pcsr.serverReference.dbFolder;
                this.database = DatabaseManager.getDatabase((Path)dbFolder);
                Database.Session dbSession = this.database.newSession((ServiceLocator)sessionImpl);
                sessionImpl.connect(sessionReference, dbSession);
                this.sessionMap.put(sessionImpl, sessionImpl);
                this.fireSessionOpened(sessionImpl);
                ok = true;
            }
            catch (IOException e) {
                sessionImpl = null;
                throw e;
            }
            catch (Throwable e) {
                Logger.defaultLogError((String)"Connection failed. See exception for details.", (Throwable)e);
                try {
                    this.fireSessionClosed(sessionImpl, e);
                    this.sessionMap.remove(sessionImpl);
                    sessionImpl = null;
                }
                catch (Throwable throwable) {}
                throw new DatabaseException(e);
            }
        }
        finally {
            if (!ok && sessionImpl != null) {
                sessionImpl.getService(LifecycleSupport.class).close();
            }
        }
        return sessionImpl;
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    private void fireSessionOpened(SessionImplSocket session) {
        SessionEvent se = new SessionEvent((Session)session, null);
        SessionListener[] sessionListenerArray = this.sessionListeners.getListeners();
        int n = sessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionListener listener = sessionListenerArray[n2];
            listener.sessionOpened(se);
            ++n2;
        }
    }

    private void fireSessionClosed(SessionImplSocket session, Throwable cause) {
        SessionEvent se = new SessionEvent((Session)session, cause);
        SessionListener[] sessionListenerArray = this.sessionListeners.getListeners();
        int n = sessionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            SessionListener listener = sessionListenerArray[n2];
            listener.sessionClosed(se);
            ++n2;
        }
    }

    public void shutdown(Session s, Throwable cause) {
        SessionImplSocket sis = this.sessionMap.get(s);
        if (sis == null) {
            return;
        }
        try {
            this.fireSessionClosed(sis, cause);
        }
        finally {
            this.sessionMap.remove(s);
        }
    }

    public SessionErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(SessionErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Database getDatabase() {
        return this.database;
    }
}

