/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import gnu.trove.map.hash.THashMap;
import java.util.Map;
import org.simantics.db.Disposable;
import org.simantics.db.ServiceLocator;
import org.simantics.db.exception.ServiceNotFoundException;

public class ServiceLocatorImpl
implements ServiceLocator {
    private final ServiceLocator parent;
    private Map<Class<?>, Object> services = null;

    public ServiceLocatorImpl() {
        this(null);
    }

    public ServiceLocatorImpl(ServiceLocator parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Map<Class<?>, Object> s = null;
        ServiceLocatorImpl serviceLocatorImpl = this;
        synchronized (serviceLocatorImpl) {
            s = this.services;
            this.services = null;
        }
        if (s != null) {
            for (Object object : s.values()) {
                if (!(object instanceof Disposable)) continue;
                Disposable service = (Disposable)object;
                service.dispose();
            }
            s.clear();
        }
    }

    public final <T> T getService(Class<T> key) {
        T t = this.peekService(key);
        if (t == null) {
            throw new ServiceNotFoundException((ServiceLocator)this, key);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T peekService(Class<T> key) {
        Object service;
        ServiceLocatorImpl serviceLocatorImpl = this;
        synchronized (serviceLocatorImpl) {
            service = this.services != null ? this.services.get(key) : null;
        }
        if (service == null) {
            if (this.parent != null) {
                return (T)this.parent.getService(key);
            }
            return null;
        }
        Object t = null;
        try {
            t = service;
        }
        catch (ClassCastException classCastException) {}
        return (T)t;
    }

    public final boolean hasService(Class<?> key) {
        return this.services != null && this.services.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> void registerService(Class<T> api, T service) {
        if (api == null) {
            throw new NullPointerException("The service key cannot be null");
        }
        ServiceLocatorImpl serviceLocatorImpl = this;
        synchronized (serviceLocatorImpl) {
            Object currentService;
            if (this.services == null) {
                this.services = new THashMap();
            }
            if ((currentService = this.services.remove(api)) instanceof Disposable) {
                Disposable disposable = (Disposable)currentService;
                disposable.dispose();
            }
            if (service == null) {
                if (this.services.isEmpty()) {
                    this.services = null;
                }
            } else {
                this.services.put(api, service);
            }
        }
    }
}

