/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.db.impl.internal.RandomAccessValueSupport;
import org.simantics.db.impl.internal.ResourceData;
import org.simantics.utils.datastructures.Pair;

public class RandomAccessValueSupportImpl
implements RandomAccessValueSupport {
    private static final boolean DEBUG = false;
    private Map<Resource, ResourceData> values = new HashMap<Resource, ResourceData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceData get(Resource resource) {
        RandomAccessValueSupportImpl randomAccessValueSupportImpl = this;
        synchronized (randomAccessValueSupportImpl) {
            return this.values.get(resource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Resource resource, ResourceData data) {
        RandomAccessValueSupportImpl randomAccessValueSupportImpl = this;
        synchronized (randomAccessValueSupportImpl) {
            ResourceData current = this.values.get(resource);
            if (current != null) {
                throw new IllegalStateException("Value already registered for resource " + String.valueOf(resource) + ": " + String.valueOf(current) + ". Tried to register " + String.valueOf(data));
            }
            this.values.put(resource, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<Resource, ResourceData>> entries() {
        RandomAccessValueSupportImpl randomAccessValueSupportImpl = this;
        synchronized (randomAccessValueSupportImpl) {
            if (this.values.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Pair<Resource, ResourceData>> result = new ArrayList<Pair<Resource, ResourceData>>(this.values.size());
            for (Map.Entry<Resource, ResourceData> entry : this.values.entrySet()) {
                result.add((Pair<Resource, ResourceData>)Pair.make((Object)entry.getKey(), (Object)entry.getValue()));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Pair<Resource, ResourceData>> removeAll() {
        RandomAccessValueSupportImpl randomAccessValueSupportImpl = this;
        synchronized (randomAccessValueSupportImpl) {
            if (this.values.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<Pair<Resource, ResourceData>> result = new ArrayList<Pair<Resource, ResourceData>>(this.values.size());
            for (Map.Entry<Resource, ResourceData> entry : this.values.entrySet()) {
                result.add((Pair<Resource, ResourceData>)Pair.make((Object)entry.getKey(), (Object)entry.getValue()));
            }
            this.values.clear();
            return result;
        }
    }
}

