/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.GraphSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.impl.TreeMapBinding;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.ChangeSetIdentifier;
import org.simantics.db.Operation;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;

final class ChangeSetIdentifierImpl
implements ChangeSetIdentifier {
    private final long id;
    private final GraphSession graphSession;
    private Map<String, byte[]> metadata;
    static Serializer METADATA_SERIALIZER = Bindings.getSerializerUnchecked((Binding)new TreeMapBinding((Binding)Bindings.STRING, (Binding)Bindings.BYTE_ARRAY));

    ChangeSetIdentifierImpl(long id, GraphSession graphSession) {
        this.id = id;
        this.graphSession = graphSession;
        this.metadata = null;
    }

    public final long getId() {
        return this.id;
    }

    public final void setMetadata(Map<String, byte[]> metadata) {
        this.metadata = metadata;
    }

    public final byte[] getContext() throws DatabaseException {
        if (this.graphSession == null) {
            return new byte[0];
        }
        return this.graphSession.getChangeSetContext(this.id);
    }

    public Map<String, byte[]> getMetadata() {
        try {
            byte[] data;
            if (this.metadata == null && (data = this.getContext()) != null && data.length > 0) {
                this.metadata = (TreeMap)METADATA_SERIALIZER.deserialize(data);
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            e.printStackTrace();
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
            e.printStackTrace();
        }
        return this.metadata;
    }

    static long[] changeSetIds2ints(Collection<ChangeSetIdentifier> changeSetIds) {
        if (changeSetIds == null) {
            return new long[0];
        }
        long[] t = new long[changeSetIds.size()];
        int i = -1;
        for (ChangeSetIdentifier id : changeSetIds) {
            t[++i] = ((ChangeSetIdentifierImpl)id).getId();
        }
        return t;
    }

    static long[] operations2ints(Collection<Operation> ops) {
        if (ops == null) {
            return new long[0];
        }
        long[] t = new long[ops.size()];
        int i = -1;
        for (Operation o : ops) {
            t[++i] = o.getCSId();
        }
        return t;
    }

    static Collection<ChangeSetIdentifier> longs2changeSetIds(GraphSession gs, long firstChangeSetIds, int count) {
        ArrayList<ChangeSetIdentifier> t = new ArrayList<ChangeSetIdentifier>();
        t.ensureCapacity(count);
        int i = 0;
        while (i < count) {
            t.add(new ChangeSetIdentifierImpl(firstChangeSetIds + (long)i, gs));
            ++i;
        }
        return t;
    }

    static Collection<ChangeSetIdentifier> longs2changeSetIds(GraphSession gs, long min, long max) {
        ArrayList<ChangeSetIdentifier> t = new ArrayList<ChangeSetIdentifier>();
        if (max < min) {
            return t;
        }
        long length = max - min + 1L;
        t.ensureCapacity((int)length);
        int i = 0;
        while ((long)i < length) {
            t.add(new ChangeSetIdentifierImpl(min + (long)i, gs));
            ++i;
        }
        return t;
    }
}

