/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.wiki.ui;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.AsyncRead;
import org.simantics.layer0.Layer0;
import org.simantics.wiki.ui.MarkupTransform;

public class SimanticsDialect
implements MarkupTransform {
    public static final SimanticsDialect INSTANCE = new SimanticsDialect();
    private final MarkupTransform[] transforms = new MarkupTransform[]{new TrendTransform(), new DiagramTransform(), new TimestampTransform(), new VariableTransform(), new IncludeTransform()};

    @Override
    public String apply(ReadGraph graph, Variable variable, String markup) throws DatabaseException {
        MarkupTransform[] markupTransformArray = this.transforms;
        int n = this.transforms.length;
        int n2 = 0;
        while (n2 < n) {
            MarkupTransform t = markupTransformArray[n2];
            markup = t.apply(graph, variable, markup);
            ++n2;
        }
        return markup;
    }

    class DiagramTransform
    implements MarkupTransform {
        final Pattern startPattern = Pattern.compile("\\{diagram(?::([^\\}]+))?\\}");

        DiagramTransform() {
        }

        @Override
        public String apply(ReadGraph graph, Variable variable, String markup) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.startPattern.matcher(markup);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                String options = matcher.group(1);
                HashMap<String, String> params = new HashMap<String, String>();
                if (options != null) {
                    String[] optionPairs;
                    String[] stringArray = optionPairs = options.split("\\s*\\|\\s*");
                    int n = optionPairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String optionPair = stringArray[n2];
                        String[] keyValue = optionPair.split("\\s*=\\s*");
                        if (keyValue.length == 2) {
                            String key = keyValue[0].trim();
                            String value = keyValue[1].trim();
                            params.put(key, value);
                        }
                        ++n2;
                    }
                }
                String data = "resource=" + (String)params.get("resource");
                if (params.containsKey("layer")) {
                    data = data + "|layer=" + (String)params.get("layer");
                }
                sb.append("<p style=\"height:768\"><object classid=\"org.simantics.wiki.ui.objects.DiagramRenderer\" data=\"" + data + "\" width=\"1024\" height=\"768\"/></p>");
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }

    class IncludeTransform
    implements MarkupTransform {
        final Pattern startPattern = Pattern.compile("\\{include(?::([^\\}]+))?\\}");

        IncludeTransform() {
        }

        @Override
        public String apply(ReadGraph graph, Variable variable, String markup) throws DatabaseException {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.startPattern.matcher(markup);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                String uri = matcher.group(1);
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                Resource resource = (Resource)graph.syncRequest((AsyncRead)new org.simantics.db.common.primitiverequest.Resource(uri));
                String desc = (String)graph.getPossibleRelatedValue(resource, L0.HasDescription);
                sb.append(desc);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }

    public static class TimestampTransform
    implements MarkupTransform {
        final Pattern startPattern = Pattern.compile("\\{timestamp(?::([^\\}]+))?\\}");

        @Override
        public String apply(ReadGraph graph, Variable variable, String markup) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.startPattern.matcher(markup);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                String options = matcher.group(1);
                SimpleDateFormat df = null;
                df = options != null ? new SimpleDateFormat(options) : new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
                sb.append(df.format(new Date()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }

    class TrendTransform
    implements MarkupTransform {
        final Pattern startPattern = Pattern.compile("\\{trend(?::([^\\}]+))?\\}");

        TrendTransform() {
        }

        @Override
        public String apply(ReadGraph graph, Variable variable, String markup) {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.startPattern.matcher(markup);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                String options = matcher.group(1);
                HashMap<String, String> params = new HashMap<String, String>();
                if (options != null) {
                    String[] optionPairs;
                    String[] stringArray = optionPairs = options.split("\\s*\\|\\s*");
                    int n = optionPairs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String optionPair = stringArray[n2];
                        String[] keyValue = optionPair.split("\\s*=\\s*");
                        if (keyValue.length == 2) {
                            String key = keyValue[0].trim();
                            String value = keyValue[1].trim();
                            params.put(key, value);
                        }
                        ++n2;
                    }
                }
                int width = 300;
                int height = 200;
                String title = "Trend";
                if (params.containsKey("width")) {
                    width = Integer.parseInt((String)params.get("width"));
                }
                if (params.containsKey("height")) {
                    height = Integer.parseInt((String)params.get("height"));
                }
                if (params.containsKey("title")) {
                    title = (String)params.get("title");
                }
                sb.append("<object classid=\"org.simantics.wiki.ui.objects.TrendRenderer\" title=\"" + title + "\" data=\"" + (String)params.get("data") + "\" width=\"" + width + "\" height=\"" + height + "\"/>");
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }

    class VariableTransform
    implements MarkupTransform {
        final Pattern startPattern = Pattern.compile("\\{variable(?::([^\\}]+))?\\}");

        VariableTransform() {
        }

        @Override
        public String apply(ReadGraph graph, Variable variable, String markup) throws DatabaseException {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = this.startPattern.matcher(markup);
            while (matcher.find()) {
                matcher.appendReplacement(sb, "");
                String rvi = matcher.group(1);
                Object value = variable.browse(graph, rvi).getValue(graph);
                sb.append(value.toString());
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
    }
}

