/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import java.util.concurrent.ConcurrentHashMap;
import org.simantics.utils.datastructures.disposable.AbstractDisposable;

public class ContextLocal<T>
extends AbstractDisposable {
    protected ConcurrentHashMap<Object, T> reg = new ConcurrentHashMap();
    Disposer<T> disposer;

    public ContextLocal() {
    }

    public ContextLocal(Disposer<T> disposer) {
        this.disposer = disposer;
    }

    public T get(Object context) {
        return this.reg.get(context);
    }

    public void replace(Object context, T value) {
        T old;
        T t = old = value != null ? this.reg.put(context, value) : this.reg.remove(context);
        if (old != null && this.disposer != null) {
            this.disposer.dispose(old);
        }
    }

    public void remove(Object context) {
        this.replace(context, null);
    }

    @Override
    protected void doDispose() {
        if (this.disposer != null) {
            for (T lr : this.reg.values()) {
                this.disposer.dispose(lr);
            }
        }
        this.reg.clear();
    }

    public static interface Disposer<T> {
        public void dispose(T var1);
    }
}

