/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import gnu.trove.map.hash.THashMap;
import java.awt.geom.Rectangle2D;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.segments.Segment;

public class RouteLine
implements RouteNode,
Serializable {
    private static final long serialVersionUID = -7256429294500809465L;
    Object data;
    boolean isHorizontal;
    double position;
    boolean hidden;
    ArrayList<RoutePoint> points = new ArrayList(4);
    RouteLine nextTransient;
    RouteTerminal terminal;

    public RouteLine(boolean isHorizontal, double position) {
        this.isHorizontal = isHorizontal;
        this.position = position;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    @Override
    public Object getData() {
        return this.data;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public double getPosition() {
        return this.position;
    }

    public List<RoutePoint> getPoints() {
        return this.points;
    }

    public void addPoint(RoutePoint link) {
        this.points.add(link);
    }

    void remove() {
        for (RoutePoint point : this.points) {
            point.removeFromOther(this);
        }
    }

    public void setPointPositions() {
        if (this.isHorizontal) {
            for (RoutePoint point : this.points) {
                point.y = this.position;
            }
        } else {
            for (RoutePoint point : this.points) {
                point.x = this.position;
            }
        }
    }

    public void sortPoints() {
        Collections.sort(this.points, this.isHorizontal ? RoutePoint.X_COMPARATOR : RoutePoint.Y_COMPARATOR);
    }

    public boolean intersects(Rectangle2D r) {
        RoutePoint first = this.points.get(0);
        RoutePoint last = this.points.get(this.points.size() - 1);
        return this.isHorizontal ? r.intersectsLine(first.x, this.position, last.x, this.position) : r.intersectsLine(this.position, first.y, this.position, last.y);
    }

    public boolean isNear(double x2, double y2, double tolerance) {
        return this.isHorizontal ? Math.abs(y2 - this.position) <= tolerance && this.points.get((int)0).x - tolerance <= x2 && x2 <= this.points.get((int)(this.points.size() - 1)).x + tolerance : Math.abs(x2 - this.position) <= tolerance && this.points.get((int)0).y - tolerance <= y2 && y2 <= this.points.get((int)(this.points.size() - 1)).y + tolerance;
    }

    public void print(PrintStream out) {
        if (this.isHorizontal) {
            out.print("    HOR");
        } else {
            out.print("    VER");
        }
        if (this.hidden) {
            out.print(" HIDDEN");
        }
        out.print(" @ " + this.position);
        for (RoutePoint point : this.points) {
            out.print(" (" + point.x + "," + point.y + ")");
        }
        out.print(" (data=" + String.valueOf(this.data) + ")");
        if (this.nextTransient != null) {
            out.print(" (next transient line=" + String.valueOf(this.nextTransient.getData()) + ")");
        }
        if (this.terminal != null) {
            out.print(" (terminal=" + String.valueOf(this.terminal.getData()) + ")");
        }
        out.println();
    }

    public void setLocation(double x, double y) {
        this.position = this.isHorizontal ? y : x;
    }

    public double getLength() {
        if (this.isHorizontal) {
            return this.points.get((int)(this.points.size() - 1)).x - this.points.get((int)0).x;
        }
        return this.points.get((int)(this.points.size() - 1)).y - this.points.get((int)0).y;
    }

    /*
     * WARNING - void declaration
     */
    boolean isConnectedToPeristentLine() {
        for (RoutePoint point : this.points) {
            void link;
            RoutePoint routePoint = point;
            if (!(routePoint instanceof RouteLink)) continue;
            RouteLink cfr_ignored_0 = (RouteLink)routePoint;
            RouteLink cfr_ignored_1 = (RouteLink)routePoint;
            if (!(link.a == this ? !link.b.isTransient() : !link.a.isTransient())) continue;
            return true;
        }
        return false;
    }

    public RoutePoint getBegin() {
        return this.points.get(0);
    }

    public RoutePoint getEnd() {
        return this.points.get(this.points.size() - 1);
    }

    public boolean isTransient() {
        return this.terminal != null;
    }

    public RouteLine copy(THashMap<Object, Object> map) {
        RouteLine copy = (RouteLine)map.get((Object)this);
        if (copy == null) {
            copy = new RouteLine(this.isHorizontal, this.position);
            map.put((Object)this, (Object)copy);
            copy.data = this.data;
            copy.nextTransient = this.nextTransient == null ? null : this.nextTransient.copy(map);
            copy.terminal = this.terminal == null ? null : this.terminal.copy((THashMap)map);
            for (RoutePoint point : this.points) {
                copy.points.add(point.copy(map));
            }
        }
        return copy;
    }

    /*
     * WARNING - void declaration
     */
    public Collection<RouteLine> getPersistentNeighbors() {
        ArrayList<RouteLine> lines = new ArrayList<RouteLine>();
        for (RoutePoint point : this.points) {
            void link;
            RoutePoint routePoint = point;
            if (!(routePoint instanceof RouteLink)) continue;
            RouteLink cfr_ignored_0 = (RouteLink)routePoint;
            RouteLink cfr_ignored_1 = (RouteLink)routePoint;
            RouteLine line = link.getOther(this);
            if (line.isTransient()) continue;
            lines.add(line);
        }
        return lines;
    }

    public void removeRouteTerminals() {
        this.points.removeIf(p -> p instanceof RouteTerminal);
    }

    public RouteTerminal getTerminal() {
        return this.terminal;
    }

    public void setTerminal(RouteTerminal terminal) {
        this.terminal = terminal;
    }

    public RouteLine getNextTransient() {
        return this.nextTransient;
    }

    /*
     * WARNING - void declaration
     */
    public boolean beginsWithTerminal() {
        RoutePoint begin = this.points.get(0);
        if (begin == this.terminal) {
            return true;
        }
        RoutePoint routePoint = begin;
        if (routePoint instanceof RouteLink) {
            void link;
            RouteLink routeLink = (RouteLink)routePoint;
            RouteLink cfr_ignored_0 = (RouteLink)routePoint;
            if (link.a == this) {
                return link.b.hasTerminal((RouteLink)link, this.terminal);
            }
            return link.a.hasTerminal((RouteLink)link, this.terminal);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasTerminal(RouteLink oldLink, RouteTerminal terminal) {
        RoutePoint routePoint;
        RoutePoint begin = this.points.get(0);
        RoutePoint end = this.points.get(1);
        if (begin == terminal || end == terminal) {
            return true;
        }
        RoutePoint routePoint2 = begin;
        if (routePoint2 instanceof RouteLink) {
            RouteLink routeLink = (RouteLink)routePoint2;
            RouteLink cfr_ignored_0 = (RouteLink)routePoint2;
            if (begin != oldLink) {
                void link;
                if (link.a == this) {
                    return link.b.hasTerminal((RouteLink)link, terminal);
                }
                return link.a.hasTerminal((RouteLink)link, terminal);
            }
        }
        if ((routePoint = end) instanceof RouteLink) {
            RouteLink routeLink = (RouteLink)routePoint;
            RouteLink cfr_ignored_1 = (RouteLink)routePoint;
            if (end != oldLink) {
                void link;
                if (link.a == this) {
                    return link.b.hasTerminal((RouteLink)link, terminal);
                }
                return link.a.hasTerminal((RouteLink)link, terminal);
            }
        }
        return false;
    }

    public boolean isDegenerated() {
        if (this.points.size() <= 1) {
            return true;
        }
        if (this.isHorizontal) {
            return this.points.get((int)0).x == this.points.get((int)(this.points.size() - 1)).x;
        }
        return this.points.get((int)0).y == this.points.get((int)(this.points.size() - 1)).y;
    }

    public void collectSegments(ArrayList<Segment> segments) {
        RoutePoint p0 = this.points.get(0);
        int i = 1;
        while (i < this.points.size()) {
            RoutePoint p1 = this.points.get(i);
            segments.add(new Segment(p0, p1));
            p0 = p1;
            ++i;
        }
    }
}

