/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.Policy;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.internal.ide.IDESelectionConversionService;
import org.eclipse.ui.internal.ide.IDEWorkbenchActivityHelper;
import org.eclipse.ui.internal.ide.IDEWorkbenchErrorHandler;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.undo.WorkspaceUndoMonitor;
import org.eclipse.ui.internal.progress.ProgressMonitorJobsDialog;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.simantics.CancelStartupException;
import org.simantics.DatabaseBaselines;
import org.simantics.PlatformException;
import org.simantics.PlatformUserAgent;
import org.simantics.Simantics;
import org.simantics.SimanticsPlatform;
import org.simantics.UnhandledExceptionService;
import org.simantics.application.arguments.IArguments;
import org.simantics.application.arguments.SimanticsArguments;
import org.simantics.db.common.Indexing;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.project.IProject;
import org.simantics.project.ProjectKeys;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.jobs.SessionGarbageCollectorJob;
import org.simantics.ui.workbench.PerspectiveBarsActivator;
import org.simantics.ui.workbench.PerspectiveContextActivator;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.dialogs.ShowError;
import org.simantics.utils.ui.dialogs.ShowMessage;
import org.simantics.workbench.internal.Activator;
import org.simantics.workbench.internal.DelayedEventsProcessor;
import org.simantics.workbench.internal.IDEIdleHelper;
import org.simantics.workbench.internal.JFaceUserAgent;
import org.simantics.workbench.internal.SessionWatchdog;
import org.simantics.workbench.internal.SimanticsWorkbenchWindowAdvisor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimanticsWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimanticsWorkbenchAdvisor.class);
    private static final boolean PROFILE_PLATFORM_STARTUP = false;
    private static final String SHUT_DOWN_TASK = "Shutting down...";
    private static final String SHUT_DOWN_PLATFORM_TASK = "Shutting down platform...";
    private static final String WORKBENCH_PREFERENCE_CATEGORY_ID = "org.eclipse.ui.preferencePages.Workbench";
    private static final String INSTALLED_FEATURES = "installedFeatures";
    protected final IArguments args;
    protected final boolean restoredPreviousSession = false;
    protected boolean workbenchWindowsInitialized = false;
    protected boolean saveAtExit = false;
    private Map<String, AboutInfo> newlyAddedBundleGroups;
    private AboutInfo[] welcomePerspectiveInfos = null;
    private IDEWorkbenchActivityHelper activityHelper = null;
    private IDEIdleHelper idleHelper;
    private Listener settingsChangeListener;
    private WorkspaceUndoMonitor workspaceUndoMonitor;
    private AbstractStatusHandler ideWorkbenchErrorHandler;
    private DelayedEventsProcessor delayedEventsProcessor;
    final IRunnableWithProgress platformShutdownRunnable = new IRunnableWithProgress(){

        public void run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SimanticsWorkbenchAdvisor.SHUT_DOWN_PLATFORM_TASK, (int)100);
            try {
                try {
                    progress.subTask("Platform");
                    SimanticsPlatform.INSTANCE.shutdown((IProgressMonitor)progress.newChild(100));
                }
                catch (PlatformException e) {
                    Activator.logError("Problems encountered while shutting down Simantics platform, see exception for details.", e);
                }
                progress.subTask("Remaining database connections");
                SimanticsUI.closeSessions();
                progress.setWorkRemaining(0);
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    };
    private AbstractStatusHandler workbenchErrorHandler = new AbstractStatusHandler(){

        public void handle(StatusAdapter statusAdapter, int style) {
            if (SimanticsWorkbenchAdvisor.this.ideWorkbenchErrorHandler == null) {
                SimanticsWorkbenchAdvisor.this.ideWorkbenchErrorHandler = new IDEWorkbenchErrorHandler(SimanticsWorkbenchAdvisor.this.getWorkbenchConfigurer());
            }
            SimanticsWorkbenchAdvisor.this.ideWorkbenchErrorHandler.handle(statusAdapter, style);
            BundleContext context = Activator.getDefault().getBundle().getBundleContext();
            ServiceReference ref = context.getServiceReference(UnhandledExceptionService.class.getName());
            UnhandledExceptionService unhandled = (UnhandledExceptionService)context.getService(ref);
            Throwable t = statusAdapter.getStatus().getException();
            if (t != null) {
                unhandled.handle(t);
            }
        }
    };

    public SimanticsWorkbenchAdvisor(IArguments args, DelayedEventsProcessor processor) {
        this.args = args;
        this.delayedEventsProcessor = processor;
        Listener closeListener = new Listener(){

            public void handleEvent(Event event) {
                boolean doExit;
                event.doit = doExit = SimanticsWorkbenchWindowAdvisor.promptOnExit(null);
                if (!doExit) {
                    event.type = 0;
                }
            }
        };
        Display.getDefault().addListener(21, closeListener);
    }

    public IArguments getArguments() {
        return this.args;
    }

    public boolean workbenchInitialized() {
        return this.workbenchWindowsInitialized;
    }

    public boolean restoredPreviousSession() {
        return false;
    }

    boolean saveAtExit() {
        return this.saveAtExit;
    }

    void setSaveAtExit(boolean saveAtExit) {
        this.saveAtExit = saveAtExit;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        this.checkWorkspaceDatabaseIndexes();
        new PerspectiveContextActivator();
        new PerspectiveBarsActivator();
        IDE.registerAdapters();
        this.declareWorkbenchImages();
        this.activityHelper = IDEWorkbenchActivityHelper.getInstance();
        this.idleHelper = new IDEIdleHelper(configurer);
        this.workspaceUndoMonitor = WorkspaceUndoMonitor.getInstance();
        TrayDialog.setDialogHelpAvailable((boolean)true);
        Policy.setComparator((Comparator)Collator.getInstance());
    }

    private void checkWorkspaceDatabaseIndexes() {
        try {
            DatabaseIndexing.validateIndexes();
        }
        catch (IOException e) {
            Activator.logError("Problems encountered while checking database indexes, see exception for details.", e);
        }
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisorClass(SimanticsWorkbenchAdvisor advisor, IWorkbenchWindowConfigurer configurer) {
        return new SimanticsWorkbenchWindowAdvisor(this, configurer);
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        new SessionWatchdog().attach(Simantics.getSessionContextProvider());
        return this.createWorkbenchWindowAdvisorClass(this, configurer);
    }

    public boolean openWindowsSuper() {
        return super.openWindows();
    }

    private void fixBindings() {
        try {
            IBindingService bs = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            bs.savePreferences(bs.getActiveScheme(), bs.getBindings());
        }
        catch (IOException e) {
            Activator.logError(((Object)((Object)this)).getClass().getSimpleName() + ".fixBindings failed", e);
        }
    }

    public boolean openWindows() {
        boolean platformOk = this.startPlatform();
        LOGGER.info("startPlatform finished");
        TimeLogger.log((String)"SimanticsWorkbenchAdvisor.startPlatform finished");
        if (platformOk) {
            boolean windowsOpened = super.openWindows();
            TimeLogger.log((String)"Opened windows");
            if (windowsOpened) {
                this.workbenchWindowsInitialized = true;
                SessionGarbageCollectorJob.getInstance().scheduleAfterQuietTime();
                this.fixBindings();
                return true;
            }
        }
        try {
            this.platformShutdownRunnable.run(null);
        }
        catch (InvocationTargetException e) {
            Activator.logError(((Object)((Object)this)).getClass().getSimpleName() + ".openWindows failed", e.getCause());
        }
        catch (InterruptedException e) {
            Activator.logError(((Object)((Object)this)).getClass().getSimpleName() + ".openWindows failed", e);
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean startPlatform() {
        if (this.args.contains(SimanticsArguments.PERSPECTIVE)) {
            perspectiveId = (String)this.args.get(SimanticsArguments.PERSPECTIVE);
            perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(perspectiveId);
            if (perspective == null) {
                msg = new StringBuilder();
                msg.append("Requested perspective not found: '" + perspectiveId + "'\n");
                msg.append("Valid alternatives are:\n");
                var7_8 = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
                var6_9 = var7_8.length;
                var5_12 = 0;
                while (var5_12 < var6_9) {
                    pd = var7_8[var5_12];
                    msg.append("    " + pd.getId() + "\n");
                    ++var5_12;
                }
                ShowMessage.syncShowError((String)"Invalid Perspective", (String)msg.toString());
                return false;
            }
        }
        log = Platform.getLog((Bundle)Activator.getDefault().getBundle());
        try {
            workspacePolicy = Platform.inDevelopmentMode() != false ? SimanticsPlatform.RecoveryPolicy.FixError : SimanticsPlatform.RecoveryPolicy.ThrowError;
            v0 = ontologyPolicy = Platform.inDevelopmentMode() != false ? SimanticsPlatform.OntologyRecoveryPolicy.Merge : SimanticsPlatform.OntologyRecoveryPolicy.ThrowError;
            if (this.args.contains(SimanticsArguments.RECOVERY_POLICY_FIX_ERRORS)) {
                workspacePolicy = SimanticsPlatform.RecoveryPolicy.FixError;
                ontologyPolicy = SimanticsPlatform.OntologyRecoveryPolicy.Merge;
            }
            requireSynchronize = true;
            if (this.args.contains(SimanticsArguments.ONTOLOGY_RECOVERY_POLICY_REINSTALL)) {
                ontologyPolicy = SimanticsPlatform.OntologyRecoveryPolicy.ReinstallDatabase;
            }
            if (this.args.contains(SimanticsArguments.DO_NOT_SYNCHRONIZE_ONTOLOGIES)) {
                requireSynchronize = false;
                ontologyPolicy = SimanticsPlatform.OntologyRecoveryPolicy.Bypass;
            }
            if (this.args.contains(SimanticsArguments.DISABLE_INDEX)) {
                Indexing.setDefaultDependenciesIndexingEnabled((boolean)false);
            }
            if (this.args.contains(SimanticsArguments.SERVER)) {
                serverAddress = (String)this.args.get(SimanticsArguments.SERVER);
                throw new PlatformException("Argument not supported: " + String.valueOf(SimanticsArguments.SERVER) + " " + serverAddress);
            }
            databaseDriverId = Simantics.getDefaultDatabaseDriver();
            if (this.args.contains(SimanticsArguments.DATABASE_ID)) {
                databaseDriverId = (String)this.args.get(SimanticsArguments.DATABASE_ID);
                Simantics.setDefaultDatabaseDriver((String)databaseDriverId);
            }
            mon = null;
            SimanticsPlatform.INSTANCE.startUp(databaseDriverId, mon, workspacePolicy, ontologyPolicy, requireSynchronize, (PlatformUserAgent)new JFaceUserAgent());
            if (DatabaseBaselines.shouldCreateAutomaticBaseline((boolean)(SimanticsPlatform.INSTANCE.databaseExists() != null))) {
                SimanticsPlatform.INSTANCE.shutdown(null);
                DatabaseBaselines.createAutomaticBaseline((java.nio.file.Path)SimanticsPlatform.INSTANCE.dbLocation());
                SimanticsPlatform.INSTANCE.reconnect(Simantics.getDefaultDatabaseDriver());
            }
            this.getWorkbenchConfigurer().getWorkbench().getPerspectiveRegistry().setDefaultPerspective(this.getInitialWindowPerspectiveId());
            TimeLogger.log((String)"Completed setting default perspective");
            return true;
        }
        catch (CancelStartupException v1) {
            return false;
        }
        catch (PlatformException e) {
            hasStackTrace = e.getStackTrace().length > 0;
            ee = e;
            ** while (ee.getCause() != null)
        }
lbl-1000:
        // 1 sources

        {
            v2 = hasStackTrace = (ee = ee.getCause()).getStackTrace().length > 0;
            continue;
        }
lbl61:
        // 1 sources

        log.log((IStatus)new Status(4, "org.simantics.workbench", e.getMessage(), (Throwable)(hasStackTrace != false ? e : null)));
        if (hasStackTrace) {
            new ShowError("Platform Initialization Failed", "Simantics Platform initialization failed:\n\n" + e.getMessage(), (Throwable)e, true);
        } else {
            sb = new StringBuilder(256);
            sb.append(e.getMessage());
            c = e.getCause();
            while (c != null && c.getMessage() != null) {
                sb.append("\ncause: ").append(c.getMessage());
                c = c.getCause();
            }
            new ShowError("Startup Failed", sb.toString(), null, true);
        }
        return false;
        catch (Exception e) {
            log.log((IStatus)new Status(4, "org.simantics.workbench", e.getMessage(), (Throwable)e));
            new ShowError("Platform Startup Failed", "Simantics Platform startup failed:\n\n" + e.getMessage(), (Throwable)e, true);
            return false;
        }
    }

    public void preStartup() {
        Job.getJobManager().suspend();
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        ImageDescriptor newImage = IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_ETOOL_BUILD_EXEC");
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_MANUAL_BUILD);
        service.registerIconForFamily(newImage, ResourcesPlugin.FAMILY_AUTO_BUILD);
    }

    public void postStartup() {
        try {
            this.refreshFromLocal();
            this.activateProxyService();
            ((Workbench)PlatformUI.getWorkbench()).registerService(ISelectionConversionService.class, (Object)new IDESelectionConversionService());
            this.initializeSettingsChangeListener();
            Display.getCurrent().addListener(39, this.settingsChangeListener);
        }
        finally {
            Job.getJobManager().resume();
        }
    }

    private void activateProxyService() {
        ServiceReference ref;
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        Object proxyService = null;
        if (bundle != null && (ref = bundle.getBundleContext().getServiceReference(IProxyService.class.getName())) != null) {
            proxyService = bundle.getBundleContext().getService(ref);
        }
        if (proxyService == null) {
            IDEWorkbenchPlugin.log((String)"Proxy service could not be found.");
        }
    }

    private void initializeSettingsChangeListener() {
        this.settingsChangeListener = new Listener(){
            boolean currentHighContrast = Display.getCurrent().getHighContrast();

            public void handleEvent(Event event) {
                if (Display.getCurrent().getHighContrast() == this.currentHighContrast) {
                    return;
                }
                boolean bl = this.currentHighContrast = !this.currentHighContrast;
                if (new MessageDialog(null, IDEWorkbenchMessages.SystemSettingsChange_title, null, IDEWorkbenchMessages.SystemSettingsChange_message, 3, new String[]{IDEWorkbenchMessages.SystemSettingsChange_yes, IDEWorkbenchMessages.SystemSettingsChange_no}, 1).open() == 0) {
                    PlatformUI.getWorkbench().restart();
                }
            }
        };
    }

    public void postShutdown() {
        if (this.activityHelper != null) {
            this.activityHelper.shutdown();
            this.activityHelper = null;
        }
        if (this.idleHelper != null) {
            this.idleHelper.shutdown();
            this.idleHelper = null;
        }
        if (this.workspaceUndoMonitor != null) {
            this.workspaceUndoMonitor.shutdown();
            this.workspaceUndoMonitor = null;
        }
        if (IDEWorkbenchPlugin.getPluginWorkspace() != null) {
            this.disconnectFromWorkspace();
        }
    }

    public boolean preShutdown() {
        if (this.settingsChangeListener != null) {
            Display.getCurrent().removeListener(39, this.settingsChangeListener);
        }
        return super.preShutdown();
    }

    public boolean hasIntro() {
        return this.getWorkbenchConfigurer().getWorkbench().getIntroManager().hasIntro();
    }

    private void refreshFromLocal() {
        String[] commandLineArgs = Platform.getCommandLineArgs();
        IPreferenceStore store = IDEWorkbenchPlugin.getDefault().getPreferenceStore();
        boolean refresh = store.getBoolean("REFRESH_WORKSPACE_ON_STARTUP");
        if (!refresh) {
            return;
        }
        int i = 0;
        while (i < commandLineArgs.length) {
            if (commandLineArgs[i].equalsIgnoreCase("-refresh")) {
                return;
            }
            ++i;
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        WorkspaceJob job = new WorkspaceJob(IDEWorkbenchMessages.Workspace_refreshing, (IContainer)root){
            private final /* synthetic */ IContainer val$root;
            {
                this.val$root = iContainer;
                super($anonymous0);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                this.val$root.refreshLocal(2, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)root);
        job.schedule();
    }

    private void disconnectFromWorkspace() {
        final MultiStatus status = new MultiStatus("org.eclipse.ui.ide", 1, IDEWorkbenchMessages.ProblemSavingWorkbench, null);
        final CancelableProgressMonitorJobsDialog p = new CancelableProgressMonitorJobsDialog(null);
        final boolean applyPolicy = ResourcesPlugin.getWorkspace().getDescription().isApplyFileStatePolicy();
        final IRunnableWithProgress workspaceShutdownRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    status.merge(((Workspace)ResourcesPlugin.getWorkspace()).save(true, true, monitor));
                }
                catch (CoreException e) {
                    status.merge(e.getStatus());
                }
            }
        };
        IRunnableWithProgress shutdownRunnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                if (applyPolicy) {
                    monitor = new CancelableProgressMonitorWrapper((IProgressMonitor)monitor, p);
                }
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)SimanticsWorkbenchAdvisor.SHUT_DOWN_TASK, (int)2);
                try {
                    workspaceShutdownRunnable.run((IProgressMonitor)progress.newChild(1, 0));
                    SimanticsWorkbenchAdvisor.this.platformShutdownRunnable.run((IProgressMonitor)progress.newChild(1, 0));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorJobsDialog(null).run(true, false, shutdownRunnable);
        }
        catch (InvocationTargetException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, e.getTargetException()));
        }
        catch (InterruptedException e) {
            status.merge((IStatus)new Status(4, "org.eclipse.ui.ide", 1, IDEWorkbenchMessages.InternalError, (Throwable)e));
        }
        ErrorDialog.openError(null, (String)IDEWorkbenchMessages.ProblemsSavingWorkspace, null, (IStatus)status, (int)6);
        if (!status.isOK()) {
            IDEWorkbenchPlugin.log((String)IDEWorkbenchMessages.ProblemsSavingWorkspace, (IStatus)status);
        }
    }

    public IAdaptable getDefaultPageInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    public String getInitialWindowPerspectiveId() {
        IProject project;
        int index = PlatformUI.getWorkbench().getWorkbenchWindowCount() - 1;
        String perspectiveId = null;
        AboutInfo[] welcomeInfos = this.getWelcomePerspectiveInfos();
        if (index >= 0 && welcomeInfos != null && index < welcomeInfos.length) {
            perspectiveId = welcomeInfos[index].getWelcomePerspectiveId();
        }
        if (perspectiveId == null && this.args.contains(SimanticsArguments.PERSPECTIVE)) {
            String id = (String)this.args.get(SimanticsArguments.PERSPECTIVE);
            IPerspectiveDescriptor perspective = PlatformUI.getWorkbench().getPerspectiveRegistry().findPerspectiveWithId(id);
            if (perspective != null) {
                perspectiveId = id;
            }
        }
        if (perspectiveId == null && (project = Simantics.peekProject()) != null) {
            perspectiveId = (String)project.getHint(ProjectKeys.DEFAULT_PERSPECTIVE);
        }
        return perspectiveId;
    }

    private Map<String, AboutInfo> computeBundleGroupMap() {
        TreeMap<String, AboutInfo> ids = new TreeMap<String, AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        int i = 0;
        while (i < providers.length) {
            IBundleGroup[] groups = providers[i].getBundleGroups();
            int j = 0;
            while (j < groups.length) {
                IBundleGroup group = groups[j];
                AboutInfo info = new AboutInfo(group);
                String version = info.getVersionId();
                version = version == null ? "0.0.0" : new Version(version).toString();
                String versionedFeature = group.getIdentifier() + ":" + version;
                ids.put(versionedFeature, info);
                ++j;
            }
            ++i;
        }
        return ids;
    }

    public Map<String, AboutInfo> getNewlyAddedBundleGroups() {
        if (this.newlyAddedBundleGroups == null) {
            this.newlyAddedBundleGroups = this.createNewBundleGroupsMap();
        }
        return this.newlyAddedBundleGroups;
    }

    private Map<String, AboutInfo> createNewBundleGroupsMap() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        String[] previousFeaturesArray = settings.getArray(INSTALLED_FEATURES);
        Map<String, AboutInfo> bundleGroups = this.computeBundleGroupMap();
        String[] currentFeaturesArray = new String[bundleGroups.size()];
        bundleGroups.keySet().toArray(currentFeaturesArray);
        settings.put(INSTALLED_FEATURES, currentFeaturesArray);
        if (previousFeaturesArray != null) {
            int i = 0;
            while (i < previousFeaturesArray.length) {
                bundleGroups.remove(previousFeaturesArray[i]);
                ++i;
            }
        }
        return bundleGroups;
    }

    private void declareWorkbenchImages() {
        Bundle ideBundle = Platform.getBundle((String)"org.eclipse.ui.ide");
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_HOVER", "$nl$/icons/full/etool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_BUILD_EXEC_DISABLED", "$nl$/icons/full/dtool16/build_exec.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_HOVER", "$nl$/icons/full/etool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_SEARCH_SRC_DISABLED", "$nl$/icons/full/dtool16/search_src.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_NEXT_NAV", "$nl$/icons/full/etool16/next_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PREVIOUS_NAV", "$nl$/icons/full/etool16/prev_nav.gif", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWPRJ_WIZ", "$nl$/icons/full/wizban/newprj_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFOLDER_WIZ", "$nl$/icons/full/wizban/newfolder_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_NEWFILE_WIZ", "$nl$/icons/full/wizban/newfile_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTDIR_WIZ", "$nl$/icons/full/wizban/importdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_IMPORTZIP_WIZ", "$nl$/icons/full/wizban/importzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTDIR_WIZ", "$nl$/icons/full/wizban/exportdir_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/exportzip_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_WIZBAN_EXPORTZIP_WIZ", "$nl$/icons/full/wizban/workset_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_SAVEAS_DLG", "$nl$/icons/full/wizban/saveas_wiz.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_DLGBAN_QUICKFIX_DLG", "$nl$/icons/full/wizban/quick_fix.png", false);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT", "$nl$/icons/full/obj16/prj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJ_PROJECT_CLOSED", "$nl$/icons/full/obj16/cprj_obj.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OPEN_MARKER", "$nl$/icons/full/elcl16/gotoobj_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ELCL_QUICK_FIX_ENABLED", "$nl$/icons/full/elcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_DLCL_QUICK_FIX_DISABLED", "$nl$/icons/full/dlcl16/smartmode_co.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_TASK_TSK", "$nl$/icons/full/obj16/taskmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_BKMRK_TSK", "$nl$/icons/full/obj16/bkmrk_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_COMPLETE_TSK", "$nl$/icons/full/obj16/complete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INCOMPLETE_TSK", "$nl$/icons/full/obj16/incomplete_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_ITEM", "$nl$/icons/full/obj16/welcome_item.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WELCOME_BANNER", "$nl$/icons/full/obj16/welcome_banner.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_ERROR_PATH", "$nl$/icons/full/obj16/error_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_WARNING_PATH", "$nl$/icons/full/obj16/warn_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_OBJS_INFO_PATH", "$nl$/icons/full/obj16/info_tsk.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_FLAT_LAYOUT", "$nl$/icons/full/elcl16/flatLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_LCL_HIERARCHICAL_LAYOUT", "$nl$/icons/full/elcl16/hierarchicalLayout.gif", true);
        this.declareWorkbenchImage(ideBundle, "IMG_ETOOL_PROBLEM_CATEGORY", "$nl$/icons/full/etool16/problem_category.gif", true);
    }

    private void declareWorkbenchImage(Bundle ideBundle, String symbolicName, String path, boolean shared) {
        URL url = FileLocator.find((Bundle)ideBundle, (IPath)new Path(path), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        this.getWorkbenchConfigurer().declareImage(symbolicName, desc, shared);
    }

    public String getMainPreferencePageId() {
        return WORKBENCH_PREFERENCE_CATEGORY_ID;
    }

    public String getWorkspaceLocation() {
        String location;
        IEclipseContext context = (IEclipseContext)this.getWorkbenchConfigurer().getWorkbench().getService(IEclipseContext.class);
        String string = location = context != null ? (String)context.get("forcedShowLocation") : null;
        if (location != null) {
            return location;
        }
        if (IDEWorkbenchPlugin.getDefault().getPreferenceStore().getBoolean("SHOW_LOCATION")) {
            return Platform.getLocation().toOSString();
        }
        return null;
    }

    public AboutInfo[] getWelcomePerspectiveInfos() {
        if (this.welcomePerspectiveInfos == null && !this.hasIntro()) {
            Map<String, AboutInfo> m = this.getNewlyAddedBundleGroups();
            ArrayList<AboutInfo> list = new ArrayList<AboutInfo>(m.size());
            for (AboutInfo info : m.values()) {
                if (info == null || info.getWelcomePerspectiveId() == null || info.getWelcomePageURL() == null) continue;
                list.add(info);
            }
            this.welcomePerspectiveInfos = new AboutInfo[list.size()];
            list.toArray(this.welcomePerspectiveInfos);
        }
        return this.welcomePerspectiveInfos;
    }

    public AbstractStatusHandler getWorkbenchErrorHandler() {
        return this.workbenchErrorHandler;
    }

    public void eventLoopIdle(Display display) {
        if (this.delayedEventsProcessor != null) {
            this.delayedEventsProcessor.catchUp(display);
        }
        super.eventLoopIdle(display);
    }

    private static class CancelableProgressMonitorJobsDialog
    extends ProgressMonitorJobsDialog {
        public CancelableProgressMonitorJobsDialog(Shell parent) {
            super(parent);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            super.createButtonsForButtonBar(parent);
            this.registerCancelButtonListener();
        }

        public void registerCancelButtonListener() {
            this.cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    subTaskLabel.setText("");
                }
            });
        }
    }

    private static class CancelableProgressMonitorWrapper
    extends ProgressMonitorWrapper {
        private double total = 0.0;
        private ProgressMonitorJobsDialog dialog;

        CancelableProgressMonitorWrapper(IProgressMonitor monitor, ProgressMonitorJobsDialog dialog) {
            super(monitor);
            this.dialog = dialog;
        }

        public void internalWorked(double work) {
            super.internalWorked(work);
            this.total += work;
            this.updateProgressDetails();
        }

        public void worked(int work) {
            super.worked(work);
            this.total += (double)work;
            this.updateProgressDetails();
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.subTask(IDEWorkbenchMessages.IDEWorkbenchAdvisor_preHistoryCompaction);
        }

        private void updateProgressDetails() {
            if (!this.isCanceled() && Math.abs(this.total - 4.0) < 1.0E-4) {
                this.subTask(IDEWorkbenchMessages.IDEWorkbenchAdvisor_cancelHistoryPruning);
                this.dialog.setCancelable(true);
            }
            if (Math.abs(this.total - 5.0) < 1.0E-4) {
                this.subTask(IDEWorkbenchMessages.IDEWorkbenchAdvisor_postHistoryCompaction);
                this.dialog.setCancelable(false);
            }
        }
    }
}

