/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.Preference;
import org.simantics.browsing.ui.common.Testers;
import org.simantics.browsing.ui.content.CheckedStateFactory;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.browsing.ui.content.ImageDecoratorFactory;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.browsing.ui.content.LabelDecoratorFactory;
import org.simantics.browsing.ui.content.LabelerFactory;
import org.simantics.browsing.ui.content.ViewpointFactory;

public class EvaluatorImpl
implements EvaluatorData.Evaluator {
    private final EvaluatorData.EvaluatorTree<ViewpointFactory> viewpointTree = new EvaluatorTreeImpl<ViewpointFactory>("Viewpoint", Testers.PASS);
    private final EvaluatorData.EvaluatorTree<LabelerFactory> labelerTree = new EvaluatorTreeImpl<LabelerFactory>("Labeler", Testers.PASS);
    private final EvaluatorData.EvaluatorTree<CheckedStateFactory> checkStateTree = new EvaluatorTreeImpl<CheckedStateFactory>("Check state", Testers.PASS);
    private final EvaluatorData.EvaluatorTree<LabelDecoratorFactory> labelDecoratorTree = new EvaluatorTreeImpl<LabelDecoratorFactory>("Label decorator", Testers.PASS);
    private final EvaluatorData.EvaluatorTree<ImagerFactory> imagerTree = new EvaluatorTreeImpl<ImagerFactory>("Imager", Testers.PASS);
    private final EvaluatorData.EvaluatorTree<ImageDecoratorFactory> imageDecoratorTree = new EvaluatorTreeImpl<ImageDecoratorFactory>("Image decorator", Testers.PASS);
    private final EvaluatorData.EvaluatorTree<ComparableContextFactory> comparableContextTree = new EvaluatorTreeImpl<ComparableContextFactory>("Comparable", Testers.PASS);

    @Override
    public EvaluatorData.Evaluator addViewpoint(ViewpointFactory factory, double preference) {
        this.viewpointTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.Evaluator addComparableContext(ComparableContextFactory factory, double preference) {
        this.comparableContextTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.Evaluator addLabeler(LabelerFactory factory, double preference) {
        this.labelerTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.Evaluator addCheckState(CheckedStateFactory factory, double preference) {
        this.checkStateTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.Evaluator addLabelDecorator(LabelDecoratorFactory factory, double preference) {
        this.labelDecoratorTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.Evaluator addComparator(ComparableContextFactory factory, double preference) {
        this.comparableContextTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.Evaluator addImager(ImagerFactory factory, double preference) {
        this.imagerTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.Evaluator addImageDecorator(ImageDecoratorFactory factory, double preference) {
        this.imageDecoratorTree.addFactory(factory, preference);
        return this;
    }

    @Override
    public EvaluatorData.EvaluatorTree<ComparableContextFactory> getComparableContextTree() {
        return this.comparableContextTree;
    }

    @Override
    public EvaluatorData.EvaluatorTree<ImagerFactory> getImagerTree() {
        return this.imagerTree;
    }

    @Override
    public EvaluatorData.EvaluatorTree<ImageDecoratorFactory> getImageDecoratorTree() {
        return this.imageDecoratorTree;
    }

    @Override
    public EvaluatorData.EvaluatorTree<LabelDecoratorFactory> getLabelDecoratorTree() {
        return this.labelDecoratorTree;
    }

    @Override
    public EvaluatorData.EvaluatorTree<LabelerFactory> getLabelerTree() {
        return this.labelerTree;
    }

    @Override
    public EvaluatorData.EvaluatorTree<CheckedStateFactory> getCheckStateTree() {
        return this.checkStateTree;
    }

    @Override
    public EvaluatorData.EvaluatorTree<ViewpointFactory> getViewpointTree() {
        return this.viewpointTree;
    }

    public String toString() {
        return "Evaluator";
    }

    public class EvaluatorTreeImpl<Factory>
    implements EvaluatorData.EvaluatorTree<Factory> {
        private final String factory;
        private final Tester tester;
        private final Collection<Preference<Factory>> acceptedFactories = new ArrayList<Preference<Factory>>();
        private final Collection<EvaluatorData.EvaluatorTree<Factory>> children = new ArrayList<EvaluatorData.EvaluatorTree<Factory>>();

        public EvaluatorTreeImpl(String factory, Tester tester) {
            if (tester == null) {
                throw new NullPointerException("null tester");
            }
            this.tester = tester;
            this.factory = factory;
        }

        @Override
        public EvaluatorData.EvaluatorTree<Factory> addFactory(Factory factory, double preference) {
            if (factory == null) {
                throw new NullPointerException("null factory");
            }
            this.acceptedFactories.add(new Preference<Factory>(factory, preference));
            return this;
        }

        @Override
        public EvaluatorData.EvaluatorTree<Factory> addBranch(Tester tester) {
            if (tester == null) {
                throw new NullPointerException("null tester");
            }
            EvaluatorTreeImpl<Factory> result = new EvaluatorTreeImpl<Factory>(this.factory, tester);
            this.children.add(result);
            return result;
        }

        @Override
        public Collection<Preference<Factory>> getAcceptedFactories() {
            return this.acceptedFactories;
        }

        @Override
        public Collection<EvaluatorData.EvaluatorTree<Factory>> getChildren() {
            return this.children;
        }

        @Override
        public Tester getTester() {
            return this.tester;
        }

        public String toString() {
            return this.factory + " tree [" + String.valueOf(this.tester) + "]";
        }
    }
}

