/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.common.procedure.adapter.ListenerAdapter;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.utils.datastructures.map.Tuple;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceEditorSupport
implements IAdaptable,
ChangeListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceEditorSupport.class);
    private static final boolean DEBUG = false;
    private IEditorPart editorPart;
    private ChangeListener editorPartChangeListener;
    private ISessionContext sessionContext;
    private Session session;
    ParametrizedRead<IResourceEditorInput, Boolean> inputValidator;
    private InputListener inputListener;

    public ResourceEditorSupport(IEditorPart editorPart) throws PartInitException {
        this(editorPart, null);
    }

    public ResourceEditorSupport(IEditorPart editorPart, ParametrizedRead<IResourceEditorInput, Boolean> inputValidator) throws PartInitException {
        this.editorPart = editorPart;
        this.editorPartChangeListener = this.getChangeListener(editorPart);
        this.inputValidator = inputValidator;
        this.initSession();
        IResourceEditorInput input = ResourceEditorSupport.getResourceInput(editorPart);
        if (input == null) {
            throw new PartInitException("Editor input must be an IResourceEditorInput, got " + String.valueOf(editorPart.getEditorInput()));
        }
        try {
            input.init(this);
        }
        catch (DatabaseException e) {
            throw new PartInitException("Failed to initialize " + String.valueOf(input), (Throwable)e);
        }
    }

    private ISessionContext initSession() throws PartInitException {
        if (this.sessionContext == null) {
            ISessionContextProvider provider = Simantics.getSessionContextProvider();
            ISessionContext sc = provider.getSessionContext();
            if (sc == null) {
                throw new PartInitException("active database session context is null");
            }
            this.sessionContext = sc;
            this.session = sc.getSession();
            if (this.editorPartChangeListener != null) {
                GraphChangeListenerSupport support = (GraphChangeListenerSupport)this.session.getService(GraphChangeListenerSupport.class);
                support.addListener((ChangeListener)this);
            }
        }
        return this.sessionContext;
    }

    private ChangeListener getChangeListener(IEditorPart part) {
        if (part instanceof ChangeListener) {
            return (ChangeListener)part;
        }
        ChangeListener cl = (ChangeListener)part.getAdapter(ChangeListener.class);
        return cl;
    }

    private static IResourceEditorInput getResourceInput(IEditorPart part) {
        IEditorInput input = part.getEditorInput();
        if (input instanceof IResourceEditorInput) {
            return (IResourceEditorInput)input;
        }
        return null;
    }

    public void dispose() {
        IResourceEditorInput input;
        this.deactivateValidation();
        if (!PlatformUI.getWorkbench().isClosing() && (input = ResourceEditorSupport.getResourceInput(this.editorPart)) != null) {
            input.dispose();
        }
        this.editorPart = null;
        this.sessionContext = null;
        if (this.session != null) {
            if (this.editorPartChangeListener != null) {
                GraphChangeListenerSupport support = (GraphChangeListenerSupport)this.session.getService(GraphChangeListenerSupport.class);
                support.removeListener((ChangeListener)this);
            }
            this.session = null;
        }
        this.editorPartChangeListener = null;
    }

    protected boolean isDisposed() {
        return this.editorPart == null;
    }

    public synchronized void activateValidation() {
        if (this.isDisposed()) {
            throw new IllegalStateException(String.valueOf(this) + " is disposed");
        }
        if (this.inputListener != null) {
            return;
        }
        this.inputListener = new InputListener();
        this.getSession().asyncRequest((Read)new ValidationRequest(), (Listener)this.inputListener);
    }

    public synchronized void deactivateValidation() {
        if (this.isDisposed()) {
            throw new IllegalStateException(String.valueOf(this) + " is disposed");
        }
        if (this.inputListener == null) {
            return;
        }
        this.inputListener.dispose();
        this.inputListener = null;
    }

    public ISessionContext getSessionContext() {
        if (this.sessionContext == null) {
            throw new IllegalStateException("ResourceEditorSupport is disposed");
        }
        return this.sessionContext;
    }

    public Session getSession() {
        if (this.session == null) {
            throw new IllegalStateException("ResourceEditorSupport is disposed");
        }
        return this.session;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == ISessionContext.class) {
            return (T)this.getSessionContext();
        }
        if (adapter == Session.class) {
            return (T)this.getSession();
        }
        return null;
    }

    public void graphChanged(ChangeEvent e) throws DatabaseException {
        if (this.editorPart instanceof ChangeListener) {
            ((ChangeListener)this.editorPart).graphChanged(e);
        }
    }

    private static void scheduleEditorClose(IEditorPart editorPart) {
        if (editorPart == null) {
            return;
        }
        IWorkbenchPartSite site = editorPart.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchWindow window = site.getWorkbenchWindow();
        if (window == null) {
            return;
        }
        IWorkbench workbench = window.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        if (display == null) {
            return;
        }
        SWTUtils.asyncExec((Display)display, () -> WorkbenchUtils.closeEditor((IEditorPart)editorPart, (boolean)false));
    }

    static class Evaluation
    extends Tuple {
        public Evaluation(IEditorPart editorPart, IEditorInput input, InputState state, String name, String tooltip) {
            super(new Object[]{editorPart, input, state, name, tooltip});
        }

        public IEditorPart getEditorPart() {
            return (IEditorPart)this.getField(0);
        }

        public IEditorInput getEditorInput() {
            return (IEditorInput)this.getField(1);
        }

        public InputState getInputState() {
            return (InputState)((Object)this.getField(2));
        }
    }

    private static class InputListener
    extends ListenerAdapter<Evaluation> {
        private boolean disposed = false;

        private InputListener() {
        }

        public void dispose() {
            this.disposed = true;
        }

        public void execute(Evaluation evaluation) {
            switch (evaluation.getInputState()) {
                case VALID: {
                    break;
                }
                case INVALID: 
                case NON_EXISTENT: {
                    ResourceEditorSupport.scheduleEditorClose(evaluation.getEditorPart());
                }
            }
        }

        public void exception(Throwable t) {
            ExceptionUtils.logError((String)"ResourceEditorSupport.InputListener received an unexpected exception.", (Throwable)t);
        }

        public boolean isDisposed() {
            return this.disposed;
        }
    }

    static enum InputState {
        VALID,
        INVALID,
        NON_EXISTENT;


        public static InputState parse(boolean exists, boolean valid) {
            if (!exists) {
                return NON_EXISTENT;
            }
            return valid ? VALID : INVALID;
        }
    }

    private class ValidationRequest
    extends UniqueRead<Evaluation> {
        private ValidationRequest() {
        }

        public Evaluation perform(ReadGraph graph) throws DatabaseException {
            InputState state;
            IEditorPart part = ResourceEditorSupport.this.editorPart;
            if (part == null) {
                return new Evaluation(null, null, InputState.INVALID, "", "");
            }
            IEditorInput input = part.getEditorInput();
            IResourceEditorInput resourceInput = ResourceEditorSupport.getResourceInput(part);
            boolean exists = true;
            boolean valid = true;
            if (resourceInput != null) {
                exists = resourceInput.exists(graph);
                if (exists && ResourceEditorSupport.this.inputValidator != null) {
                    valid = (Boolean)graph.syncRequest(ResourceEditorSupport.this.inputValidator.get((Object)resourceInput));
                }
            } else {
                exists = input.exists();
            }
            if ((state = InputState.parse(exists, valid)) == InputState.VALID && resourceInput != null) {
                resourceInput.update(graph);
            }
            Evaluation eval = new Evaluation(part, input, state, input.getName(), input.getToolTipText());
            return eval;
        }
    }
}

