/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.contribution;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.request.Read;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.ui.workbench.action.ResourceEditorAdapterAction;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.ui.workbench.editor.EditorRegistry;
import org.simantics.utils.strings.AlphanumComparator;
import org.simantics.utils.ui.SWTUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenWithMenuContribution2
extends ContributionItem
implements IExecutableExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenWithMenuContribution2.class);
    protected ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    private String editorId;
    private boolean showEmptyMenu = true;
    private int modCount = 0;
    private static final Comparator<EditorAdapter> EDITOR_ADAPTER_COMPARATOR = (o1, o2) -> OpenWithMenuContribution2.compare(o2.getPriority(), o1.getPriority(), ResourceEditorAdapterAction.makeName(o1), ResourceEditorAdapterAction.makeName(o2));

    /*
     * WARNING - void declaration
     */
    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if ("class".equals(propertyName)) {
            Object object = data;
            if (object instanceof String) {
                void params;
                String[] parameters;
                String string = (String)object;
                String cfr_ignored_0 = (String)object;
                String[] stringArray = parameters = params.split(";");
                int n = parameters.length;
                int n2 = 0;
                while (n2 < n) {
                    String parameter = stringArray[n2];
                    String[] keyValue = parameter.split("=");
                    if (keyValue.length == 1) {
                        this.setEditorId(keyValue[0]);
                    } else if (keyValue.length == 2 && "showEmptyMenu".equals(keyValue[0])) {
                        this.showEmptyMenu = Boolean.parseBoolean(keyValue[1]);
                    }
                    ++n2;
                }
            } else if (data instanceof Hashtable) {
                Hashtable params = (Hashtable)data;
                this.setEditorId((String)params.get("editorId"));
                this.showEmptyMenu = Boolean.parseBoolean((String)params.get("showEmptyMenu"));
            }
            if ("activeEditorId".equals(this.editorId)) {
                this.setEditorId(WorkbenchUtils.getActiveWorkbenchPart().getSite().getId());
            }
        }
    }

    protected String getText() {
        return "Open With";
    }

    public String getEditorId() {
        return this.editorId;
    }

    public void setEditorId(String editorId) {
        this.editorId = editorId;
    }

    public void dispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.dispose();
    }

    public boolean isDynamic() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected IStructuredSelection getSelection() {
        IStructuredSelection iStructuredSelection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelectionService service = window.getSelectionService();
        ISelection sel = service.getSelection();
        ISelection iSelection = sel;
        if (iSelection instanceof IStructuredSelection) {
            void ss;
            IStructuredSelection iStructuredSelection2 = (IStructuredSelection)iSelection;
            IStructuredSelection cfr_ignored_0 = (IStructuredSelection)iSelection;
            iStructuredSelection = ss;
        } else {
            iStructuredSelection = null;
        }
        return iStructuredSelection;
    }

    protected static Object extractResource(RequestProcessor processor, Object object) throws DatabaseException {
        Resource resource = WorkbenchSelectionUtils.getPossibleResourceFromSelection(processor, object);
        return resource != null ? resource : object;
    }

    protected Object resolveInput() {
        IStructuredSelection selection;
        Object input = selection = this.getSelection();
        if (selection != null && selection.size() == 1) {
            try {
                input = OpenWithMenuContribution2.extractResource((RequestProcessor)Simantics.getSession(), selection.getFirstElement());
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to resolve input resource from {}", (Object)selection, (Object)e);
            }
        }
        return input;
    }

    public void fill(Menu menu, final int index) {
        final Object input = this.resolveInput();
        if (input == null) {
            return;
        }
        final int myCount = ++this.modCount;
        final Display display = menu.getDisplay();
        final AMenu subMenu = this.showEmptyMenu ? this.createSubMenu(menu, index, this.getText(), false) : new AMenu(null, menu);
        Simantics.getSession().asyncRequest((Read)new ResolveEditorAdapters(input, this.editorId), (Procedure)new Procedure<List<EditorAdapter>>(){

            public void execute(List<EditorAdapter> adapters) {
                if (adapters.isEmpty() && OpenWithMenuContribution2.this.showEmptyMenu) {
                    return;
                }
                SWTUtils.asyncExec((Display)display, () -> OpenWithMenuContribution2.this.contributeOpenWithMenuItems(subMenu, index, input, adapters, myCount));
            }

            public void exception(Throwable t) {
                LOGGER.error("Resolution of suitable editor adapters for Open With menu failed.", t);
            }
        });
    }

    private void contributeOpenWithMenuItems(AMenu parent, int index, Object input, List<EditorAdapter> adapters, int myCount) {
        if (adapters.isEmpty() || myCount != this.modCount || parent.menu().isDisposed() || this.resourceManager == null) {
            return;
        }
        AMenu openWith = this.showEmptyMenu ? parent : this.createSubMenu(parent.menu(), index, this.getText(), true);
        for (EditorAdapter adapter : adapters) {
            this.addMenuItem(openWith.menu(), new Adapter(adapter, input, true));
        }
        openWith.item.setEnabled(true);
    }

    private AMenu createSubMenu(Menu parent, int index, String label, boolean enabled) {
        MenuItem item = new MenuItem(parent, 64, index);
        item.setText(label);
        item.setEnabled(enabled);
        Menu submenu = new Menu(parent);
        item.setMenu(submenu);
        return new AMenu(item, submenu);
    }

    private static final int compare(int p1, int p2, String t1, String t2) {
        int delta = Integer.compare(p1, p2);
        if (delta != 0) {
            return delta;
        }
        return AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare((Object)t1, (Object)t2);
    }

    private static List<EditorAdapter> resolveEditorAdapters(ReadGraph graph, Object input, String filteredEditorId) throws DatabaseException {
        Stream<Object> s = Arrays.asList(EditorRegistry.getInstance().getAdaptersFor(graph, input)).stream();
        if (filteredEditorId != null) {
            s = s.filter(a -> !filteredEditorId.equals(a.getEditorId()));
        }
        return s.sorted(EDITOR_ADAPTER_COMPARATOR).toList();
    }

    private void addMenuItem(Menu parentMenu, Adapter adapter) {
        MenuItem item = new MenuItem(parentMenu, 8);
        Object text = adapter.getText();
        if (LOGGER.isDebugEnabled()) {
            text = (String)text + " (" + adapter.getAdapter().getClass().getCanonicalName() + ") [" + adapter.getPriority() + "]";
        }
        item.setText((String)text);
        ImageDescriptor descriptor = adapter.getImageDescriptor();
        if (descriptor != null) {
            item.setImage(this.resourceManager.createImage(descriptor));
        }
        item.addSelectionListener((SelectionListener)adapter);
    }

    private record AMenu(MenuItem item, Menu menu) {
    }

    protected static class Adapter
    extends ResourceEditorAdapterAction
    implements SelectionListener {
        boolean remember;

        public Adapter(EditorAdapter adapter, Object r, boolean remember) {
            super(adapter, r);
            this.remember = remember;
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }

        @Override
        protected void safeRun() throws Exception {
            super.safeRun();
            if (this.remember) {
                EditorRegistry.getInstance().getMappings().put(this.getResource(), this.getAdapter());
            }
        }
    }

    protected static class ResolveEditorAdapters
    extends BinaryRead<Object, String, List<EditorAdapter>> {
        public ResolveEditorAdapters(Object input, String filteredEditorId) {
            super(input, (Object)filteredEditorId);
        }

        public List<EditorAdapter> perform(ReadGraph graph) throws DatabaseException {
            LOGGER.trace(ResolveEditorAdapters.class.getName());
            return OpenWithMenuContribution2.resolveEditorAdapters(graph, this.parameter, (String)this.parameter2);
        }
    }
}

