/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.simantics.diagram.participant.SVGTransfer;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DRenderingHints;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.scenegraph.g2d.nodes.LinkNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.utils.NodeMapper;
import org.simantics.utils.ui.ErrorLogger;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CopyAsSVGParticipant
extends AbstractDiagramParticipant {
    @DependencyReflection.Dependency
    protected Selection sel;
    private static List<String> copiedAttributes = Arrays.asList("stroke", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke-width", "fill", "fill-opacity", "font-family", "font-size", "font-style", "font-weight");

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommand(CommandEvent e) {
        if (e.command.equals((Object)Commands.COPY_AS_SVG)) {
            Set ss = this.sel.getSelection(0);
            CopyAsSVGParticipant.copyAsSVG(this.getContext(), ss);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static void copyAsSVG(ICanvasContext canvasContext, Set<IElement> elements) {
        G2DSceneGraph sg = canvasContext.getSceneGraph();
        NodeMapper clipboardNodeMapper = new NodeMapper();
        SingleElementNode clipboardNode = (SingleElementNode)sg.addNode("svg-clipboard-temp", SingleElementNode.class);
        try {
            for (IElement e : elements) {
                INode node = (INode)e.getHint(ElementHints.KEY_SG_NODE);
                if (node == null) continue;
                String nodeId = clipboardNodeMapper.add(node);
                LinkNode delegate = (LinkNode)clipboardNode.addNode(ElementUtils.generateNodeId((IElement)e), LinkNode.class);
                INode iNode = node;
                if (iNode instanceof IG2DNode) {
                    void g2n;
                    IG2DNode cfr_ignored_0 = (IG2DNode)iNode;
                    IG2DNode cfr_ignored_1 = (IG2DNode)iNode;
                    delegate.setZIndex(g2n.getZIndex());
                }
                delegate.setDelegateId(nodeId);
            }
            DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
            String svgNS = "http://www.w3.org/2000/svg";
            Document document = domImpl.createDocument(svgNS, "svg", null);
            SVGGeneratorContext.GraphicContextDefaults gcDefaults = new SVGGeneratorContext.GraphicContextDefaults();
            SVGGeneratorContext ctx = SVGGeneratorContext.createDefault((Document)document);
            HashMap<RenderingHints.Key, Object> hintMap = new HashMap<RenderingHints.Key, Object>();
            hintMap.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            hintMap.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            hintMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            hintMap.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            hintMap.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            gcDefaults.setRenderingHints(new RenderingHints(hintMap));
            gcDefaults.setFont(Font.decode(null));
            ctx.setGraphicContextDefaults(gcDefaults);
            SVGGraphics2D svgG2D = new SVGGraphics2D(ctx, false);
            svgG2D.setRenderingHint((RenderingHints.Key)G2DRenderingHints.KEY_HIDE_SELECTION, (Object)true);
            StringWriter writer = new StringWriter();
            ((IG2DNode)sg.getNode("connection-crossings")).render((Graphics2D)svgG2D);
            clipboardNode.render((Graphics2D)svgG2D);
            Element root = svgG2D.getRoot();
            Rectangle2D bounds = clipboardNode.getBoundsInLocal(true);
            if (bounds != null) {
                root.setAttributeNS(null, "viewBox", bounds.getMinX() + " " + bounds.getMinY() + " " + bounds.getWidth() + " " + bounds.getHeight());
                root.setAttributeNS(null, "height", Double.toString(bounds.getHeight()));
                root.setAttributeNS(null, "width", Double.toString(bounds.getWidth()));
            }
            CopyAsSVGParticipant.copyRootAttributesToRootGroups(root);
            try {
                svgG2D.stream(root, (Writer)writer, false, false);
            }
            catch (SVGGraphics2DIOException e1) {
                ErrorLogger.defaultLogError((String)"Failed to copy the diagram selection as SVG.", (Throwable)e1);
            }
            String svgText = writer.toString();
            byte[] svgContent = svgText.getBytes(StandardCharsets.UTF_8);
            Display.getDefault().asyncExec(() -> {
                Clipboard cb = new Clipboard(Display.getCurrent());
                cb.setContents(new Object[]{svgContent, svgText}, new Transfer[]{SVGTransfer.getInstance(), TextTransfer.getInstance()});
            });
        }
        finally {
            clipboardNode.removeNodes();
            clipboardNodeMapper.clear();
            clipboardNode.remove();
        }
    }

    private static void copyRootAttributesToRootGroups(Element root) {
        ArrayList<String> values = new ArrayList<String>(copiedAttributes.size());
        for (String attr : copiedAttributes) {
            values.add(root.getAttribute(attr));
        }
        NodeList rch = root.getChildNodes();
        int i = 0;
        while (i < rch.getLength()) {
            Node n = rch.item(i);
            if (n.getNodeType() == 1 && "g".equals(n.getNodeName())) {
                Element e = (Element)n;
                int j = 0;
                while (j < values.size()) {
                    String attr = copiedAttributes.get(j);
                    String v = (String)values.get(j);
                    if (!v.isEmpty() && !e.hasAttribute(attr)) {
                        e.setAttribute(attr, v);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }
}

