/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.function.DbBiFunction;
import org.simantics.issues.Severity;
import org.simantics.issues.ontology.IssueResource;

public class MaxIssueSeveritySingle
extends ResourceRead<Severity> {
    public MaxIssueSeveritySingle(Resource resource) {
        super(resource);
    }

    public Severity perform(ReadGraph graph) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        Severity maxSeverity = null;
        DbBiFunction newSeverity = (issue, previousMaxSeverity) -> {
            Boolean active;
            boolean resolved = graph.hasStatement(issue, issueResource.Resolved);
            if (resolved) {
                return previousMaxSeverity;
            }
            Resource issueSource = graph.getPossibleObject(issue, issueResource.IssueSource_Manages_Inverse);
            if (issueSource != null && Boolean.FALSE.equals(active = (Boolean)graph.getPossibleRelatedValue(issueSource, issueResource.IssueSource_active, (Binding)Bindings.BOOLEAN))) {
                return previousMaxSeverity;
            }
            Resource severity = graph.getPossibleObject(issue, issueResource.Issue_HasSeverity);
            return severity != null ? Severity.moreSevere((Severity)previousMaxSeverity, (Severity)MaxIssueSeveritySingle.toSeverity(ISSUE, severity)) : previousMaxSeverity;
        };
        Collection issues = graph.getObjects(this.resource, ISSUE.Issue_HasContext_Inverse);
        for (Resource issue2 : issues) {
            maxSeverity = (Severity)newSeverity.apply((Object)issue2, maxSeverity);
        }
        Collection elements = graph.getObjects(this.resource, ISSUE.Issue_ContextList_Element_Inverse);
        for (Resource element : elements) {
            Resource list = ListUtils.getListElementList((ReadGraph)graph, (Resource)element);
            Resource issue3 = graph.getPossibleObject(list, ISSUE.Issue_HasContexts_Inverse);
            if (issue3 == null) continue;
            maxSeverity = (Severity)newSeverity.apply((Object)issue3, (Object)maxSeverity);
        }
        return maxSeverity;
    }

    private static Severity toSeverity(IssueResource ISSUE, Resource severity) {
        if (ISSUE.Severity_Fatal.equals(severity)) {
            return Severity.FATAL;
        }
        if (ISSUE.Severity_Error.equals(severity)) {
            return Severity.ERROR;
        }
        if (ISSUE.Severity_Warning.equals(severity)) {
            return Severity.WARNING;
        }
        if (ISSUE.Severity_Info.equals(severity)) {
            return Severity.INFO;
        }
        if (ISSUE.Severity_Note.equals(severity)) {
            return Severity.NOTE;
        }
        return null;
    }
}

